/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.brewinandchewin.keg;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.FluidRecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.github.wallev.maidsoulkitchen.vhelper.server.item.VItemStack;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;

@TaskClassAnalyzer(value=TaskInfo.BNC_KEY)
public class KegRecSerializerManager
extends FluidRecSerializerManager<KegFermentingRecipe> {
    private static final KegRecSerializerManager INSTANCE = new KegRecSerializerManager();

    protected KegRecSerializerManager() {
        super((RecipeType)BnCRecipeTypes.FERMENTING.get());
    }

    public static KegRecSerializerManager getInstance() {
        return INSTANCE;
    }

    @Override
    protected void initFluidRecs(Level level) {
        HashMap<Fluid, List> fluidItems1 = new HashMap<Fluid, List>();
        HashMap fluidContainers1 = new HashMap();
        for (Fluid fluid2 : ForgeRegistries.FLUIDS.getValues()) {
            ItemStack container;
            if (fluid2 instanceof EmptyFluid || (container = fluid2.m_6859_().m_7968_().getCraftingRemainingItem()).m_41619_()) continue;
            if (fluidContainers1.containsKey(fluid2)) {
                List itemStacks2 = fluidContainers1.getOrDefault(fluid2, Collections.emptyList());
                if (!itemStacks2.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                itemStacks2.add(container);
                continue;
            }
            fluidContainers1.put(fluid2, Lists.newArrayList((Object[])new ItemStack[]{container}));
        }
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack container;
            ItemStack defaultInstance = item.m_7968_().m_41777_();
            IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)defaultInstance.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
            if (iFluidHandlerItem == null || !(iFluidHandlerItem instanceof FluidBucketWrapper)) continue;
            FluidBucketWrapper fluidBucketWrapper = (FluidBucketWrapper)iFluidHandlerItem;
            FluidStack fluidStack = fluidBucketWrapper.getFluid();
            Fluid rawFluid = fluidStack.getRawFluid();
            if (fluidStack.isEmpty() || rawFluid instanceof EmptyFluid) continue;
            if (fluidItems1.containsKey(rawFluid)) {
                List fluidItems2 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                if (fluidItems2.stream().noneMatch(pair1 -> ((ItemStack)pair1.getFirst()).m_150930_(defaultInstance.m_41720_()))) {
                    ((List)fluidItems1.get(rawFluid)).add(Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount()));
                }
            } else {
                fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)defaultInstance, (Object)fluidStack.getAmount())}));
            }
            if ((container = fluidBucketWrapper.getContainer().getCraftingRemainingItem()).m_41619_()) continue;
            if (fluidContainers1.containsKey(rawFluid)) {
                List itemStacks3 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                if (!itemStacks3.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                itemStacks3.add(container);
                continue;
            }
            fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
        }
        List kettlePouringRecipes = level.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get());
        List kettleRecipes = level.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.FERMENTING.get());
        for (KegPouringRecipe kettlePouringRecipe : kettlePouringRecipes) {
            ItemStack container;
            Fluid rawFluid = kettlePouringRecipe.getRawFluid();
            if (rawFluid instanceof EmptyFluid) continue;
            ItemStack itemStack = kettlePouringRecipe.getOutput().m_41777_();
            if (!itemStack.m_41619_()) {
                if (fluidItems1.containsKey(rawFluid)) {
                    List itemStacks4 = fluidItems1.getOrDefault(rawFluid, Collections.emptyList());
                    if (itemStacks4.stream().noneMatch(itemStack1 -> ((ItemStack)itemStack1.getFirst()).m_150930_(itemStack.m_41720_()))) {
                        itemStacks4.add(Pair.of((Object)itemStack, (Object)kettlePouringRecipe.getAmount()));
                    }
                } else {
                    fluidItems1.put(rawFluid, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)itemStack, (Object)kettlePouringRecipe.getAmount())}));
                }
            }
            if ((container = VItemStack.copyWithCount(kettlePouringRecipe.getContainer(), 1)).m_41619_()) continue;
            if (fluidContainers1.containsKey(rawFluid)) {
                List itemStacks5 = fluidContainers1.getOrDefault(rawFluid, Collections.emptyList());
                if (!itemStacks5.stream().noneMatch(itemStack1 -> itemStack1.m_150930_(container.m_41720_()))) continue;
                itemStacks5.add(container);
                continue;
            }
            fluidContainers1.put(rawFluid, Lists.newArrayList((Object[])new ItemStack[]{container}));
        }
        this.fluidContainers = fluidContainers1;
        ArrayList<MKRecipe<KegFermentingRecipe>> mkRecipes = new ArrayList<MKRecipe<KegFermentingRecipe>>();
        for (KegFermentingRecipe recipe : kettleRecipes) {
            List<ItemStack> inFluids = Collections.emptyList();
            FluidStack fluidIn = recipe.getFluidIngredient();
            if (fluidIn != null && !fluidIn.isEmpty()) {
                if (fluidItems1.keySet().stream().anyMatch(fluid -> fluid.m_6212_(fluidIn.getFluid()))) {
                    ArrayList<ItemStack> fluidItems = new ArrayList<ItemStack>();
                    fluidItems1.forEach((fluid, itemStacks) -> {
                        if (fluid.m_6212_(fluidIn.getFluid())) {
                            for (Pair fluidStackPair : itemStacks) {
                                ItemStack outputFluidItem = ((ItemStack)fluidStackPair.getFirst()).m_41777_();
                                int amount = (Integer)fluidStackPair.getSecond();
                                int amountTotal = fluidIn.getAmount();
                                outputFluidItem.m_41764_(Math.max(1, amountTotal / amount));
                                if (!fluidItems.stream().noneMatch(itemStack -> itemStack.m_150930_(outputFluidItem.m_41720_()) && itemStack.m_41613_() == outputFluidItem.m_41613_())) continue;
                                fluidItems.add(outputFluidItem);
                            }
                        }
                    });
                    inFluids = fluidItems;
                } else {
                    ItemStack otherFluidItem = BnCFluidItemDisplays.getFluidItemDisplay((RegistryAccess)level.m_9598_(), (FluidStack)fluidIn);
                    inFluids = List.of(otherFluidItem);
                }
            }
            mkRecipes.add(this.createMKRecipe(recipe, inFluids));
        }
        this.recipes = mkRecipes;
    }

    @Override
    protected FluidRecSerializerManager.FluidRecipeInfoProvider<KegFermentingRecipe> createRecipeInfoProvider() {
        return new KegFermentationRecipeInfoProvider();
    }

    public static class KegFermentationRecipeInfoProvider
    extends FluidRecSerializerManager.FluidRecipeInfoProvider<KegFermentingRecipe> {
        @Override
        public Fluid getOutputFluid(RecSerializerManager<KegFermentingRecipe> rsm, KegFermentingRecipe rec) {
            return rec.getResultFluid();
        }
    }
}

