/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.gui.entity.maid.cook;

import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.client.gui.entity.maid.MaidTaskConfigGui;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.RecButton;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.RecsDetailButton;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.TImageButton;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.TypeButton;
import com.github.wallev.maidsoulkitchen.client.gui.widget.info.ResultInfo;
import com.github.wallev.maidsoulkitchen.client.gui.widget.info.Zone;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v0.CookData;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.CookDataV1;
import com.github.wallev.maidsoulkitchen.inventory.container.maid.CookConfigContainer;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.apache.commons.lang3.StringUtils;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
@OnlyIn(value=Dist.CLIENT)
public class CookConfigGui
extends MaidTaskConfigGui<CookConfigContainer> {
    private static final ResourceLocation TEXTURE = VResourceLocation.create("maidsoulkitchen", "textures/gui/cook_guide.png");
    protected final Zone taskDisplay = new Zone(6, 20, 70, 20);
    protected final Zone typeDisplay = new Zone(-4, 22, 18, 18);
    protected final Zone searchBoxDisplay = new Zone(-25, 22, 18, 18);
    protected final Zone searchTextDisplay = new Zone(-25, 22, 41, 18);
    protected final Zone resultDisplay = new Zone(6, 44, 152, 86);
    protected final Zone scrollDisplay = new Zone(161, 44, 9, 86);
    protected final ResultInfo ref = new ResultInfo(4, 7, 20, 20, 2, 2);
    private final List<MKRecipe<?>> detailRecs = new ArrayList();
    private final List<MKRecipe<?>> recipeList = new ArrayList();
    private final List<RecButton> parentButtons = new ArrayList<RecButton>();
    private final Map<ItemDefinition, List<MKRecipe<?>>> differentResult = new HashMap();
    private final Map<ItemDefinition, List<MKRecipe<?>>> flatRecsMap = new HashMap();
    private final List<List<MKRecipe<?>>> flatRecs = new ArrayList();
    private RecsDetailButton detailButton;
    private EditBox searchBox;
    private CookDataV1 cookData;
    private ICookTask<?, ?> cookTask;
    private boolean initCookData = true;
    private DisplayMode displayMode = DisplayMode.DEFAULT;

    public CookConfigGui(CookConfigContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, (Component)VComponent.translatable("gui.maidsoulkitchen.cook_setting_screen.title"));
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    protected void initAdditionData() {
        super.initAdditionData();
        this.initCookData();
        this.initRecipeList();
    }

    private void initCookData() {
        if (!this.initCookData) {
            return;
        }
        this.cookTask = (ICookTask)this.task;
        this.cookData = this.cookTask.getTaskData(this.maid);
    }

    private void initRecipeList() {
        this.recipeList.clear();
        this.recipeList.addAll(this.collectRecs());
        this.differentResult.clear();
        this.differentResult.putAll(this.createDifferentResult());
        this.flatRecsMap.clear();
        this.flatRecsMap.putAll(this.collectFlatRecs());
        this.flatRecs.clear();
        this.flatRecs.addAll(this.flatRecsMap.values());
    }

    private Map<ItemDefinition, List<MKRecipe<?>>> createDifferentResult() {
        return this.cookTask.getRecipes(this.maid).stream().collect(Collectors.groupingBy(r -> ItemDefinition.of(r.output())));
    }

    private Map<ItemDefinition, List<MKRecipe<?>>> collectFlatRecs() {
        return this.recipeList.stream().collect(Collectors.groupingBy(r -> ItemDefinition.of(r.output())));
    }

    private List<MKRecipe<?>> collectRecs() {
        switch (this.displayMode) {
            case CAN_COOK: {
                return this.getRecsByMode(recipe -> this.cookData.canCook((Recipe<?>)recipe));
            }
            case NOT_COOK: {
                return this.getRecsByMode(recipe -> !this.cookData.canCook((Recipe<?>)recipe));
            }
        }
        return this.getDefaultRecs();
    }

    private List<MKRecipe<?>> getRecsByMode(Predicate<Recipe<?>> recipeTest) {
        List<MKRecipe<?>> list = this.cookTask.getRecipes(this.maid).stream().filter(recipe -> recipeTest.test((Recipe<?>)recipe.rec())).toList();
        return list;
    }

    private void setDisplayMode(DisplayMode mode) {
        this.displayMode = mode;
    }

    private List<MKRecipe<?>> getDefaultRecs() {
        List<MKRecipe<?>> allRecipe = this.cookTask.getRecipes(this.maid);
        if (this.searchBox != null && StringUtils.isNotBlank((CharSequence)this.searchBox.m_94155_())) {
            String search = this.searchBox.m_94155_().toLowerCase(Locale.US);
            List<MKRecipe<?>> list = allRecipe.stream().filter(recipe -> recipe.output().m_41611_().getString().toLowerCase(Locale.US).contains(search)).toList();
            return list;
        }
        return allRecipe;
    }

    @Override
    protected void initAdditionWidgets() {
        super.initAdditionWidgets();
        this.addTaskInfoButton();
        this.addSearchTextBox();
        this.addSearchBox();
        this.addTypeButton();
        this.addResultInfo();
        this.addScrollButton();
        this.addInfoButton();
        this.addJeiButton();
        if (!this.detailRecs.isEmpty()) {
            this.parentButtons.forEach(b -> {
                b.f_93623_ = false;
            });
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderAddition(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderSearchSearchText(graphics, mouseX, mouseY, partialTicks);
        this.renderSearchBox(graphics);
        this.drawSplitZoneCard(graphics);
        this.drawScrollInfoBar(graphics);
    }

    protected void renderAdditionTransTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        boolean isCookSettingMainZone;
        int startX = this.f_96543_ - this.f_97735_ - -this.searchBoxDisplay.startX() - this.searchBoxDisplay.width() - 1;
        int startY = this.visualZone.startY() + this.searchBoxDisplay.startY();
        if (this.searchBox.m_94213_()) {
            startX -= this.searchTextDisplay.width();
        }
        int finalStartX = startX;
        boolean bl = isCookSettingMainZone = mouseX >= startX && mouseY >= startY && mouseX < startX + this.searchBoxDisplay.width() && mouseY < startY + this.searchBoxDisplay.height();
        if (isCookSettingMainZone) {
            graphics.m_280666_(this.f_96547_, this.getDisplayModeTooltips(), mouseX, mouseY);
        }
        this.setHoverSlot();
    }

    private void setHoverSlot() {
        this.parentButtons.forEach(b -> {
            if (b.isTooltipHovered()) {
                this.f_97734_ = b.virtualSlot;
            }
        });
        if (this.detailButton != null && !this.detailRecs.isEmpty()) {
            this.detailButton.getRecsButtons().forEach(b -> {
                if (b.isTooltipHovered()) {
                    this.f_97734_ = b.virtualSlot;
                }
            });
        }
    }

    private List<Component> getDisplayModeTooltips() {
        ArrayList components = Lists.newArrayList((Object[])new Component[]{VComponent.translatable("gui.maidsoulkitchen.btn.display.tooltip.1"), VComponent.translatable("gui.maidsoulkitchen.btn.display.tooltip.2")});
        for (DisplayMode value : DisplayMode.values()) {
            MutableComponent component = value.getComponent(this.displayMode);
            int size = 0;
            switch (value) {
                case CAN_COOK: {
                    size = this.getRecsByMode2DisplayTooltip(r -> this.cookData.canCook((Recipe<?>)r)).size();
                    break;
                }
                case NOT_COOK: {
                    size = this.getRecsByMode2DisplayTooltip(r -> !this.cookData.canCook((Recipe<?>)r)).size();
                    break;
                }
                case DEFAULT: {
                    size = this.differentResult.size();
                }
            }
            components.add(component.m_130946_("(" + size + ")"));
        }
        return components;
    }

    private List<List<MKRecipe<?>>> getRecsByMode2DisplayTooltip(Predicate<Recipe<?>> recipeTest) {
        return this.differentResult.values().stream().filter(recs -> {
            for (MKRecipe rec : recs) {
                if (!recipeTest.test((Recipe<?>)rec.rec())) continue;
                return true;
            }
            return false;
        }).toList();
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        super.m_7286_(pGuiGraphics, pPartialTick, pMouseX, pMouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean isCookSettingMainZone;
        if (this.detailButton != null && this.detailButton.needActive()) {
            return false;
        }
        if (super.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        boolean bl = isCookSettingMainZone = mouseX >= (double)this.visualZone.startX() && mouseY >= (double)this.visualZone.startY() && mouseX < (double)(this.visualZone.startX() + this.visualZone.width()) && mouseY < (double)(this.visualZone.startY() + this.visualZone.height());
        if (delta != 0.0 && isCookSettingMainZone) {
            if (delta > 0.0 && this.solIndex > 0) {
                --this.solIndex;
                this.m_7856_();
                return true;
            }
            if (delta < 0.0 && this.solIndex < (this.flatRecs.size() - 1) / (this.ref.col() * this.ref.row())) {
                ++this.solIndex;
                this.m_7856_();
                return true;
            }
        }
        return false;
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        String value = this.searchBox.m_94155_();
        this.searchBox.m_94144_(value);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.searchBox.m_94120_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchBox.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.searchBox);
            return true;
        }
        if (this.searchBox.m_93696_()) {
            this.searchBox.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox == null) {
            return false;
        }
        String perText = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(codePoint, modifiers)) {
            if (!Objects.equals(perText, this.searchBox.m_94155_())) {
                this.solIndex = 0;
                this.displayMode = DisplayMode.DEFAULT;
                this.m_7856_();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean hasKeyCode = InputConstants.m_84827_((int)keyCode, (int)scanCode).m_84876_().isPresent();
        String preText = this.searchBox.m_94155_();
        if (hasKeyCode) {
            return true;
        }
        if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(preText, this.searchBox.m_94155_())) {
                this.solIndex = 0;
                this.displayMode = DisplayMode.DEFAULT;
                this.m_7856_();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && keyCode != 256 || super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_6697_(String text, boolean overwrite) {
        if (overwrite) {
            this.searchBox.m_94144_(text);
        } else {
            this.searchBox.m_94164_(text);
        }
    }

    private void addInfoButton() {
        if (this.cookTask.getWarnComponent().isEmpty()) {
            return;
        }
        TImageButton infoButton = new TImageButton(this.cookTask, this.visualZone.startX() + this.visualZone.width() - 15, this.visualZone.startY() + 5, 9, 9, 237, 212, 10, TEXTURE, b -> {});
        this.m_142416_((GuiEventListener)infoButton);
    }

    private void addJeiButton() {
    }

    private void addTaskInfoButton() {
        int startX = this.visualZone.startX() + this.taskDisplay.startX();
        int startY = this.visualZone.startY() + this.taskDisplay.startY();
    }

    private void addSearchTextBox() {
        final int startX = this.f_96543_ - this.f_97735_ - -this.searchTextDisplay.startX() - this.searchTextDisplay.width() - 1;
        final int startY = this.visualZone.startY() + this.searchTextDisplay.startY();
        String textCache = this.searchBox == null ? "" : this.searchBox.m_94155_();
        boolean visible = this.searchBox != null && this.searchBox.m_94213_();
        boolean focus = this.searchBox != null && this.searchBox.m_93696_();
        this.searchBox = new EditBox(this.getMinecraft().f_91062_, startX, startY, this.searchTextDisplay.width(), this.searchTextDisplay.height(), (Component)Component.m_237119_()){

            public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                if (this.m_94213_()) {
                    pGuiGraphics.m_280218_(TEXTURE, startX - CookConfigGui.this.searchBoxDisplay.width(), startY, 40, 232, 59, 18);
                    super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                }
            }

            public int m_252907_() {
                return super.m_252907_() + 5;
            }

            public int m_252754_() {
                return super.m_252754_() + 3;
            }

            public boolean m_5953_(double pMouseX, double pMouseY) {
                return this.f_93624_ && pMouseX >= (double)startX && pMouseX < (double)(startX + this.f_93618_) && pMouseY >= (double)startY && pMouseY < (double)(startY + this.f_93619_);
            }
        };
        this.searchBox.m_94194_(visible);
        this.searchBox.m_93692_(focus);
        this.searchBox.m_94144_(textCache);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(15986656);
        this.m_7787_((GuiEventListener)this.searchBox);
    }

    private void addSearchBox() {
        int startX = this.f_96543_ - this.f_97735_ - -this.searchBoxDisplay.startX() - this.searchBoxDisplay.width() - 1;
        int startY = this.visualZone.startY() + this.searchBoxDisplay.startY();
        if (this.searchBox.m_94213_()) {
            startX -= this.searchTextDisplay.width();
        }
        final int finalStartX = startX;
        StateSwitchingButton typeButton = new StateSwitchingButton(finalStartX, startY, this.searchBoxDisplay.width(), this.searchBoxDisplay.height(), this.searchBox.m_94213_()){

            public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            }

            public void m_5716_(double pMouseX, double pMouseY) {
                boolean bl = this.f_94609_ = !this.f_94609_;
                if (this.f_94609_) {
                    this.m_252865_(finalStartX - CookConfigGui.this.searchTextDisplay.width());
                    CookConfigGui.this.searchBox.m_94194_(true);
                    CookConfigGui.this.searchBox.m_93692_(true);
                    CookConfigGui.this.searchBox.m_94201_();
                    CookConfigGui.this.m_7856_();
                } else {
                    this.m_252865_(finalStartX);
                    CookConfigGui.this.searchBox.m_94194_(false);
                    CookConfigGui.this.searchBox.m_93692_(false);
                    CookConfigGui.this.searchBox.m_94144_("");
                    CookConfigGui.this.m_7856_();
                }
            }

            public boolean m_6050_(double mouseX, double mouseY, double delta) {
                boolean isCookSettingMainZone;
                boolean bl = isCookSettingMainZone = mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + this.m_5711_()) && mouseY < (double)(this.m_252907_() + this.m_93694_());
                if (delta != 0.0 && isCookSettingMainZone) {
                    if (delta > 0.0) {
                        CookConfigGui.this.setDisplayMode(CookConfigGui.this.displayMode.pre());
                        CookConfigGui.this.solIndex = 0;
                        CookConfigGui.this.m_7856_();
                        return true;
                    }
                    if (delta < 0.0) {
                        CookConfigGui.this.setDisplayMode(CookConfigGui.this.displayMode.next());
                        CookConfigGui.this.solIndex = 0;
                        CookConfigGui.this.m_7856_();
                        return true;
                    }
                }
                return false;
            }
        };
        this.m_142416_((GuiEventListener)typeButton);
    }

    private void addTypeButton() {
        int startX = this.f_96543_ - this.f_97735_ - -this.typeDisplay.startX() - this.typeDisplay.width() - 1;
        int startY = this.visualZone.startY() + this.typeDisplay.startY();
        TypeButton typeButton = new TypeButton(startX, startY, this.typeDisplay.width(), this.typeDisplay.height(), this.cookData.mode().equals(CookData.Mode.WHITELIST.name)){

            public void m_5716_(double mouseX, double mouseY) {
                CookConfigGui.this.initCookData = false;
                CookConfigGui.this.setAndSyncMode(!this.isSelected);
                this.toggleState();
                CookConfigGui.this.displayMode = DisplayMode.DEFAULT;
                CookConfigGui.this.m_7856_();
                CookConfigGui.this.initCookData = true;
            }
        };
        this.m_142416_((GuiEventListener)typeButton);
    }

    private void setAndSyncMode(String mode) {
        this.cookData.setMode(mode);
    }

    private void setAndSyncMode(boolean isSelected) {
        this.setAndSyncMode(isSelected ? CookData.Mode.WHITELIST.name : CookData.Mode.BLACKLIST.name);
    }

    private void addResultInfo() {
        this.parentButtons.clear();
        int startX = this.visualZone.startX() + this.resultDisplay.startX();
        int startY = this.visualZone.startY() + this.resultDisplay.startY();
        int w = this.ref.col() * this.ref.rowWidth() + this.ref.rowSpacing() * (this.ref.col() - 1);
        int h = this.ref.row() * this.ref.colHeight() + this.ref.colSpacing() * (this.ref.row() - 1);
        int x = startX;
        int y = startY;
        this.detailButton = new RecsDetailButton(x, y, w, h, this.maid, this.cookTask, null){

            @Override
            public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                if (!this.f_93623_ || !this.f_93624_) {
                    return false;
                }
                if (!this.superClicked(pMouseX, pMouseY)) {
                    CookConfigGui.this.detailRecs.clear();
                    this.setCanAction(false);
                    CookConfigGui.this.parentButtons.forEach(b -> {
                        b.f_93623_ = true;
                    });
                    return true;
                }
                if (pButton == 1) {
                    for (RecButton b2 : this.recsButtons) {
                        if (!b2.superClicked(pMouseX, pMouseY) || !b2.debugClicked()) continue;
                        return false;
                    }
                    return false;
                }
                return super.m_6375_(pMouseX, pMouseY, pButton);
            }
        };
        if (!this.detailRecs.isEmpty()) {
            this.detailButton.setRecs(this.detailRecs);
            this.detailButton.setCanAction(true);
            this.parentButtons.forEach(b -> {
                b.f_93623_ = false;
            });
        }
        int index = this.solIndex * (this.ref.row() * this.ref.col());
        block0: for (int row = 0; row < this.ref.row(); ++row) {
            for (int col = 0; col < this.ref.col(); ++col) {
                if (index >= this.flatRecs.size()) break block0;
                List<MKRecipe<?>> recipes = this.flatRecs.get(index++);
                int x2 = startX + (this.ref.rowWidth() + this.ref.rowSpacing()) * col;
                int y2 = startY + (this.ref.colHeight() + this.ref.colSpacing()) * row;
                RecButton recButton = new RecButton(this.maid, this.cookTask, this.cookData, recipes, x2, y2){

                    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                        if (!this.f_93623_ || !this.f_93624_) {
                            return false;
                        }
                        if (pButton == 1) {
                            if (this.superClicked(pMouseX, pMouseY) && this.debugClicked()) {
                                return false;
                            }
                            if (this.superClicked(pMouseX, pMouseY)) {
                                this.m_7435_(Minecraft.m_91087_().m_91106_());
                                CookConfigGui.this.detailRecs.clear();
                                CookConfigGui.this.detailRecs.addAll(this.recipes);
                                CookConfigGui.this.detailButton.setRecs(this.recipes);
                                CookConfigGui.this.detailButton.setCanAction(true);
                                CookConfigGui.this.parentButtons.forEach(b -> {
                                    b.f_93623_ = false;
                                });
                                return true;
                            }
                            return false;
                        }
                        return super.m_6375_(pMouseX, pMouseY, pButton);
                    }
                };
                this.parentButtons.add(recButton);
            }
        }
        this.parentButtons.forEach(x$0 -> {
            RecButton cfr_ignored_0 = (RecButton)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_142416_((GuiEventListener)this.detailButton);
    }

    protected void m_280072_(GuiGraphics graphics, int x, int y) {
        super.m_280072_(graphics, x, y);
    }

    private void addScrollButton() {
        int startX = this.visualZone.startX() + this.scrollDisplay.startX();
        int startY = this.visualZone.startY() + this.scrollDisplay.startY();
        ImageButton upButton = new ImageButton(startX, startY, 9, 7, 199, 74, 14, TEXTURE, b -> {
            if (this.solIndex > 0) {
                --this.solIndex;
                this.m_7856_();
            }
        });
        ImageButton downButton = new ImageButton(startX, startY + 8 + 1 + 70, 9, 7, 208, 74, 14, TEXTURE, b -> {
            if (this.solIndex < (this.flatRecs.size() - 1) / (this.ref.col() * this.ref.row())) {
                ++this.solIndex;
                this.m_7856_();
            }
        });
        this.m_142416_((GuiEventListener)upButton);
        this.m_142416_((GuiEventListener)downButton);
    }

    private void renderSearchSearchText(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.searchBox == null) {
            return;
        }
        int startX = this.f_96543_ - this.f_97735_ - -this.searchTextDisplay.startX() - this.searchTextDisplay.width() - 1;
        int startY = this.visualZone.startY() + this.searchTextDisplay.startY();
        this.searchBox.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.searchBox.m_94213_() && this.searchBox.m_94155_().isEmpty() && !this.searchBox.m_93696_()) {
            graphics.m_280430_(this.f_96547_, (Component)VComponent.translatable("gui.maidsoulkitchen.search").m_130940_(ChatFormatting.ITALIC), startX + 3, startY + 5, 0xF5F5F5);
        }
    }

    private void renderSearchBox(GuiGraphics graphics) {
        if (this.searchBox == null) {
            return;
        }
        int startX = this.f_96543_ - this.f_97735_ - -this.searchBoxDisplay.startX() - this.searchBoxDisplay.width() - 1;
        int startY = this.visualZone.startY() + this.searchBoxDisplay.startY();
        if (this.searchBox.m_94213_()) {
            startX -= this.searchTextDisplay.width();
        } else {
            graphics.m_280218_(TEXTURE, startX, startY, 0, 232, 18, 18);
        }
        graphics.m_280218_(TEXTURE, startX + 1, startY + 1, 0, 181, 16, 16);
    }

    private void drawSplitZoneCard(GuiGraphics graphics) {
        int startX = this.f_96543_ - this.f_97735_ - -this.typeDisplay.startX() - this.typeDisplay.width() - 2;
        int startY = this.visualZone.startY() + this.typeDisplay.startY();
        graphics.m_280509_(startX - 1, startY, startX, startY + this.typeDisplay.width(), Color.BLACK.getRGB());
    }

    private void drawScrollInfoBar(GuiGraphics graphics) {
        int startX = this.visualZone.startX() + this.scrollDisplay.startX();
        int startY = this.visualZone.startY() + this.scrollDisplay.startY();
        graphics.m_280218_(TEXTURE, startX, startY + 8, 189, 64, 9, 70);
        this.drawScrollIndicator(graphics, startX + 1, startY + 8 + 1);
    }

    private void drawScrollIndicator(GuiGraphics graphics, int startX, int startY) {
        if ((this.flatRecs.size() - 1) / (this.ref.col() * this.ref.row()) >= 1) {
            graphics.m_280218_(TEXTURE, startX, startY + (int)(59.0f * this.getCurrentScroll()), 199, 64, 7, 9);
        } else {
            graphics.m_280218_(TEXTURE, startX, startY, 206, 64, 7, 9);
        }
    }

    private float getCurrentScroll() {
        return Mth.m_14036_((float)((float)((double)this.solIndex * (1.0 / (double)((this.flatRecs.size() - 1) / (this.ref.col() * this.ref.row()))))), (float)0.0f, (float)1.0f);
    }

    public static enum DisplayMode {
        DEFAULT,
        CAN_COOK,
        NOT_COOK;


        public MutableComponent getComponent() {
            return VComponent.translatable("gui.maidsoulkitchen.btn.display.mode." + this.name().toLowerCase(Locale.ROOT));
        }

        public MutableComponent getComponent(DisplayMode mode) {
            MutableComponent component1 = this.getComponent();
            if (mode == this) {
                return component1.m_130940_(ChatFormatting.DARK_GREEN);
            }
            return component1.m_130940_(ChatFormatting.GRAY);
        }

        public DisplayMode next() {
            DisplayMode[] modes = DisplayMode.values();
            return modes[(this.ordinal() + 1) % modes.length];
        }

        public DisplayMode pre() {
            DisplayMode[] modes = DisplayMode.values();
            return modes[(this.ordinal() - 1 + modes.length) % modes.length];
        }
    }
}

