/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.kaleidoscopecookery.cookery;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.ingredient.RecIngredient;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.itemdown.RecDataUse;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.IndexRange;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.ItemAmount;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidItem;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.recipe.PotRecipe;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@TaskClassAnalyzer(value=TaskInfo.KC_POT)
public class PotRecSerializerManager
extends RecSerializerManager<PotRecipe> {
    private static final PotRecSerializerManager INSTANCE = new PotRecSerializerManager();

    protected PotRecSerializerManager() {
        super(ModRecipes.POT_RECIPE);
    }

    public static PotRecSerializerManager getInstance() {
        return INSTANCE;
    }

    @Override
    public LinkedList<MaidRec> createMaidRecs(List<MKRecipe<PotRecipe>> recs, Map<ItemDefinition, Long> available, BiConsumer<MKRecipe<PotRecipe>, IndexRange> successAdd, Predicate<MKRecipe<PotRecipe>> rIsValid, Predicate<RecDataUse> recDataUsePredicate, Consumer<Boolean> doneConsumer) {
        if (!available.containsKey(PotRecipeInfoProvider.getKitchenShovelDef())) {
            doneConsumer.accept(true);
            return EMPTY_LIST;
        }
        return super.createMaidRecs(recs, available, successAdd, rIsValid, recDataUsePredicate, doneConsumer);
    }

    @Override
    protected boolean processRecIngres(MKRecipe<PotRecipe> r, Map<ItemDefinition, Long> available, List<ItemDefinition> invIngredient, boolean[] single, Map<ItemDefinition, ItemAmount> itemTimes) {
        return super.processRecIngres(r, available, invIngredient, single, itemTimes);
    }

    @Override
    protected List<MaidRec> createCookRec(MKRecipe<PotRecipe> r, Map<ItemDefinition, Long> available, boolean[] single, List<ItemDefinition> invIngredient, Map<ItemDefinition, ItemAmount> itemTimes) {
        int canCookAmount;
        ItemStack result = r.output();
        ArrayList<MaidItem> maidItems = new ArrayList<MaidItem>();
        int amount = canCookAmount = this.getMaxAmount(available, single, itemTimes);
        boolean isSingle = single[0] || r.isSingle();
        int endAmount = 1;
        if (isSingle) {
            amount = 1;
            endAmount = canCookAmount;
        }
        for (ItemDefinition definition : invIngredient) {
            ItemAmount itemAmount = itemTimes.get(definition);
            itemAmount.setRecAmount(amount);
            int minAmount = itemAmount.getAmount();
            int count = amount * minAmount;
            maidItems.add(new MaidItem(definition, count));
            available.put(definition, available.get(definition) - (long)count * (long)endAmount);
        }
        maidItems.remove(0);
        if (r.rec().isNeedBowl()) {
            maidItems.remove(maidItems.size() - 1);
        }
        ItemAmount itemAmount = new ItemAmount(1);
        itemAmount.setTool(true);
        itemTimes.put(PotRecipeInfoProvider.getKitchenShovelDef(), itemAmount);
        MaidRec maidRec = new MaidRec((Recipe<?>)r.rec(), r.rec().getTime(), result, amount, PotRecipeInfoProvider.getOil().m_7968_(), PotRecipeInfoProvider.getKitchenShovel().m_7968_(), PotRecipeInfoProvider.getContainer().m_7968_(), (List<MaidItem>)maidItems, MaidItem.EMPTY);
        return this.generateRecs(maidRec, endAmount);
    }

    protected PotRecipeInfoProvider createRecipeInfoProvider() {
        return new PotRecipeInfoProvider();
    }

    public static class PotRecipeInfoProvider
    extends RecSerializerManager.RecipeInfoProvider<PotRecipe> {
        private static Item OIL;
        private static Ingredient OIL_IND;
        private static Item CONTAINER;
        private static Item KITCHEN_SHOVEL;
        private static Item FLINT;
        private static Ingredient CONTAINER_INGREDIENT;
        private static ItemDefinition KITCHEN_SHOVEL_DEF;

        public static Item getOil() {
            if (OIL == null) {
                OIL = (Item)ModItems.OIL.get();
            }
            return OIL;
        }

        public static Ingredient getOilIngredient() {
            if (OIL_IND == null) {
                OIL_IND = Ingredient.m_43929_((ItemLike[])new ItemLike[]{PotRecipeInfoProvider.getOil()});
            }
            return OIL_IND;
        }

        public static Item getContainer() {
            if (CONTAINER == null) {
                CONTAINER = Items.f_42399_;
            }
            return CONTAINER;
        }

        public static Item getKitchenShovel() {
            if (KITCHEN_SHOVEL == null) {
                KITCHEN_SHOVEL = (Item)ModItems.KITCHEN_SHOVEL.get();
            }
            return KITCHEN_SHOVEL;
        }

        public static Item getFlint() {
            if (FLINT == null) {
                FLINT = Items.f_42484_;
            }
            return FLINT;
        }

        public static Ingredient getContainerIngredient() {
            if (CONTAINER_INGREDIENT == null) {
                CONTAINER_INGREDIENT = Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotRecipeInfoProvider.getContainer().m_7968_()});
            }
            return CONTAINER_INGREDIENT;
        }

        public static ItemDefinition getKitchenShovelDef() {
            if (KITCHEN_SHOVEL_DEF == null) {
                KITCHEN_SHOVEL_DEF = ItemDefinition.of(PotRecipeInfoProvider.getKitchenShovel().m_7968_());
            }
            return KITCHEN_SHOVEL_DEF;
        }

        @Override
        public List<RecIngredient> getIngredients(RecSerializerManager<PotRecipe> rsm, PotRecipe rec) {
            ArrayList<Ingredient> list = new ArrayList<Ingredient>();
            list.add(PotRecipeInfoProvider.getOilIngredient());
            for (Ingredient ingredient : rec.m_7527_()) {
                if (ingredient.m_43947_()) continue;
                list.add(ingredient);
            }
            if (rec.isNeedBowl()) {
                list.add(PotRecipeInfoProvider.getContainerIngredient());
            }
            return RecIngredient.from(list);
        }

        @Override
        public boolean isSingle(RecSerializerManager<PotRecipe> rsm, PotRecipe rec) {
            return true;
        }
    }
}

