/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.advancement.AdvancementTypes;
import studio.fantasyit.maid_storage_manager.items.StorageDefineBauble;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.PosUtil;

public class StorageAccessUtil {
    public static TagKey<Block> allowTag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation("maid_storage_manager", "default_storage_blocks"));
    private static HashMap<BlockPos, List<BlockPos>> cacheNearby = new HashMap();
    private static long cachedTickCount = -1L;

    public static List<Pair<Target, ItemStack>> getMarksForPosSet(Level level, Target target, List<BlockPos> posSet) {
        AABB aabb = AABB.m_165882_((Vec3)target.pos.m_252807_(), (double)5.0, (double)5.0, (double)5.0);
        List frames = level.m_142425_(EntityTypeTest.m_156916_(ItemFrame.class), aabb, itemFrame -> {
            if (target.side != null && target.side != itemFrame.m_6350_()) {
                return false;
            }
            BlockPos relative = itemFrame.m_20183_().m_5484_(itemFrame.m_6350_(), -1);
            return posSet.stream().anyMatch(t -> t.equals((Object)relative));
        });
        return frames.stream().map(frame -> {
            ItemStack t = frame.m_31822_();
            if (t.m_150930_((Item)ItemRegistry.FILTER_LIST.get()) || t.m_150930_((Item)ItemRegistry.NO_ACCESS.get()) || t.m_150930_((Item)ItemRegistry.ALLOW_ACCESS.get())) {
                BlockPos relative = frame.m_20183_().m_5484_(frame.m_6350_(), -1);
                return new Pair((Object)target.sameType(relative, frame.m_6350_()), (Object)t);
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public static List<Pair<Target, ItemStack>> getMarksWithSameContainer(Level level, Target target) {
        ArrayList<BlockPos> samePos = new ArrayList<BlockPos>(List.of(target.pos));
        StorageAccessUtil.checkNearByContainers(level, target.pos, samePos::add);
        return StorageAccessUtil.getMarksForPosSet(level, target, samePos);
    }

    public static List<Target> markedTargetOf(ServerLevel level, EntityMaid maid, Target target, boolean bypassNoAccess) {
        List<Pair<Target, ItemStack>> marks = StorageAccessUtil.getMarksWithSameContainer((Level)level, target);
        ArrayList<Target> list = new ArrayList<Target>();
        boolean hasAllowAccess = false;
        boolean hasNoAccess = false;
        for (Pair<Target, ItemStack> ti : marks) {
            if (!((ItemStack)ti.getB()).m_150930_((Item)ItemRegistry.ALLOW_ACCESS.get())) continue;
            list.add((Target)ti.getA());
            hasAllowAccess = true;
        }
        for (Pair<Target, ItemStack> ti : marks) {
            if (!((ItemStack)ti.getB()).m_150930_((Item)ItemRegistry.NO_ACCESS.get())) continue;
            hasNoAccess = true;
            if (bypassNoAccess) continue;
            list = null;
        }
        if (hasAllowAccess && hasNoAccess) {
            AdvancementTypes.triggerForMaid(maid, "left_right_brains_fight");
        }
        return list;
    }

    public static List<Target> findTargetRewrite(ServerLevel level, EntityMaid maid, Target target, boolean bypassNoAccess) {
        List<Target> result;
        CompoundTag tag;
        ItemStack stack;
        BaubleItemHandler maidBauble = maid.getMaidBauble();
        ArrayList<ItemStack> itemStack = new ArrayList<ItemStack>();
        for (int i = 0; i < maidBauble.getSlots(); ++i) {
            if (!maidBauble.getStackInSlot(i).m_150930_((Item)ItemRegistry.STORAGE_DEFINE_BAUBLE.get())) continue;
            itemStack.add(maidBauble.getStackInSlot(i));
        }
        if (maid.m_21205_().m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) && !(stack = ItemStackUtil.parseStack((tag = maid.m_21205_().m_41784_()).m_128469_("storage_define"))).m_41619_()) {
            itemStack.add(stack);
        }
        if ((result = StorageAccessUtil.markedTargetOf(level, maid, target, bypassNoAccess)) != null) {
            if (Config.useAllStorageByDefault || level.m_8055_(target.getPos()).m_204336_(allowTag)) {
                result.add(target);
            }
        } else {
            result = new ArrayList<Target>();
        }
        if (itemStack.isEmpty()) {
            return result;
        }
        for (ItemStack stack2 : itemStack) {
            StorageDefineBauble.Mode mode = StorageDefineBauble.getMode(stack2);
            List<Target> storages = StorageDefineBauble.getStorages(stack2);
            List<Target> list = storages.stream().filter(storage -> storage.getPos().equals((Object)target.getPos())).toList();
            if (mode == StorageDefineBauble.Mode.REPLACE) {
                result.clear();
                result.addAll(list);
                continue;
            }
            if (mode == StorageDefineBauble.Mode.APPEND) {
                result.addAll(list);
                continue;
            }
            if (mode == StorageDefineBauble.Mode.REMOVE) {
                result.removeAll(list);
                continue;
            }
            if (mode != StorageDefineBauble.Mode.REPLACE_SPEC || list.isEmpty()) continue;
            result.clear();
            result.addAll(list);
        }
        return result;
    }

    public static boolean isValidTarget(ServerLevel level, EntityMaid maid, Target target, boolean bypassNoAccess) {
        List<Target> rewrite = StorageAccessUtil.findTargetRewrite(level, maid, target, bypassNoAccess);
        return rewrite.contains(target);
    }

    private static List<BlockPos> getNearByContainersCache(Level _level, BlockPos pos) {
        if (_level instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)_level;
            if ((long)level.m_7654_().m_129921_() != cachedTickCount) {
                cacheNearby.clear();
                cachedTickCount = level.m_7654_().m_129921_();
            } else if (cacheNearby.containsKey(pos)) {
                return cacheNearby.get(pos);
            }
        }
        return null;
    }

    private static void setNearByCache(Level level, BlockPos pos, List<BlockPos> list) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if ((long)serverLevel.m_7654_().m_129921_() != cachedTickCount) {
                cacheNearby.clear();
                cachedTickCount = serverLevel.m_7654_().m_129921_();
            }
            cacheNearby.put(pos, list);
        }
    }

    public static void checkNearByContainers(Level level, BlockPos pos, Consumer<BlockPos> consumer) {
        BlockState blockState = level.m_8055_(pos);
        if (!blockState.m_204336_(allowTag)) {
            return;
        }
        List<BlockPos> nearByContainersCache = StorageAccessUtil.getNearByContainersCache(level, pos);
        if (nearByContainersCache != null) {
            nearByContainersCache.forEach(consumer);
            return;
        }
        BlockEntity blockEntity1 = level.m_7702_(pos);
        if (blockEntity1 == null) {
            return;
        }
        @NotNull LazyOptional optCap = blockEntity1.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!optCap.isPresent()) {
            return;
        }
        IItemHandler inv = (IItemHandler)optCap.orElseThrow(RuntimeException::new);
        if ((double)inv.getStackInSlot(0).m_41613_() > 1.0E9) {
            return;
        }
        LinkedList<ItemStack> tmpExtracted = new LinkedList<ItemStack>();
        while (inv.getStackInSlot(0).m_41613_() > 0 && !inv.extractItem(0, inv.getStackInSlot(0).m_41613_(), true).m_41619_()) {
            tmpExtracted.add(inv.extractItem(0, inv.getStackInSlot(0).m_41613_(), false));
        }
        ItemStack markItem = Items.f_42398_.m_7968_().m_255036_(1);
        CompoundTag tag = markItem.m_41784_();
        tag.m_128362_("uuid", UUID.randomUUID());
        markItem.m_41751_(tag);
        inv.insertItem(0, markItem.m_41777_(), false);
        ArrayList list = new ArrayList();
        PosUtil.findAroundUpAndDown(pos, blockPos -> {
            if (blockPos.equals((Object)pos)) {
                return null;
            }
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity != null) {
                blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        if (!ItemStack.m_150942_((ItemStack)itemHandler.getStackInSlot(i), (ItemStack)markItem)) continue;
                        consumer.accept((BlockPos)blockPos);
                        list.add(blockPos);
                    }
                });
            }
            return null;
        }, 1);
        ItemStack itemStack = inv.extractItem(0, markItem.m_41613_(), true);
        if (itemStack.m_41619_() || !ItemStackUtil.isSame(itemStack, markItem, true)) {
            tmpExtracted.add(itemStack);
            InvUtil.tryExtract(inv, markItem, true);
        } else {
            inv.extractItem(0, markItem.m_41613_(), false);
        }
        while (!tmpExtracted.isEmpty()) {
            inv.insertItem(0, (ItemStack)tmpExtracted.poll(), false);
        }
        list.forEach(blockPos -> StorageAccessUtil.setNearByCache(level, blockPos, list));
    }

    public static Filter getFilterForTarget(Level level, Target target) {
        boolean isBlackMode;
        ArrayList<Object> filtered;
        List<Pair<Target, ItemStack>> marksWithSameContainer = StorageAccessUtil.getMarksWithSameContainer(level, target);
        if (marksWithSameContainer.isEmpty()) {
            filtered = new ArrayList<Pair<ItemStack, Boolean>>();
            isBlackMode = true;
        } else {
            List<CompoundTag> items = marksWithSameContainer.stream().map(Pair::getB).filter(t -> t.m_150930_((Item)ItemRegistry.FILTER_LIST.get())).map(ItemStack::m_41784_).toList();
            isBlackMode = items.stream().allMatch(t -> t.m_128471_("black_mode"));
            filtered = new ArrayList();
            items.stream().filter(t -> !t.m_128471_("black_mode")).forEach(t -> {
                ListTag list = t.m_128437_("items", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag tmp = list.m_128728_(i);
                    ItemStack item = ItemStackUtil.parseStack(tmp.m_128469_("item"));
                    filtered.add(new Pair((Object)item, (Object)t.m_128471_("match_tag")));
                }
            });
            items.stream().filter(t -> t.m_128471_("black_mode")).forEach(t -> {
                ListTag list = t.m_128437_("items", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag tmp = list.m_128728_(i);
                    ItemStack item = ItemStackUtil.parseStack(tmp.m_128469_("item"));
                    if (isBlackMode) {
                        filtered.add(new Pair((Object)item, (Object)t.m_128471_("match_tag")));
                        continue;
                    }
                    for (int j = 0; j < filtered.size(); ++j) {
                        Pair pair = (Pair)filtered.get(j);
                        if (!ItemStackUtil.isSame((ItemStack)pair.getA(), item, tmp.m_128471_("match_tag") && (Boolean)pair.getB() != false)) continue;
                        filtered.remove(pair);
                        --j;
                    }
                }
            });
        }
        return new Filter(filtered, isBlackMode);
    }

    public static class Filter {
        public List<Pair<ItemStack, Boolean>> filtered;
        public boolean isBlackMode;

        public Filter(List<Pair<ItemStack, Boolean>> filtered, boolean isBlackMode) {
            this.filtered = filtered;
            this.isBlackMode = isBlackMode;
        }

        public boolean isAvailable(ItemStack itemStack) {
            for (Pair<ItemStack, Boolean> pair : this.filtered) {
                if (!ItemStackUtil.isSame((ItemStack)pair.getA(), itemStack, (Boolean)pair.getB())) continue;
                return !this.isBlackMode;
            }
            return this.isBlackMode;
        }

        public boolean isWhitelist() {
            return !this.isBlackMode;
        }
    }
}

