/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.crafting_table;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.container.CountSlot;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class CraftingTableCraftMenu
extends AbstractCraftMenu<CraftingTableCraftMenu> {
    public CraftingTableCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_CRAFTING_TABLE.get(), p_38852_, player);
    }

    @Override
    protected void addFilterSlots() {
        int sx = 31;
        int sy = 50;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new FilterSlot(this.stepDataContainer, i * 3 + j, sx + j * 18, sy + i * 18));
            }
        }
        this.m_38897_(new FilterSlot(this.stepDataContainer, 9, 124, 68, true));
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(9), this.stepDataContainer));
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case SET_ALL_INPUT: {
                int i;
                ListTag list = data.m_128437_("inputs", 10);
                for (i = 0; i < list.size(); ++i) {
                    CompoundTag tag = list.m_128728_(i);
                    ItemStack stack = ItemStackUtil.parseStack(tag);
                    this.stepDataContainer.setItemNoTrigger(i, stack);
                }
                for (i = list.size(); i < this.stepDataContainer.m_6643_(); ++i) {
                    this.stepDataContainer.setItemNoTrigger(i, ItemStack.f_41583_);
                }
                this.save();
                break;
            }
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.save();
            }
        }
    }

    @Override
    public void recalculateRecipe() {
        Optional<CraftingRecipe> recipe = RecipeUtil.getCraftingRecipe(this.player.m_9236_(), RecipeUtil.wrapCraftingContainer(this.stepDataContainer, 3, 3));
        recipe.ifPresentOrElse(craftingRecipe -> {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            result.add(craftingRecipe.m_8043_(this.player.m_9236_().m_9598_()));
            NonNullList remain = craftingRecipe.m_7457_((Container)RecipeUtil.wrapCraftingContainer(this.stepDataContainer, 3, 3));
            remain.forEach(i -> ItemStackUtil.addToList((List<ItemStack>)result, i, true));
            for (int i2 = 0; i2 < this.stepDataContainer.outputCount; ++i2) {
                if (i2 < result.size()) {
                    this.stepDataContainer.setItemNoTrigger(i2 + this.stepDataContainer.inputCount, (ItemStack)result.get(i2));
                    this.stepDataContainer.setCount(i2 + this.stepDataContainer.inputCount, ((ItemStack)result.get(i2)).m_41613_());
                    continue;
                }
                this.stepDataContainer.setItemNoTrigger(i2 + this.stepDataContainer.inputCount, ItemStack.f_41583_);
                this.stepDataContainer.setCount(i2 + this.stepDataContainer.inputCount, 0);
            }
        }, () -> {
            for (int i = 0; i < this.stepDataContainer.outputCount; ++i) {
                this.stepDataContainer.setItemNoTrigger(i + this.stepDataContainer.inputCount, ItemStack.f_41583_);
                this.stepDataContainer.setCount(i + this.stepDataContainer.inputCount, 0);
            }
        });
    }
}

