/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.common;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.CraftAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.menu.container.FilterContainer;
import studio.fantasyit.maid_storage_manager.menu.container.ISaveFilter;

public class CommonStepDataContainer
extends FilterContainer
implements ISaveFilter {
    public CraftGuideStepData step;
    CraftAction actionType;
    public int inputCount = 0;
    public int padCount = 4;
    public int outputCount = 0;
    public List<ActionOption<?>> options = List.of();

    public CommonStepDataContainer(AbstractContainerMenu menu) {
        super(4, menu);
    }

    public void setStep(CraftGuideStepData step) {
        int i;
        this.step = step;
        this.actionType = step.actionType;
        this.recalculateSlots();
        for (i = 0; i < this.inputCount; ++i) {
            this.setItemNoTrigger(i, step.getInput().get(i));
            this.setCount(i, step.getInput().get(i).m_41613_());
        }
        for (i = 0; i < this.outputCount; ++i) {
            this.setItemNoTrigger(this.inputCount + this.padCount + i, step.getOutput().get(i));
            this.setCount(this.inputCount + this.padCount + i, step.getOutput().get(i).m_41613_());
        }
        this.options = this.actionType.options();
    }

    public void clearStep() {
        this.step = null;
        this.inputCount = 0;
        this.padCount = 4;
        this.outputCount = 0;
        for (int i = 0; i < 4; ++i) {
            this.setItemNoTrigger(i, ItemStack.f_41583_);
            this.setCount(i, 0);
        }
        this.options = List.of();
    }

    private void recalculateSlots() {
        this.inputCount = this.step.actionType.inputCount();
        this.outputCount = this.step.actionType.outputCount();
        this.padCount = this.inputCount + this.outputCount < 4 ? 4 - this.inputCount - this.outputCount : 0;
        if (this.inputCount + this.outputCount > 4) {
            this.outputCount = 4 - this.inputCount;
        }
        if (this.outputCount < 0) {
            this.outputCount = 0;
            this.inputCount = 4;
        }
    }

    @Override
    public int m_6643_() {
        return 4;
    }

    public void setAction(ResourceLocation action) {
        if (this.step == null) {
            return;
        }
        this.step.setAction(action);
        this.actionType = this.step.actionType;
        this.options = this.actionType.options();
        this.recalculateSlots();
        this.step.setExtraData(new CompoundTag());
    }

    @Override
    public void save() {
        if (this.inputCount != 0) {
            for (int i = 0; i < this.inputCount; ++i) {
                int count = this.count[i].getValue();
                this.step.setInput(i, this.m_8020_(i).m_255036_(count));
            }
        } else {
            this.step.clearInput();
        }
        int inputOffset = this.inputCount + this.padCount;
        if (this.outputCount != 0) {
            for (int i = 0; i < this.outputCount; ++i) {
                int count = this.count[inputOffset + i].getValue();
                this.step.setOutput(i, this.m_8020_(inputOffset + i).m_255036_(count));
            }
        } else {
            this.step.clearOutput();
        }
    }

    public void setOption(int index, int selection, String value) {
        this.options.get(index).setOptionSelectionId(this.step, selection);
        this.options.get(index).setOptionValue(this.step, value);
    }
}

