/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.altar;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.container.CountSlot;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class AltarCraftMenu
extends AbstractCraftMenu<AltarCraftMenu> {
    float ppcost = -1.0f;

    public AltarCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_ALTAR.get(), p_38852_, player);
    }

    @Override
    protected void addFilterSlots() {
        int i = 0;
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 28, 93));
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 28, 73));
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 48, 53));
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 68, 53));
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 88, 73));
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 88, 93));
        this.m_38897_(new FilterSlot(this.stepDataContainer, i++, 119, 42, true));
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(6), this.stepDataContainer));
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case SET_ALL_INPUT: {
                int i;
                ListTag list = data.m_128437_("inputs", 10);
                for (i = 0; i < list.size(); ++i) {
                    CompoundTag tag = list.m_128728_(i);
                    ItemStack stack = ItemStackUtil.parseStack(tag);
                    this.stepDataContainer.setItemNoTrigger(i, stack);
                }
                for (i = list.size(); i < this.stepDataContainer.m_6643_(); ++i) {
                    this.stepDataContainer.setItemNoTrigger(i, ItemStack.f_41583_);
                }
                this.save();
                break;
            }
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.save();
            }
        }
    }

    @Override
    public void recalculateRecipe() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.stepDataContainer.inputCount; ++i) {
            items.add(this.stepDataContainer.m_8020_(i));
        }
        Optional<AltarRecipe> recipe = RecipeUtil.getAltarRecipe(this.player.m_9236_(), RecipeUtil.wrapAltarRecipeInventory(items));
        recipe.ifPresentOrElse(craftingRecipe -> {
            ItemStack resultItem = craftingRecipe.m_8043_(this.player.m_9236_().m_9598_());
            this.stepDataContainer.setItemNoTrigger(6, resultItem);
            this.stepDataContainer.setCount(6, resultItem.m_41613_());
            this.ppcost = craftingRecipe.getPowerCost();
        }, () -> {
            this.stepDataContainer.setItemNoTrigger(6, ItemStack.f_41583_);
            this.ppcost = -1.0f;
        });
    }
}

