/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.find;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IMaidStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageCraftDataProvider;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageExtractableContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;
import studio.fantasyit.maid_storage_manager.util.ViewedInventoryUtil;

public class RequestFindBehavior
extends Behavior<EntityMaid> {
    BehaviorBreath breath = new BehaviorBreath();
    IStorageContext context;
    boolean canPick = false;
    Target target;
    ItemStack checkItem = null;

    public RequestFindBehavior() {
        super(Map.of());
    }

    protected boolean canStillUse(ServerLevel level, EntityMaid maid, long p_22547_) {
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(maid).isReturning()) {
            return false;
        }
        if (!InvUtil.hasAnyFree((IItemHandler)maid.getAvailableInv(false))) {
            return false;
        }
        if (!this.canPick) {
            return true;
        }
        return this.context != null && !this.context.isDone();
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (!MemoryUtil.getRequestProgress(maid).hasTarget()) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(maid).isReturning()) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(maid).isCheckingStock()) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTimeIn) {
        @Nullable IMaidStorage storage = Objects.requireNonNull(MaidStorage.getInstance().getStorage(MemoryUtil.getRequestProgress(maid).getTarget().getType()));
        if (!MemoryUtil.getRequestProgress(maid).hasTarget()) {
            return;
        }
        this.target = MemoryUtil.getRequestProgress(maid).getTarget();
        this.checkItem = MemoryUtil.getRequestProgress(maid).getCheckItem();
        if (this.checkItem.m_41619_()) {
            this.checkItem = null;
        }
        this.context = storage.onStartCollect(level, maid, this.target);
        if (this.context != null) {
            this.context.start(maid, level, this.target);
        }
        this.canPick = false;
    }

    protected void tick(ServerLevel level, EntityMaid maid, long p_22553_) {
        if (this.canPick) {
            this.tickPick(level, maid, p_22553_);
        } else {
            this.tickGather(level, maid, p_22553_);
            if (this.context.isDone()) {
                this.context.reset();
                this.canPick = true;
                if (this.context instanceof IStorageInteractContext) {
                    MemoryUtil.getViewedInventory(maid).resetViewedInvForPos(this.target);
                    StorageAccessUtil.checkNearByContainers((Level)level, this.target.getPos(), pos -> MemoryUtil.getViewedInventory(maid).resetViewedInvForPosAsRemoved(this.target.sameType((BlockPos)pos, null)));
                }
            }
        }
    }

    private void tickGather(ServerLevel level, EntityMaid maid, long p22553) {
        if (!this.breath.breathTick(maid)) {
            return;
        }
        Function<ItemStack, ItemStack> takeItem = itemStack -> {
            int maxStore;
            if (this.checkItem != null && ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.checkItem)) {
                this.checkItem = null;
            }
            if ((maxStore = InvUtil.maxCanPlace((IItemHandler)maid.getAvailableInv(false), itemStack)) > 0) {
                ItemStack copy = itemStack.m_41777_();
                ItemStack tmp = RequestListItem.updateCollectedItem(maid.m_21205_(), itemStack, maxStore, false);
                copy.m_41774_(tmp.m_41613_());
                ViewedInventoryUtil.ambitiousRemoveItemAndSync(maid, level, this.target, itemStack, copy.m_41613_());
                InvUtil.tryPlace((IItemHandler)maid.getAvailableInv(false), copy);
                return tmp;
            }
            return itemStack;
        };
        IStorageContext iStorageContext = this.context;
        if (iStorageContext instanceof IStorageInteractContext) {
            IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
            isic.tick(takeItem);
        } else {
            iStorageContext = this.context;
            if (iStorageContext instanceof IStorageExtractableContext) {
                IStorageExtractableContext isec = (IStorageExtractableContext)iStorageContext;
                if (isec.hasTask()) {
                    isec.tick(takeItem);
                } else {
                    List<Pair<ItemStack, Integer>> itemStacksNotDone = RequestListItem.getItemStacksNotDone(maid.m_21205_(), true);
                    isec.setExtract(itemStacksNotDone.stream().map(c -> ((ItemStack)c.getA()).m_255036_((Integer)c.getB() == -1 ? Integer.MAX_VALUE : (Integer)c.getB())).toList(), RequestListItem.getMatchType(maid.m_21205_()));
                }
            }
        }
    }

    private void tickPick(ServerLevel level, EntityMaid maid, long p_22550_) {
        if (!this.breath.breathTick(maid)) {
            return;
        }
        IStorageContext iStorageContext = this.context;
        if (iStorageContext instanceof IStorageCraftDataProvider) {
            IStorageCraftDataProvider ispcp = (IStorageCraftDataProvider)((Object)iStorageContext);
            ispcp.getCraftGuideData().forEach(craftGuideData -> MemoryUtil.getCrafting(maid).addCraftGuide((CraftGuideData)craftGuideData));
        } else {
            iStorageContext = this.context;
            if (iStorageContext instanceof IStorageInteractContext) {
                IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
                isic.tick(itemStack -> {
                    MemoryUtil.getViewedInventory(maid).addItem(this.target, (ItemStack)itemStack);
                    if (itemStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get())) {
                        MemoryUtil.getCrafting(maid).addCraftGuide(CraftGuideData.fromItemStack(itemStack));
                    }
                    return itemStack;
                });
            } else {
                iStorageContext = this.context;
                if (iStorageContext instanceof IStorageExtractableContext) {
                    IStorageExtractableContext isec = (IStorageExtractableContext)iStorageContext;
                    if (isec.hasTask()) {
                        isec.tick(itemStack -> {
                            if (itemStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get())) {
                                MemoryUtil.getCrafting(maid).addCraftGuide(CraftGuideData.fromItemStack(itemStack));
                            }
                            return itemStack;
                        });
                    } else {
                        isec.setExtract(List.of(((Item)ItemRegistry.CRAFT_GUIDE.get()).m_7968_()), ItemStackUtil.MATCH_TYPE.NOT_MATCHING);
                    }
                }
            }
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        super.m_6732_(level, (LivingEntity)maid, p_22550_);
        if (this.context != null) {
            this.context.finish();
            if (this.context.isDone()) {
                Target target = MemoryUtil.getRequestProgress(maid).getTarget();
                MemoryUtil.getRequestProgress(maid).addVisitedPos(target);
                StorageAccessUtil.checkNearByContainers((Level)level, target.getPos(), pos -> MemoryUtil.getRequestProgress(maid).addVisitedPos(target.sameType((BlockPos)pos, null)));
            }
        }
        if (this.checkItem != null) {
            ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.missing");
        }
        MemoryUtil.getRequestProgress(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

