/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.meal;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidWorkMealTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageExtractableContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.ViewedInventoryUtil;

public class MealBehavior
extends MaidWorkMealTask {
    BehaviorBreath breath = new BehaviorBreath();
    private IStorageContext context = null;
    Target target = null;
    MutableBoolean hasTaken = new MutableBoolean(false);
    long endTimeStamp = -1L;

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.MEAL) {
            return false;
        }
        if (!MemoryUtil.getMeal(maid).hasTarget()) {
            return false;
        }
        if (Conditions.inventoryFull(maid)) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (this.hasTaken.getValue().booleanValue()) {
            return !maid.m_21205_().m_41619_();
        }
        return this.context != null && !this.context.isDone();
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        if (!MemoryUtil.getMeal(maid).hasTarget()) {
            return;
        }
        MemoryUtil.setWorking(maid, true);
        this.target = MemoryUtil.getMeal(maid).getTarget();
        this.context = MaidStorage.getInstance().getStorage(this.target.getType()).onStartCollect(level, maid, this.target);
        if (this.context != null) {
            this.context.start(maid, level, this.target);
        }
        this.hasTaken = new MutableBoolean(false);
        this.endTimeStamp = -1L;
    }

    protected void tick(ServerLevel level, EntityMaid maid, long p_22553_) {
        if (this.hasTaken.getValue().booleanValue()) {
            return;
        }
        if (!this.breath.breathTick(maid)) {
            return;
        }
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        Function<ItemStack, ItemStack> taker = itemStack -> {
            int maxStore;
            if (this.hasTaken.getValue().booleanValue()) {
                return itemStack;
            }
            if (ItemStackUtil.isSame(itemStack, MemoryUtil.getMeal(maid).getCheckItem(), false) && (maxStore = InvUtil.maxCanPlace((IItemHandler)maidInv, itemStack)) > 0) {
                this.hasTaken.setTrue();
                ItemStack copy = itemStack.m_255036_(1);
                ViewedInventoryUtil.ambitiousRemoveItemAndSync(maid, level, this.target, itemStack, 1);
                InvUtil.tryPlace((IItemHandler)maidInv, copy);
                super.start(level, maid, p_22553_);
                MemoryUtil.getMeal(maid).setEating(true);
                this.endTimeStamp = p_22553_ + 150L;
                return itemStack.m_255036_(itemStack.m_41613_() - 1);
            }
            return itemStack;
        };
        IStorageContext iStorageContext = this.context;
        if (iStorageContext instanceof IStorageInteractContext) {
            IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
            isic.tick(taker);
        } else {
            iStorageContext = this.context;
            if (iStorageContext instanceof IStorageExtractableContext) {
                IStorageExtractableContext isec = (IStorageExtractableContext)iStorageContext;
                if (isec.hasTask()) {
                    isec.tick(taker);
                } else {
                    isec.setExtract(List.of(MemoryUtil.getMeal(maid).getCheckItem()), ItemStackUtil.MATCH_TYPE.AUTO);
                }
            }
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        if (this.context != null) {
            this.context.finish();
        }
        MemoryUtil.setWorking(maid, false);
        MemoryUtil.getMeal(maid).clearTarget();
        MemoryUtil.getMeal(maid).setCoolDown(40);
        MemoryUtil.getMeal(maid).setEating(false);
        MemoryUtil.clearTarget(maid);
    }

    protected boolean m_7773_(long p_22537_) {
        if (this.endTimeStamp == -1L) {
            return false;
        }
        return p_22537_ > this.endTimeStamp;
    }
}

