/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.event;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableInt;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideRenderData;
import studio.fantasyit.maid_storage_manager.data.BindingData;
import studio.fantasyit.maid_storage_manager.data.BoxTip;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.data.InventoryListDataClient;
import studio.fantasyit.maid_storage_manager.items.ChangeFlag;
import studio.fantasyit.maid_storage_manager.items.LogisticsGuide;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.items.StorageDefineBauble;
import studio.fantasyit.maid_storage_manager.items.WorkCardItem;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonCraftAssets;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.BoxRenderUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="maid_storage_manager", value={Dist.CLIENT})
public final class BindingRender {
    private static final float[] colors_g = new float[]{0.4f, 0.73f, 0.42f, 1.0f};
    private static final float[] colors_r = new float[]{0.91f, 0.12f, 0.39f, 1.0f};
    private static final float[] colors_b = new float[]{0.1f, 0.46f, 0.82f, 1.0f};
    private static final float[] colors_y = new float[]{0.91f, 0.73f, 0.0f, 1.0f};
    private static final float[] colors_p = new float[]{0.37f, 0.21f, 0.69f, 1.0f};
    private static final float[][] colors = new float[][]{colors_b, colors_g, colors_y};

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            ConcurrentHashMap<BlockPos, Integer> floating = new ConcurrentHashMap<BlockPos, Integer>();
            BindingRender.renderForRequest(event, mc, floating);
            BindingRender.renderForStorage(event, mc, floating);
            BindingRender.renderForCraftGuide(event, mc, floating);
            BindingRender.renderForFlag(event, mc, floating);
            BindingRender.renderForInv(event, mc, floating);
            BindingRender.renderForLogistics(event, mc, floating);
            BindingRender.renderForEntity(event, mc);
            BindingRender.renderForWorkCard(event, mc);
        }
    }

    private static void renderForLogistics(RenderLevelStageEvent event, Minecraft mc, Map<BlockPos, Integer> floating) {
        Target output;
        ItemStack mainStack = mc.f_91074_.m_21205_();
        if (mainStack.m_41720_() != ItemRegistry.LOGISTICS_GUIDE.get()) {
            return;
        }
        Target input = LogisticsGuide.getInput(mainStack);
        if (input != null) {
            BoxRenderUtil.renderStorage(input, colors_b, event, Component.m_237115_((String)"maid_storage_manager.logistics_guide_binding_extract").getString(), floating);
        }
        if ((output = LogisticsGuide.getOutput(mainStack)) != null) {
            BoxRenderUtil.renderStorage(output, colors_g, event, Component.m_237115_((String)"maid_storage_manager.logistics_guide_binding_store").getString(), floating);
        }
    }

    private static void renderForEntity(RenderLevelStageEvent event, Minecraft mc) {
        if (mc.f_91073_ == null) {
            return;
        }
        BindingData.getEntityIds().forEach(id -> {
            Entity entity = mc.f_91073_.m_6815_(id.intValue());
            if (entity == null) {
                return;
            }
            BoxRenderUtil.renderEntity(entity, colors_p, event, Component.m_237115_((String)"maid_storage_manager.request_list_binding_render").getString());
        });
    }

    private static void renderForRequest(RenderLevelStageEvent event, Minecraft mc, Map<BlockPos, Integer> floating) {
        ItemStack mainStack = mc.f_91074_.m_21205_();
        if (mainStack.m_41720_() != ItemRegistry.REQUEST_LIST_ITEM.get()) {
            return;
        }
        Target storage = RequestListItem.getStorageBlock(mainStack);
        if (storage != null) {
            BoxRenderUtil.renderStorage(storage, colors_p, event, Component.m_237115_((String)"maid_storage_manager.request_list_binding_render").getString(), floating);
        }
    }

    private static void renderForStorage(RenderLevelStageEvent event, Minecraft mc, Map<BlockPos, Integer> floating) {
        float[] color;
        ItemStack mainStack = mc.f_91074_.m_21205_();
        if (mainStack.m_41720_() != ItemRegistry.STORAGE_DEFINE_BAUBLE.get()) {
            if (mainStack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
                if ((mainStack = ItemStackUtil.parseStack(mainStack.m_41784_().m_128469_("storage_define"))).m_41619_()) {
                    return;
                }
            } else {
                return;
            }
        }
        List<Target> storage = StorageDefineBauble.getStorages(mainStack);
        String mode = switch (StorageDefineBauble.getMode(mainStack)) {
            default -> throw new IncompatibleClassChangeError();
            case StorageDefineBauble.Mode.APPEND -> "append";
            case StorageDefineBauble.Mode.REMOVE -> "remove";
            case StorageDefineBauble.Mode.REPLACE -> "replace";
            case StorageDefineBauble.Mode.REPLACE_SPEC -> "replace_spec";
        };
        switch (mode) {
            case "append": {
                float[] fArray = colors_g;
                break;
            }
            case "remove": {
                float[] fArray = colors_r;
                break;
            }
            case "replace": {
                float[] fArray = colors_b;
                break;
            }
            case "replace_spec": {
                float[] fArray = colors_y;
                break;
            }
            default: {
                float[] fArray = color = colors_g;
            }
        }
        if (storage == null || storage.isEmpty()) {
            return;
        }
        for (Target storage1 : storage) {
            BoxRenderUtil.renderStorage(storage1, color, event, Component.m_237115_((String)("maid_storage_manager.storage_define_bauble_binding_render." + mode)).getString(), floating);
        }
    }

    private static void renderForFlag(RenderLevelStageEvent event, Minecraft mc, Map<BlockPos, Integer> floating) {
        ItemStack mainStack = mc.f_91074_.m_21205_();
        if (mainStack.m_41720_() != ItemRegistry.CHANGE_FLAG.get()) {
            return;
        }
        List<Target> storage = ChangeFlag.getStorages(mainStack);
        if (storage == null || storage.isEmpty()) {
            return;
        }
        for (Target storage1 : storage) {
            BoxRenderUtil.renderStorage(storage1, colors_r, event, Component.m_237115_((String)"maid_storage_manager.changed_flag_binding_render.changed").getString(), floating);
        }
    }

    private static void renderForCraftGuide(RenderLevelStageEvent event, Minecraft mc, Map<BlockPos, Integer> floating) {
        ItemStack mainStack = mc.f_91074_.m_21205_();
        boolean noRenderSelecting = false;
        if (mainStack.m_41720_() != ItemRegistry.CRAFT_GUIDE.get()) {
            if (mainStack.m_41720_() == ItemRegistry.LOGISTICS_GUIDE.get()) {
                mainStack = LogisticsGuide.getCraftGuideItemStack(mainStack);
                noRenderSelecting = true;
                if (mainStack.m_41619_()) {
                    return;
                }
            } else {
                return;
            }
        }
        CraftGuideRenderData data = CraftGuideRenderData.fromItemStack(mainStack);
        for (int i = 0; i < data.stepBindings.size(); ++i) {
            Pair<Target, ResourceLocation> step = data.stepBindings.get(i);
            BoxRenderUtil.renderStorage((Target)step.getA(), colors[i % colors.length], event, "[" + (i + 1) + "]" + CommonCraftAssets.translationForAction((ResourceLocation)step.getB()).getString(), floating, i == data.selecting && !noRenderSelecting ? 15277667 : 0xFFFFFF);
        }
        if (!noRenderSelecting && data.selecting != -1 && data.selecting < data.stepBindings.size()) {
            Pair<Target, ResourceLocation> step = data.stepBindings.get(data.selecting);
            BoxRenderUtil.renderStorage((Target)step.getA(), colors_r, event, Component.m_237115_((String)"interaction.craft_guide_selecting").getString(), floating);
        }
    }

    private static void renderForInv(RenderLevelStageEvent event, Minecraft mc, Map<BlockPos, Integer> floating) {
        if (InventoryListDataClient.showingInv.isEmpty() && InventoryListDataClient.commonTips.isEmpty()) {
            return;
        }
        for (Pair<InventoryItem, MutableInt> pair : InventoryListDataClient.showingInv) {
            InventoryItem inv = (InventoryItem)pair.getA();
            for (int i = 0; i < inv.posAndSlot.size(); ++i) {
                InventoryItem.PositionCount storageIntegerPair = inv.posAndSlot.get(i);
                if (storageIntegerPair.isCraftGuide()) {
                    BoxRenderUtil.renderStorage(storageIntegerPair.pos(), colors_y, event, Component.m_237110_((String)"maid_storage_manager.inventory_list_render.inv_craft_guide", (Object[])new Object[]{inv.itemStack.m_41611_().getString()}).getString(), floating);
                    continue;
                }
                BoxRenderUtil.renderStorage(storageIntegerPair.pos(), colors_y, event, Component.m_237110_((String)"maid_storage_manager.inventory_list_render.inv", (Object[])new Object[]{inv.itemStack.m_41611_().getString(), storageIntegerPair.count()}).getString(), floating);
            }
        }
        for (Pair pair : InventoryListDataClient.commonTips) {
            BoxRenderUtil.renderStorage(((BoxTip)pair.getA()).target(), ((BoxTip)pair.getA()).argb(), event, ((BoxTip)pair.getA()).tip().getString(), floating);
        }
    }

    private static void renderForWorkCard(RenderLevelStageEvent event, Minecraft mc) {
        ItemStack mainStack = mc.f_91074_.m_21205_();
        if (mainStack.m_41720_() != ItemRegistry.WORK_CARD.get()) {
            return;
        }
        List entities = mc.f_91073_.m_142425_(EntityTypeTest.m_156916_(EntityMaid.class), mc.f_91074_.m_20191_().m_82400_(32.0), t -> true);
        for (EntityMaid maid : entities) {
            BaubleItemHandler baubleItemHandler = maid.getMaidBauble();
            float oh = (float)(maid.m_20191_().f_82292_ - maid.m_20191_().f_82289_) + 0.5f;
            for (int i = 0; i < baubleItemHandler.getSlots(); ++i) {
                if (!baubleItemHandler.getStackInSlot(i).m_150930_((Item)ItemRegistry.WORK_CARD.get()) || !WorkCardItem.matches(baubleItemHandler.getStackInSlot(i), mainStack)) continue;
                BoxRenderUtil.drawText(event, mc, maid.m_20318_(event.getPartialTick()), baubleItemHandler.getStackInSlot(i).m_41786_().getString(), -1, oh);
                oh += 0.3f;
            }
        }
    }
}

