/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.type.CraftingType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public abstract class SimpleGenerator<T extends Recipe<C>, C extends Container>
implements IAutoCraftGuideGenerator {
    protected abstract RecipeType<T> getRecipeType();

    protected abstract ResourceLocation getCraftType();

    protected abstract C getWrappedContainer(T var1, List<ItemStack> var2);

    protected List<ItemStack> wrapInputs(T recipe, List<ItemStack> inputs) {
        return inputs;
    }

    protected List<ItemStack> wrapOutputs(T recipe, List<ItemStack> inputs, C container, List<ItemStack> outputs) {
        recipe.m_7457_(container).stream().filter(i -> !i.m_41619_()).forEach(outputs::add);
        return outputs;
    }

    protected List<Ingredient> ingredientsTransform(List<InventoryItem> inventory, Level level, T recipe) {
        return this.cacheIngredientsTransform(recipe);
    }

    protected List<Ingredient> cacheIngredientsTransform(T recipe) {
        return recipe.m_7527_();
    }

    protected List<Integer> ingredientCountsTransform(List<InventoryItem> inventory, Level level, T recipe, List<Ingredient> ingredient) {
        return ingredient.stream().map(t -> Arrays.stream(t.m_43908_()).findFirst().map(ItemStack::m_41613_).orElse(1)).toList();
    }

    protected ItemStack outputTransform(List<InventoryItem> inventory, Level level, T recipe) {
        return recipe.m_8043_(level.m_9598_());
    }

    protected boolean isValid(List<InventoryItem> inventory, Level level, BlockPos pos, T recipe) {
        return this.isValid(recipe);
    }

    protected boolean isValid(T recipe) {
        return true;
    }

    protected boolean shouldCache(T recipe) {
        return true;
    }

    @Override
    @NotNull
    public ResourceLocation getType() {
        return this.getCraftType();
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, pos);
        level.m_7465_().m_44013_(this.getRecipeType()).forEach(recipe -> {
            if (!this.isValid(inventory, level, pos, recipe)) {
                return;
            }
            List<Ingredient> ingredients = this.ingredientsTransform(inventory, level, recipe);
            ItemStack output = this.outputTransform(inventory, level, recipe);
            if (!posFilter.isAvailable(output)) {
                return;
            }
            List<Integer> ingredientCounts = this.ingredientCountsTransform(inventory, level, recipe, ingredients);
            List<ItemStack> resultItem = List.of(recipe.m_8043_(level.m_9598_()));
            graph.addRecipe(recipe.m_6423_(), ingredients, ingredientCounts, output, items -> {
                C container = this.getWrappedContainer((T)recipe, (List<ItemStack>)items);
                ArrayList<ItemStack> result = new ArrayList<ItemStack>(resultItem);
                CraftGuideStepData step = new CraftGuideStepData(new Target(CraftingType.TYPE, pos), this.wrapInputs((T)recipe, (List<ItemStack>)items), this.wrapOutputs((T)recipe, (List<ItemStack>)items, container, (List<ItemStack>)result), this.getCraftType());
                return new CraftGuideData(List.of(step), this.getCraftType());
            });
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_(this.getRecipeType()).forEach(recipe -> {
            if (this.isValid(recipe) && this.shouldCache(recipe)) {
                List<Ingredient> ingredients = this.cacheIngredientsTransform(recipe);
                RecipeIngredientCache.addRecipeCache(recipe.m_6423_(), ingredients);
            }
        });
    }
}

