/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.cache;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;

public class GraphCache {
    public static final Map<UUID, CacheRecord> CACHE = new ConcurrentHashMap<UUID, CacheRecord>();

    @Nullable
    public static CacheRecord get(UUID maid) {
        return CACHE.get(maid);
    }

    @Nullable
    public static CacheRecord getAndValidate(Level level, EntityMaid maid, List<IAutoCraftGuideGenerator> iAutoCraftGuideGenerators) {
        if (!Config.generateNearestOnly) {
            return null;
        }
        CacheRecord cacheRecord = GraphCache.get(maid.m_20148_());
        if (cacheRecord == null) {
            return null;
        }
        if (cacheRecord.restrictCenter == null ? maid.m_21534_() != null : !cacheRecord.restrictCenter.equals((Object)maid.m_21534_())) {
            return null;
        }
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(maid.m_21573_().m_26575_(), (ServerLevel)level, maid);
        for (IAutoCraftGuideGenerator iAutoCraftGuideGenerator : iAutoCraftGuideGenerators) {
            if (!cacheRecord.targets.containsKey(iAutoCraftGuideGenerator.getType()) || !iAutoCraftGuideGenerator.canCacheGraph() || cacheRecord.targets.get(iAutoCraftGuideGenerator.getType()).stream().allMatch(blockPos -> iAutoCraftGuideGenerator.isBlockValid(level, (BlockPos)blockPos) && iAutoCraftGuideGenerator.positionalAvailable((ServerLevel)level, maid, (BlockPos)blockPos, pathFinding))) continue;
            return null;
        }
        cacheRecord.graph.clearStates();
        for (IAutoCraftGuideGenerator iAutoCraftGuideGenerator : iAutoCraftGuideGenerators) {
            if (iAutoCraftGuideGenerator.canCacheGraph()) continue;
            cacheRecord.graph.invalidAllCraftWithType(iAutoCraftGuideGenerator.getType());
            cacheRecord.targets.remove(iAutoCraftGuideGenerator.getType());
        }
        return cacheRecord;
    }

    public static void putCache(EntityMaid maid, Map<ResourceLocation, List<BlockPos>> targets, ICachableGeneratorGraph generatorGraph) {
        CacheRecord cacheRecord = new CacheRecord(maid.m_20148_(), maid.m_21534_(), targets, generatorGraph);
        CACHE.put(maid.m_20148_(), cacheRecord);
    }

    public static void put(UUID maid, CacheRecord record) {
        CACHE.put(maid, record);
    }

    public static void invalidateAll() {
        CACHE.clear();
    }

    public record CacheRecord(UUID maid, BlockPos restrictCenter, Map<ResourceLocation, List<BlockPos>> targets, ICachableGeneratorGraph graph) {
    }
}

