/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IMaidStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageSplitInsertableContext;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class CommonSplitItemAction
extends AbstractCraftActionContext {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "split");
    protected IStorageContext storageContext;
    int slot = 0;
    int ingredientIndex = 0;

    public CommonSplitItemAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public void loadEnv(CompoundTag env) {
        this.slot = env.m_128441_("slot") ? env.m_128451_("slot") : 0;
        this.ingredientIndex = env.m_128441_("ingredientIndex") ? env.m_128451_("ingredientIndex") : 0;
    }

    @Override
    public CompoundTag saveEnv(CompoundTag env) {
        env.m_128405_("slot", this.slot);
        env.m_128405_("ingredientIndex", this.ingredientIndex);
        return super.saveEnv(env);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        ServerLevel level = (ServerLevel)this.maid.m_9236_();
        Target target = this.craftGuideStepData.getStorage();
        @Nullable Target validTarget = MaidStorage.getInstance().isValidTarget(level, (LivingEntity)this.maid, target);
        if (validTarget == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        @Nullable IMaidStorage storageType = MaidStorage.getInstance().getStorage(validTarget.getType());
        if (storageType == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.storageContext = storageType.onStartPlace(level, this.maid, validTarget);
        if (this.storageContext == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.storageContext.start(this.maid, level, validTarget);
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        if (this.allDone()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        boolean hasChange = false;
        boolean reTryStart = false;
        CombinedInvWrapper inv = this.maid.getAvailableInv(false);
        ItemStack stepItem = this.craftGuideStepData.getNonEmptyInput().get(this.ingredientIndex);
        IStorageContext iStorageContext = this.storageContext;
        if (iStorageContext instanceof IStorageSplitInsertableContext) {
            ItemStack item;
            IStorageSplitInsertableContext issic = (IStorageSplitInsertableContext)iStorageContext;
            boolean shouldDoPlace = false;
            int count = 0;
            while (this.slot < inv.getSlots()) {
                item = inv.getStackInSlot(this.slot);
                if (!item.m_41619_()) {
                    if (count++ > 10) break;
                    if (ItemStackUtil.isSameInCrafting(stepItem, item) && this.craftLayer.getCurrentStepCount(this.ingredientIndex) < stepItem.m_41613_()) {
                        shouldDoPlace = true;
                        break;
                    }
                }
                ++this.slot;
            }
            if (shouldDoPlace) {
                item = inv.getStackInSlot(this.slot);
                int placed = this.craftLayer.getCurrentStepCount(this.ingredientIndex);
                int required = stepItem.m_41613_();
                int pick = Math.min(required - placed, item.m_41613_());
                ItemStack copy = item.m_255036_(pick);
                ItemStack rest = issic.splitInsert(copy);
                item.m_41774_(pick - rest.m_41613_());
                this.craftLayer.addCurrentStepPlacedCounts(this.ingredientIndex, pick - rest.m_41613_());
                if (pick - rest.m_41613_() != 0) {
                    hasChange = true;
                } else if (this.craftLayer.getStep() == 1) {
                    ++this.slot;
                }
            }
            if (this.craftLayer.getCurrentStepCount(this.ingredientIndex) >= stepItem.m_41613_()) {
                ++this.ingredientIndex;
                this.slot = 0;
            } else if (this.slot >= inv.getSlots()) {
                if (this.craftGuideStepData.isOptional()) {
                    ++this.ingredientIndex;
                } else {
                    reTryStart = true;
                }
                this.slot = 0;
            }
            if (this.ingredientIndex >= this.craftGuideStepData.getNonEmptyInput().size()) {
                return AbstractCraftActionContext.Result.SUCCESS;
            }
        } else {
            return AbstractCraftActionContext.Result.FAIL;
        }
        if (reTryStart) {
            return hasChange ? AbstractCraftActionContext.Result.CONTINUE_INTERRUPTABLE : AbstractCraftActionContext.Result.NOT_DONE_INTERRUPTABLE;
        }
        return hasChange ? AbstractCraftActionContext.Result.CONTINUE : AbstractCraftActionContext.Result.NOT_DONE;
    }

    @Override
    public void stop() {
        if (this.storageContext != null) {
            this.storageContext.finish();
        }
    }

    private boolean allDone() {
        if (this.craftGuideStepData == null) {
            return false;
        }
        List<ItemStack> items = this.craftGuideStepData.getInput();
        for (int i = 0; i < items.size(); ++i) {
            if (this.craftLayer.getCurrentStepCount(i) >= items.get(i).m_41613_()) continue;
            return false;
        }
        return true;
    }
}

