/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.ai;

import com.github.tartaricacid.touhoulittlemaid.ai.service.function.IFunctionCall;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.response.ToolResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.ObjectParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.Parameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.StringParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.request.ChatCompletion;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.maid.task.StorageManageTask;

public class CoWorkSwitchFunction
implements IFunctionCall<EnableData> {
    public String getId() {
        return "switch_cowork";
    }

    public String getDescription(EntityMaid entityMaid) {
        return "You can use this tool to switch to Coworker Mode. In this mode ,you would follow the player and you can see the contents of the player's opened containers in real time. You need to pass a boolean value enable, which is \"true\" or \"false\" to indicate whether you want to enable coworker mode";
    }

    public Parameter addParameters(ObjectParameter objectParameter, EntityMaid entityMaid) {
        objectParameter.addProperties("enable", (Parameter)StringParameter.create().setPattern("true|false"));
        return objectParameter;
    }

    public boolean addToChatCompletion(EntityMaid maid, ChatCompletion chatCompletion) {
        return maid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID);
    }

    public Codec<EnableData> codec() {
        return EnableData.CODEC;
    }

    public ToolResponse onToolCall(EnableData en, EntityMaid entityMaid) {
        StorageManagerConfigData.Data data = (StorageManagerConfigData.Data)entityMaid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
        data.coWorkMode(en.enable.equals("true"));
        entityMaid.setAndSyncData(StorageManagerConfigData.KEY, (Object)data);
        return new ToolResponse(en.enable.equals("true") ? "Cowork mode enabled." : "Cowork mode disabled.");
    }

    public record EnableData(String enable) {
        public static Codec<EnableData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("enable").forGetter(EnableData::enable)).apply((Applicative)instance, EnableData::new));
    }
}

