/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.farm.handler.v1.berry;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.IHandlerInfo;
import com.github.wallev.maidsoulkitchen.entity.passive.IAddonMaid;
import com.github.wallev.maidsoulkitchen.task.farm.FarmType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public abstract class BerryHandler
implements ICompatFarmHandler,
IHandlerInfo {
    private static final Set<BerryHandler> berryHandlers = new HashSet<BerryHandler>();
    private BerryHandler nextHandler;

    protected BerryHandler() {
        berryHandlers.add(this);
    }

    public static Set<BerryHandler> getBerryHandlers() {
        return berryHandlers;
    }

    @Override
    public void setNextHandler(ICompatFarmHandler nextHandler) {
        this.nextHandler = (BerryHandler)nextHandler;
    }

    @Override
    public boolean shouldMoveTo(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        return this.canHarvest(maid, cropPos, cropState);
    }

    @Override
    public FarmType getFarmType() {
        return FarmType.BERRY;
    }

    protected abstract ICompatFarmHandler.ActionState processCanHarvest(EntityMaid var1, BlockPos var2, BlockState var3);

    protected abstract boolean processHarvest(EntityMaid var1, BlockPos var2, BlockState var3);

    protected final boolean harvestWithTool(EntityMaid maid, BlockPos cropPos, BlockState cropState, Predicate<ItemStack> predicate) {
        ItemStack toolStack;
        if (this.processCanHarvest(maid, cropPos, cropState) != ICompatFarmHandler.ActionState.DENY && !(toolStack = ItemsUtil.getStack((IItemHandler)maid.getAvailableInv(true), predicate)).m_41619_()) {
            ItemStack toolCopy = toolStack.m_41777_();
            toolStack.m_41764_(0);
            IAddonMaid.interactUseOnBlockWithItem(maid, cropPos, toolCopy);
            return true;
        }
        return false;
    }

    protected final boolean harvestWithoutTool(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        if (this.processCanHarvest(maid, cropPos, cropState) != ICompatFarmHandler.ActionState.DENY) {
            IAddonMaid.interactUseOnBlockWithoutItem(maid, cropPos);
            return true;
        }
        return false;
    }

    public final boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        ICompatFarmHandler.ActionState actionState = this.processCanHarvest(maid, cropPos, cropState);
        if (actionState == ICompatFarmHandler.ActionState.DENY) {
            return false;
        }
        if (actionState == ICompatFarmHandler.ActionState.ALLOW) {
            return true;
        }
        return this.nextHandler != null && this.nextHandler.canHarvest(maid, cropPos, cropState);
    }

    public final void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        ICompatFarmHandler.ActionState actionState = this.processCanHarvest(maid, cropPos, cropState);
        if (actionState != ICompatFarmHandler.ActionState.DENY) {
            if (actionState == ICompatFarmHandler.ActionState.ALLOW) {
                this.processHarvest(maid, cropPos, cropState);
            } else if (this.nextHandler != null) {
                this.nextHandler.harvest(maid, cropPos, cropState);
            }
        }
    }
}

