/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.farm;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskMelon;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.wallev.maidsoulkitchen.api.IMaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.api.event.MaidMkTaskEnableEvent;
import com.github.wallev.maidsoulkitchen.api.task.IAddonFarmTask;
import com.github.wallev.maidsoulkitchen.event.MelonConfigEvent;
import com.github.wallev.maidsoulkitchen.inventory.container.maid.CompatMelonConfigContainer;
import com.github.wallev.maidsoulkitchen.task.TaskInfo;
import com.github.wallev.maidsoulkitchen.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TaskCompatMelonFarm
extends TaskMelon
implements IMaidsoulKitchenTask,
IAddonFarmTask {
    @Override
    public boolean isEnable(EntityMaid maid) {
        MaidMkTaskEnableEvent maidMkTaskEnableEvent = new MaidMkTaskEnableEvent(maid, this);
        MinecraftForge.EVENT_BUS.post((Event)maidMkTaskEnableEvent);
        return maidMkTaskEnableEvent.isEnable();
    }

    public ResourceLocation getUid() {
        return TaskInfo.COMPAT_MELON_FARM.uid;
    }

    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        Block block = cropState.m_60734_();
        if (MelonConfigEvent.MELON_STEM_MAP.containsKey(BlockUtil.getId(block))) {
            String stemBlockId = MelonConfigEvent.MELON_STEM_MAP.get(BlockUtil.getId(block));
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState offsetState = maid.f_19853_.m_8055_(cropPos.m_121945_(direction));
                if (!BlockUtil.getId(offsetState).equals(stemBlockId)) continue;
                return true;
            }
        }
        return false;
    }

    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        Block block = cropState.m_60734_();
        if (MelonConfigEvent.MELON_STEM_MAP.containsKey(BlockUtil.getId(block))) {
            ItemStack mainHandItem = maid.m_21205_();
            if (EnchantmentHelper.m_272262_((ItemStack)mainHandItem)) {
                if (this.destroyBlockByHandItem(maid, cropPos)) {
                    mainHandItem.m_41622_(1, (LivingEntity)maid, e -> e.m_21190_(InteractionHand.MAIN_HAND));
                }
            } else {
                maid.destroyBlock(cropPos);
            }
        } else {
            super.harvest(maid, cropPos, cropState);
        }
    }

    public boolean destroyBlockByHandItem(EntityMaid maid, BlockPos pos) {
        return this.destroyBlockByHandItem(maid, pos, true);
    }

    public boolean destroyBlockByHandItem(EntityMaid maid, BlockPos pos, boolean dropBlock) {
        return maid.canDestroyBlock(pos) && this.destroyBlockByHandItem(maid, maid.f_19853_, pos, dropBlock);
    }

    private boolean destroyBlockByHandItem(EntityMaid maid, Level level, BlockPos blockPos, boolean dropBlock) {
        boolean setResult;
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_60795_()) {
            return false;
        }
        FluidState fluidState = level.m_6425_(blockPos);
        if (!(blockState.m_60734_() instanceof BaseFireBlock)) {
            level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        if (dropBlock) {
            BlockEntity blockEntity = blockState.m_155947_() ? level.m_7702_(blockPos) : null;
            maid.dropResourcesToMaidInv(blockState, level, blockPos, blockEntity, maid, maid.m_21205_());
        }
        if (setResult = level.m_7731_(blockPos, fluidState.m_76188_(), 3)) {
            level.m_220407_(GameEvent.f_157794_, blockPos, GameEvent.Context.m_223719_((Entity)maid, (BlockState)blockState));
        }
        return setResult;
    }

    public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Task Config Container");
            }

            public AbstractMaidContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new CompatMelonConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    @Override
    public String getBookEntry() {
        return "melon";
    }
}

