/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.data.TaskDataRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record ActionCookDataRecMessage(int entityId, ResourceLocation dataKey, String rec, String mode) {
    public static void encode(ActionCookDataRecMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.m_130085_(message.dataKey);
        buf.m_130070_(message.rec);
        buf.m_130070_(message.mode);
    }

    public static ActionCookDataRecMessage decode(FriendlyByteBuf buf) {
        return new ActionCookDataRecMessage(buf.readInt(), buf.m_130281_(), buf.m_130277_(), buf.m_130277_());
    }

    public static void handle(ActionCookDataRecMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.entityId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    TaskDataKey value = TaskDataRegister.getValue((ResourceLocation)message.dataKey);
                    CookData cookData = (CookData)maid.getOrCreateData(value, (Object)new CookData());
                    cookData.addOrRemoveRec(message.rec, message.mode);
                    maid.setAndSyncData(value, (Object)cookData);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

