/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.foundation.utility;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Mods {
    PATCHOULI("patchouli"),
    CLOTH_CONFIG("cloth_config"),
    JADE("jade"),
    TOP("theoneprobe"),
    SOPHISTICATED_STORAGE("sophisticatedstorage"),
    FD("farmersdelight"),
    MD("miners_delight"),
    MND("mynethersdelight"),
    CD("cuisinedelight"),
    BD("barbequesdelight"),
    YHCD("youkaishomecoming"),
    BNCD("brewinandchewin"),
    FRD("farmersrespite"),
    DAPI("doapi"),
    DHB("herbalbrews"),
    DV("vinery"),
    DBP("beachparty"),
    DCL("candlelight"),
    DBK("bakery"),
    DFC("farm_and_charm"),
    SF("simplefarming"),
    FS("fruitstack"),
    MS("supplementaries"),
    CP("crockpot"),
    DB("drinkbeer"),
    KK("kitchenkarrot"),
    TWT("thirst"),
    SS("sereneseasons"),
    ES("eclipticseasons"),
    MC("minecraft"){

        @Override
        public boolean isLoaded() {
            return true;
        }
    };

    public final String modId;
    public final boolean isLoaded;

    private Mods(String modId) {
        this.modId = modId;
        this.isLoaded = this.isLoaded();
    }

    public boolean isLoaded() {
        return ModList.get().isLoaded(this.modId);
    }

    public ResourceLocation create(String path) {
        return new ResourceLocation(this.modId, path);
    }

    public static boolean allLoaded(String ... modIds) {
        ModList modList = ModList.get();
        for (String modId : modIds) {
            if (modList.isLoaded(modId)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasLoaded(String ... modIds) {
        ModList modList = ModList.get();
        for (String modId : modIds) {
            if (!modList.isLoaded(modId)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLoaded(Mods ... mods) {
        ModList modList = ModList.get();
        for (Mods mod : mods) {
            if (!mod.isLoaded()) continue;
            return true;
        }
        return false;
    }
}

