/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.kaleidoscopecookery.cookery;

import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base.AutoCraftGuideGeneratorRegister;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.cookingpot.ILdCookingPotGuideGenerator;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.base.EnchantCommonIdleAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.custom.SneakCommonUseAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.CraftGuideOperator2;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.action.IdleStepUtil;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.action.ItemUseStepUtil;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.action.TargetUtil;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.action.ToolUseStepUtil;
import com.github.wallev.maidsoulkitchen.compat.msm.kaleidoscopecookery.cookery.CookerAction;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.PotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import studio.fantasyit.maid_storage_manager.craft.CollectCraftEvent;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.CraftAction;
import studio.fantasyit.maid_storage_manager.craft.action.PathTargetLocator;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;

@AutoCraftGuideGeneratorRegister(value=TaskInfo.MSM_KC_COOKER)
public class GeneratorKcCookerGuide
implements ILdCookingPotGuideGenerator<PotRecipe, PotBlockEntity> {
    public GeneratorKcCookerGuide(CollectCraftEvent event) {
        event.addAutoCraftGuideGenerator((IAutoCraftGuideGenerator)this);
        event.addAction(CookerAction.TYPE, CookerAction::new, PathTargetLocator::touchPos, CraftAction.PathEnoughLevel.CLOSER.value, false, 2L, 4, 4, List.of(ActionOption.OPTIONAL, SneakCommonUseAction.OPTION_USE_METHOD, SneakCommonUseAction.SNEAK, EnchantCommonIdleAction.OPTION_WAIT));
    }

    private static boolean isHit(PotBlockEntity be) {
        Level level = be.m_58904_();
        assert (level != null);
        BlockPos blockPos = be.m_58899_();
        return level.m_8055_(blockPos.m_7495_()).m_61145_((Property)BlockStateProperties.f_61443_).orElse(false);
    }

    @Override
    public boolean isValidBlockEntity(BlockEntity be) {
        return be instanceof PotBlockEntity;
    }

    @Override
    public boolean isHeated(PotBlockEntity be) {
        return GeneratorKcCookerGuide.isHit(be);
    }

    @Override
    public List<Ingredient> getInputs(PotRecipe recipe) {
        ArrayList ingredients = Lists.newArrayList();
        ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.KITCHEN_SHOVEL.get()}));
        ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OIL.get()}));
        NonNullList ingredients1 = recipe.m_7527_();
        for (Ingredient ingredient : ingredients1) {
            if (ingredient.m_43947_()) continue;
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    @Override
    public List<Ingredient> getContainers(PotRecipe recipe) {
        return List.of(recipe.carrier());
    }

    @Override
    public Item getBlockItemForTranslate() {
        return (Item)ModItems.POT.get();
    }

    @Override
    public void generateSteps(BlockPos pos, Level level, PotRecipe recipe, CraftGuideOperator2 craftGuide, List<ItemStack> realItems, boolean needContainer, List<ItemStack> containers, List<ItemStack> outputs, List<ItemStack> remains) {
        this.generateSteps1(pos, level, recipe, craftGuide, realItems, needContainer, containers, outputs, remains);
    }

    @Override
    public List<ItemStack> getRemains(PotRecipe recipe, List<ItemStack> inputs) {
        return List.of();
    }

    @Override
    public <T extends Container> T convert2InputsInv(List<ItemStack> allInputs) {
        return (T)this.simpleContainer(allInputs);
    }

    @Override
    public RecipeType<PotRecipe> getRecipeType() {
        return ModRecipes.POT_RECIPE;
    }

    public void generateSteps1(BlockPos pos, Level level, PotRecipe recipe, CraftGuideOperator2 craftGuide, List<ItemStack> realItems, boolean needContainer, List<ItemStack> containers, List<ItemStack> outputs, List<ItemStack> remains) {
        ItemStack kitchenShovel = realItems.remove(0);
        ItemStack container = ItemStack.f_41583_;
        ArrayList inputsWithOil = Lists.newArrayList(realItems);
        if (needContainer) {
            container = containers.get(0);
        }
        craftGuide.addIdle(pos.m_7494_());
        craftGuide.addItemUse(inputsWithOil);
        craftGuide.addStep(new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos), List.of(kitchenShovel), List.of(kitchenShovel), CookerAction.TYPE, CookerAction.CookerTime.toCompoundTag(recipe.time(), recipe.stirFryCount())));
        CraftGuideStepData failStep = ItemUseStepUtil.makeOptionalStep(pos, Items.f_42399_.m_7968_());
        if (needContainer) {
            craftGuide.addItemUseIfFail(container, outputs, failStep);
        } else {
            craftGuide.addSneakToolUseIfFail(kitchenShovel, outputs, failStep);
        }
    }

    protected void generateSteps2(BlockPos pos, Level level, PotRecipe recipe, CraftGuideOperator2 craftGuide, List<ItemStack> realItems, boolean needContainer, List<ItemStack> containers, List<ItemStack> outputs, List<ItemStack> remains) {
        ItemStack kitchenShovel = realItems.remove(0);
        ItemStack container = ItemStack.f_41583_;
        ArrayList inputsWithOil = Lists.newArrayList(realItems);
        if (needContainer) {
            container = containers.get(0);
        }
        craftGuide.addItemUse(inputsWithOil);
        ArrayList stirFryTimes = Lists.newArrayList();
        Random random = new Random();
        int time = recipe.time() / 3;
        int stirFryMinCount = recipe.stirFryCount();
        int stirFrySpace = (time - 20) / stirFryMinCount;
        ArrayList stirFrySteps = Lists.newArrayList();
        for (int tick = 0; tick < time + 20; ++tick) {
            int nextInt;
            if (tick % stirFrySpace == 0) {
                stirFrySteps.add(ToolUseStepUtil.makeStep(pos, kitchenShovel));
                stirFryTimes.add(tick);
                continue;
            }
            if (tick % 2 == 0 && tick % (nextInt = random.nextInt(1, 10)) == 0) {
                stirFrySteps.add(ToolUseStepUtil.makeStep(pos, kitchenShovel));
                stirFryTimes.add(tick);
                continue;
            }
            stirFrySteps.add(IdleStepUtil.makeStep(pos));
        }
        ArrayList<Pair> idleIntervals = new ArrayList<Pair>();
        Integer idleStart = null;
        for (int i = 0; i < stirFrySteps.size(); ++i) {
            boolean isIdle;
            CraftGuideStepData step = (CraftGuideStepData)stirFrySteps.get(i);
            boolean bl = isIdle = step.action == EnchantCommonIdleAction.TYPE;
            if (isIdle) {
                if (idleStart != null) continue;
                idleStart = i;
                continue;
            }
            if (idleStart == null) continue;
            idleIntervals.add(Pair.of((Object)idleStart, (Object)(i - 1)));
            idleStart = null;
        }
        if (idleStart != null) {
            idleIntervals.add(Pair.of(idleStart, (Object)(stirFrySteps.size() - 1)));
        }
        ArrayList allSteps = Lists.newArrayList();
        int lastIndex = 0;
        for (Pair pair : idleIntervals) {
            int first = (Integer)pair.getFirst();
            int second = (Integer)pair.getSecond();
            for (int i = 0; i < first - lastIndex - 1; ++i) {
                allSteps.add(ToolUseStepUtil.makeStep(pos, kitchenShovel));
            }
            allSteps.add(IdleStepUtil.makeStep(pos, second - first));
            lastIndex = second;
        }
        craftGuide.steps().addAll(allSteps);
        craftGuide.addIdle(30);
        CraftGuideStepData failStep = ItemUseStepUtil.makeOptionalStep(pos, Items.f_42399_.m_7968_());
        if (needContainer) {
            craftGuide.addItemUseIfFail(container, outputs, failStep);
        } else {
            craftGuide.addSneakToolUseIfFail(kitchenShovel, outputs, failStep);
        }
    }
}

