/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.inventory.AltarRecipeInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class RecipeUtil {
    public static CraftingContainer wrapCraftingContainer(List<ItemStack> items, CraftingRecipe recipe) {
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            return RecipeUtil.wrapCraftingContainer(items, shapedRecipe.getRecipeWidth(), shapedRecipe.getRecipeHeight());
        }
        return RecipeUtil.wrapCraftingContainer(items, 3, 3);
    }

    public static CraftingContainer wrapCraftingContainer(List<ItemStack> items, int w, int h) {
        if (items.size() != w * h) {
            items = new ArrayList<ItemStack>(items);
            for (int i = items.size(); i < w * h; ++i) {
                items.add(ItemStack.f_41583_);
            }
        }
        return new ReadonlyCraftingContainer(items, w, h);
    }

    public static CraftingContainer wrapCraftingContainer(Container items, int w, int h) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (int i = 0; i < items.m_6643_(); ++i) {
            itemList.add(items.m_8020_(i));
        }
        return new ReadonlyCraftingContainer(itemList, w, h);
    }

    public static Optional<CraftingRecipe> getCraftingRecipe(Level level, CraftingContainer container) {
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44015_(RecipeType.f_44107_, (Container)container, level);
    }

    public static Optional<SmithingRecipe> getSmithingRecipe(Level level, List<ItemStack> items) {
        SimpleContainer simpleContainer = new SimpleContainer(3);
        for (int i = 0; i < Math.min(3, items.size()); ++i) {
            simpleContainer.m_6836_(i, items.get(i));
        }
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44015_(RecipeType.f_44113_, (Container)simpleContainer, level);
    }

    public static AltarRecipeInventory wrapAltarRecipeInventory(List<ItemStack> items) {
        AltarRecipeInventory inventory = new AltarRecipeInventory();
        for (int i = 0; i < Math.min(6, items.size()); ++i) {
            inventory.m_6836_(i, items.get(i));
        }
        return inventory;
    }

    public static Optional<AltarRecipe> getAltarRecipe(Level level, AltarRecipeInventory container) {
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44015_(InitRecipes.ALTAR_CRAFTING, (Container)container, level);
    }

    public static Optional<SmeltingRecipe> getSmeltingRecipe(Level level, ItemStack itemStack) {
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), level);
    }

    public static Optional<IBrewingRecipe> getBrewingRecipe(Level level, ItemStack item1, ItemStack item2) {
        return BrewingRecipeRegistry.getRecipes().stream().filter(r -> r.isInput(item1) && r.isIngredient(item2)).findFirst();
    }

    public static List<StonecutterRecipe> getStonecuttingRecipe(Level level, ItemStack itemStack) {
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44056_(RecipeType.f_44112_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), level);
    }

    public static class ReadonlyCraftingContainer
    implements CraftingContainer {
        private final List<ItemStack> items;
        private final int w;
        private final int h;

        public ReadonlyCraftingContainer(List<ItemStack> items, int w, int h) {
            this.items = items;
            this.w = w;
            this.h = h;
        }

        public int m_39347_() {
            return this.w;
        }

        public int m_39346_() {
            return this.h;
        }

        public List<ItemStack> m_280657_() {
            return this.items;
        }

        public int m_6643_() {
            return this.w * this.h;
        }

        public boolean m_7983_() {
            return false;
        }

        public ItemStack m_8020_(int p_18941_) {
            return this.items.get(p_18941_);
        }

        public ItemStack m_7407_(int p_18942_, int p_18943_) {
            return ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int p_18951_) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int p_18944_, ItemStack p_18945_) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player p_18946_) {
            return true;
        }

        public void m_6211_() {
        }

        public void m_5809_(StackedContents p_40281_) {
        }
    }
}

