/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.ae2;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.ae2.Ae2BaseContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;

public class Ae2ViewContext
extends Ae2BaseContext
implements IStorageInteractContext {
    int current = 0;
    private List<AEItemKey> keys;

    @Override
    public void start(EntityMaid maid, ServerLevel level, Target target) {
        super.start(maid, level, target);
        if (this.init(maid, level, target)) {
            this.keys = this.inv.getAvailableStacks().keySet().stream().filter(key -> key instanceof AEItemKey).map(key -> (AEItemKey)key).toList();
        }
    }

    @Override
    public boolean isDone() {
        return this.keys == null || this.current >= this.keys.size() || super.isDone();
    }

    @Override
    public void reset() {
        this.current = 0;
        this.setDone(false);
    }

    @Override
    public void tick(Function<ItemStack, ItemStack> process) {
        int count = 0;
        while (this.current < this.keys.size()) {
            if (count++ > 32) {
                return;
            }
            AEItemKey key = this.keys.get(this.current);
            long extract = this.inv.extract((AEKey)key, Long.MAX_VALUE, Actionable.SIMULATE, IActionSource.empty());
            if (extract > Integer.MAX_VALUE) {
                extract = Integer.MAX_VALUE;
            }
            process.apply(key.toStack((int)extract));
            ++this.current;
        }
    }
}

