/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.ItemHandler;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class SimulateTargetInteractHelper {
    public static ConcurrentMap<BlockPos, Set<UUID>> counter = new ConcurrentHashMap<BlockPos, Set<UUID>>();
    public static ConcurrentMap<UUID, EntityMaid> maids = new ConcurrentHashMap<UUID, EntityMaid>();
    public static ConcurrentMap<UUID, BlockPos> maidUsingPos = new ConcurrentHashMap<UUID, BlockPos>();
    final ServerLevel level;
    public final BlockPos target;
    @Nullable
    final BlockEntity blockEntity;
    private final EntityMaid maid;
    @Nullable
    public IItemHandler itemHandler;
    final Player opener;
    int currentSlot = 0;
    int restTick = 0;
    int countPreTick = 10;
    boolean notOpener = false;

    public static void removeInvalid() {
        HashSet uuids = new HashSet(maids.keySet());
        for (UUID uuid : uuids) {
            boolean valid = true;
            if (!maids.containsKey(uuid)) {
                valid = false;
            } else if (!((EntityMaid)maids.get(uuid)).m_6084_()) {
                valid = false;
            }
            if (!maidUsingPos.containsKey(uuid)) {
                valid = false;
            }
            if (valid) continue;
            maids.remove(uuid);
            maidUsingPos.remove(uuid);
            for (BlockPos pos : counter.keySet()) {
                ((Set)counter.get(pos)).remove(uuid);
            }
        }
    }

    public static void addCounter(EntityMaid maid, BlockPos pos) {
        if (!counter.containsKey(pos)) {
            counter.put(pos, ConcurrentHashMap.newKeySet());
        }
        ((Set)counter.get(pos)).add(maid.m_20148_());
        if (maidUsingPos.containsKey(maid.m_20148_())) {
            counter.remove(maidUsingPos.get(maid.m_20148_()));
        }
        maidUsingPos.put(maid.m_20148_(), pos);
        maids.put(maid.m_20148_(), maid);
    }

    public static void removeCounter(EntityMaid maid, BlockPos pos) {
        if (!counter.containsKey(pos)) {
            return;
        }
        ((Set)counter.get(pos)).remove(maid.m_20148_());
        if (((Set)counter.get(pos)).isEmpty()) {
            counter.remove(pos);
        }
        if (maidUsingPos.containsKey(maid.m_20148_())) {
            counter.remove(maidUsingPos.get(maid.m_20148_()));
            maidUsingPos.remove(maid.m_20148_());
        }
        maids.remove(maid.m_20148_());
    }

    public static boolean isMaidOpening(EntityMaid maid) {
        return maidUsingPos.containsKey(maid.m_20148_());
    }

    public static int openCount(BlockPos pos) {
        if (!counter.containsKey(pos)) {
            return 0;
        }
        return ((Set)counter.get(pos)).size();
    }

    public SimulateTargetInteractHelper(EntityMaid maid, BlockPos targetPos, @Nullable Direction side, ServerLevel level) {
        LazyOptional capability;
        this.maid = maid;
        this.target = targetPos;
        this.level = level;
        this.blockEntity = level.m_7702_(this.target);
        this.opener = ChestOpener.getOrCreate(level, maid);
        if (this.blockEntity != null && (capability = side == null ? this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER) : this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side)).isPresent()) {
            this.itemHandler = (IItemHandler)capability.orElseThrow(RuntimeException::new);
            if (this.itemHandler.getSlots() > 60) {
                this.countPreTick = this.itemHandler.getSlots() / 6;
            }
        }
    }

    protected boolean isStillValid() {
        if (this.blockEntity == null || this.itemHandler == null) {
            return false;
        }
        return !this.blockEntity.m_58901_();
    }

    private Optional<ContainerOpenersCounter> trySeekCounter(BlockEntity blockEntity) {
        Field[] fields;
        for (Field field : fields = blockEntity.getClass().getDeclaredFields()) {
            if (!field.getType().equals(ContainerOpenersCounter.class)) continue;
            try {
                field.setAccessible(true);
                return Optional.of((ContainerOpenersCounter)field.get(blockEntity));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (blockEntity instanceof WorldlyContainer) {
            final WorldlyContainer wc = (WorldlyContainer)blockEntity;
            return Optional.of(new ContainerOpenersCounter(){

                public void m_155468_(Player p_155469_, Level p_155470_, BlockPos p_155471_, BlockState p_155472_) {
                    wc.m_5785_(p_155469_);
                }

                public void m_155452_(Player p_155453_, Level p_155454_, BlockPos p_155455_, BlockState p_155456_) {
                    wc.m_5856_(p_155453_);
                }

                protected void m_142292_(Level p_155460_, BlockPos p_155461_, BlockState p_155462_) {
                }

                protected void m_142289_(Level p_155473_, BlockPos p_155474_, BlockState p_155475_) {
                }

                protected void m_142148_(Level p_155463_, BlockPos p_155464_, BlockState p_155465_, int p_155466_, int p_155467_) {
                }

                protected boolean m_142718_(Player p_155451_) {
                    return false;
                }
            });
        }
        return Optional.empty();
    }

    public boolean doneTaking() {
        if (this.restTick > 0) {
            return false;
        }
        if (!this.isStillValid()) {
            return true;
        }
        return this.itemHandler == null || this.currentSlot >= this.itemHandler.getSlots();
    }

    public boolean doneViewing() {
        return this.doneTaking();
    }

    public void open() {
        if (this.blockEntity == null) {
            return;
        }
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
        if (!SimulateTargetInteractHelper.isMaidOpening(this.maid)) {
            this.trySeekCounter(this.blockEntity).ifPresent(containerOpenersCounter -> containerOpenersCounter.m_155452_(this.opener, (Level)this.level, this.target, this.level.m_8055_(this.target)));
            SimulateTargetInteractHelper.addCounter(this.maid, this.target);
        } else {
            this.notOpener = true;
        }
        this.currentSlot = 0;
    }

    public void takeItemTick(Function<ItemStack, ItemStack> cb) {
        if (this.itemHandler == null) {
            return;
        }
        int count = 0;
        while (this.currentSlot < this.itemHandler.getSlots() && ++count < this.countPreTick) {
            ItemStack result;
            ItemStack copy = this.itemHandler.extractItem(this.currentSlot, this.itemHandler.getStackInSlot(this.currentSlot).m_41613_(), true).m_41777_();
            int originalCount = copy.m_41613_();
            if (!copy.m_41619_() && (result = cb.apply(copy)).m_41613_() != originalCount) {
                this.itemHandler.extractItem(this.currentSlot, originalCount - result.m_41613_(), false);
                break;
            }
            ++this.currentSlot;
        }
    }

    public void viewItemTick(Consumer<ItemStack> cb) {
        if (this.itemHandler == null) {
            return;
        }
        int count = 0;
        while (this.currentSlot < this.itemHandler.getSlots() && ++count < this.countPreTick) {
            ItemStack stack = this.itemHandler.getStackInSlot(this.currentSlot);
            if (!stack.m_41619_()) {
                cb.accept(stack);
            }
            ++this.currentSlot;
        }
    }

    public void reset() {
        this.currentSlot = 0;
    }

    public void stop() {
        if (!this.notOpener) {
            if (this.blockEntity != null && this.opener != null && this.isStillValid()) {
                this.trySeekCounter(this.blockEntity).ifPresent(containerOpenersCounter -> containerOpenersCounter.m_155468_(this.opener, (Level)this.level, this.target, this.level.m_8055_(this.target)));
            }
            SimulateTargetInteractHelper.removeCounter(this.maid, this.target);
        }
    }

    public static class ChestOpener {
        public static ConcurrentMap<UUID, UUID> cache = new ConcurrentHashMap<UUID, UUID>();

        public static FakePlayer getOrCreate(ServerLevel level, EntityMaid maid) {
            if (!cache.containsKey(maid.m_20148_())) {
                cache.put(maid.m_20148_(), maid.m_20148_());
            }
            return FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile((UUID)cache.get(maid.m_20148_()), maid.m_7755_().getString()));
        }
    }
}

