/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import me.towdium.jecharacters.utils.Match;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fml.ModList;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.data.InventoryListDataClient;
import studio.fantasyit.maid_storage_manager.menu.base.IItemTarget;

public class InventoryListScreen
extends Screen {
    private static SortOption sortingOption = SortOption.DEFAULT;
    private static FilterOption filterOption = FilterOption.ALL;
    private final Button prevButton;
    private final Button nextButton;
    private final Button sortingButton;
    private final Button filterButton;
    private final InventoryListDataClient data;
    private final UUID uuid;
    protected int left = 0;
    protected int top = 0;
    protected int width = 0;
    protected int height = 0;
    protected int gridSize = 0;
    private int gridStart = 0;
    private int columns;
    private int rows;
    private List<InventoryItem> originalList;
    private List<InventoryItem> list;
    private String search;
    private EditBox searchBox;
    private Screen toSelectTarget = null;

    public InventoryListScreen(UUID uuid, Screen toSelectTarget) {
        this(uuid);
        this.toSelectTarget = toSelectTarget;
    }

    public InventoryListScreen(UUID uuid) {
        super((Component)Component.m_237119_());
        this.uuid = uuid;
        this.prevButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.previous"), button -> this.doPrev()).m_253046_(16, 16).m_253136_();
        this.nextButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.next"), button -> this.doNext()).m_253046_(16, 16).m_253136_();
        this.sortingButton = Button.m_253074_((Component)Component.m_237113_((String)""), btn -> this.switchSorting()).m_253046_(96, 16).m_253136_();
        this.filterButton = Button.m_253074_((Component)Component.m_237113_((String)""), button -> this.switchFilter()).m_253046_(96, 16).m_253136_();
        InventoryListDataClient.clearShowingInv();
        this.data = InventoryListDataClient.getInstance();
        this.originalList = this.data.get(uuid);
        this.list = this.originalList;
    }

    private void switchFilter() {
        filterOption = FilterOption.values()[(filterOption.ordinal() + 1) % FilterOption.values().length];
        this.filterButton.m_93666_(InventoryListScreen.filterOption.component);
        this.reGenerateList();
    }

    private void switchSorting() {
        sortingOption = SortOption.values()[(sortingOption.ordinal() + 1) % SortOption.values().length];
        this.sortingButton.m_93666_(InventoryListScreen.sortingOption.component);
        this.reGenerateList();
    }

    private void doPrev() {
        if (this.gridStart == 0) {
            return;
        }
        this.gridStart -= this.gridSize;
    }

    private void doNext() {
        if (this.data.get(this.uuid).size() <= this.gridStart + this.gridSize) {
            return;
        }
        this.gridStart += this.gridSize;
    }

    protected List<Component> getTooltipForResult(int index) {
        InventoryItem inventoryItem = this.list.get(index);
        ArrayList<Component> tooltip = new ArrayList<Component>(Screen.m_280152_((Minecraft)this.f_96541_, (ItemStack)inventoryItem.itemStack));
        if (this.toSelectTarget == null) {
            if (inventoryItem.posAndSlot.stream().anyMatch(InventoryItem.PositionCount::isCraftGuide)) {
                tooltip.add((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.craftable"));
            }
            if (inventoryItem.posAndSlot.stream().anyMatch(t -> !t.isCraftGuide())) {
                tooltip.add((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.find"));
            }
            for (InventoryItem.PositionCount pair : inventoryItem.posAndSlot) {
                if (!pair.isCraftGuide()) {
                    tooltip.add((Component)Component.m_237110_((String)"gui.maid_storage_manager.written_inventory_list.pos", (Object[])new Object[]{pair.pos().getPos().m_123341_(), pair.pos().getPos().m_123342_(), pair.pos().getPos().m_123343_(), pair.count()}).m_130940_(ChatFormatting.DARK_GRAY));
                    continue;
                }
                tooltip.add((Component)Component.m_237110_((String)"gui.maid_storage_manager.written_inventory_list.craft_guide_pos", (Object[])new Object[]{pair.pos().getPos().m_123341_(), pair.pos().getPos().m_123342_(), pair.pos().getPos().m_123343_()}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.select"));
        }
        return tooltip;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.width = (Math.min(this.f_96541_.m_91268_().m_85445_(), 300) - 10) / 18 * 18 + 10;
        this.height = Math.min(this.f_96541_.m_91268_().m_85446_(), 300);
        this.left = (this.f_96541_.m_91268_().m_85445_() - this.width) / 2;
        this.top = (this.f_96541_.m_91268_().m_85446_() - this.height) / 2;
        this.searchBox = new EditBox(this.f_96547_, this.left + (this.width - 100) / 2, this.top + this.height - 16, 100, 16, (Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.search"));
        this.columns = (this.width - 10) / 18;
        this.rows = (this.height - 50) / 18;
        this.gridSize = this.rows * this.columns;
        this.gridStart = 0;
        this.prevButton.m_252865_(this.left);
        this.prevButton.m_253211_(this.top);
        this.nextButton.m_252865_(this.left + this.width - this.nextButton.m_5711_());
        this.nextButton.m_253211_(this.top);
        this.sortingButton.m_252865_(this.left);
        this.sortingButton.m_253211_(this.top + this.height - 16);
        this.sortingButton.m_93666_(InventoryListScreen.sortingOption.component);
        this.filterButton.m_252865_(this.left + this.width - this.filterButton.m_5711_());
        this.filterButton.m_253211_(this.top + this.height - 16);
        this.filterButton.m_93666_(InventoryListScreen.filterOption.component);
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)this.sortingButton);
        this.m_142416_((GuiEventListener)this.filterButton);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.data.get(this.uuid).size() != this.originalList.size()) {
            this.originalList = this.data.get(this.uuid);
            this.list = this.originalList;
            this.search = null;
        }
        if (!this.searchBox.m_94155_().equals(this.search)) {
            this.search = this.searchBox.m_94155_();
            this.reGenerateList();
        }
        if (this.gridStart >= this.list.size() && this.gridStart != 0) {
            this.gridStart -= this.gridSize;
        }
        this.nextButton.f_93623_ = this.list.size() >= this.gridStart + this.gridSize;
        this.prevButton.f_93623_ = this.gridStart != 0;
    }

    private void reGenerateList() {
        this.list = this.search.equals("") ? this.originalList : this.originalList.stream().filter(inventoryItem -> {
            ItemStack itemStack = inventoryItem.itemStack;
            if (ModList.get().isLoaded("jecharacters")) {
                if (Match.matches((String)itemStack.m_41786_().getString(), (String)this.search)) {
                    return true;
                }
                if (Match.matches((String)Component.m_237115_((String)itemStack.m_41778_()).getString(), (String)this.search)) {
                    return true;
                }
                if (itemStack.m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)TooltipFlag.f_256730_).stream().anyMatch(component -> Match.matches((String)component.getString(), (String)this.search))) {
                    return true;
                }
            }
            if (itemStack.m_41786_().getString().contains(this.search)) {
                return true;
            }
            if (Component.m_237115_((String)itemStack.m_41778_()).getString().contains(this.search)) {
                return true;
            }
            return itemStack.m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)TooltipFlag.f_256730_).stream().anyMatch(component -> component.getString().contains(this.search));
        }).toList();
        this.list = this.list.stream().filter(InventoryListScreen.filterOption.predicate).sorted(InventoryListScreen.sortingOption.comparator).toList();
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float p_282465_) {
        int iy;
        int ix;
        int index;
        int j;
        int i;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, x, y, p_282465_);
        for (i = 0; i < this.rows; ++i) {
            for (j = 0; j < this.columns; ++j) {
                index = i * this.columns + j + this.gridStart;
                if (index >= this.list.size()) continue;
                ix = this.left + 5 + j * 18;
                iy = this.top + 20 + i * 18;
                ItemStack item = this.list.get((int)index).itemStack;
                guiGraphics.m_280480_(item, ix, iy);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                guiGraphics.m_280370_(this.f_96547_, item, ix, iy);
                guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                String string = Integer.toString(this.list.get((int)index).totalCount);
                int n = 2 * ix + 32 - this.f_96547_.m_92895_(Integer.toString(this.list.get((int)index).totalCount));
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280488_(this.f_96547_, string, n, 2 * iy + 32 - 9, 0xFFFFFF);
                guiGraphics.m_280168_().m_85849_();
            }
        }
        guiGraphics.m_280262_();
        for (i = 0; i < this.rows; ++i) {
            for (j = 0; j < this.columns; ++j) {
                index = i * this.columns + j + this.gridStart;
                if (index >= this.list.size()) continue;
                ix = this.left + 5 + j * 18;
                iy = this.top + 20 + i * 18;
                if (x < ix || x >= ix + 16 || y < iy || y >= iy + 16) continue;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 5000.0f);
                guiGraphics.m_280677_(this.f_96547_, this.getTooltipForResult(index), Optional.empty(), x, y);
                guiGraphics.m_280168_().m_85849_();
            }
        }
        int currentPage = this.gridStart / this.gridSize + 1;
        int totalPage = (int)Math.ceil((double)this.list.size() / (double)this.gridSize);
        MutableComponent component = Component.m_237110_((String)"gui.maid_storage_manager.written_inventory_list.inventory_list_page", (Object[])new Object[]{currentPage, totalPage});
        guiGraphics.m_280430_(this.f_96547_, (Component)component, this.left + this.width / 2 - this.f_96547_.m_92852_((FormattedText)component) / 2, this.top, 0xFFFFFF);
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        if (p_94688_ < 0.0) {
            this.doNext();
        } else if (p_94688_ > 0.0) {
            this.doPrev();
        }
        return true;
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        int idx;
        int ix = (int)Math.floor((x - (double)this.left) / 18.0);
        int iy = (int)Math.floor((y - (double)this.top - 20.0) / 18.0);
        if (ix >= 0 && ix < this.columns && iy >= 0 && iy < this.rows && (idx = iy * this.columns + ix + this.gridStart) < this.list.size()) {
            if (this.toSelectTarget != null) {
                Screen screen = this.toSelectTarget;
                if (screen instanceof IItemTarget) {
                    IItemTarget iit = (IItemTarget)screen;
                    iit.itemSelected(this.list.get((int)idx).itemStack);
                }
                this.f_96541_.m_91152_(this.toSelectTarget);
            } else {
                InventoryListDataClient.setShowingInv(this.list.get(idx), 400);
                this.f_96541_.m_91152_(null);
            }
        }
        return super.m_6375_(x, y, p_94697_);
    }

    private static enum FilterOption {
        ALL((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.filter.all"), inventoryItem -> true),
        STORED((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.filter.stored"), inventoryItem -> inventoryItem.posAndSlot.stream().anyMatch(t -> !t.isCraftGuide())),
        CRAFTABLE((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.filter.craftable"), inventoryItem -> inventoryItem.posAndSlot.stream().anyMatch(InventoryItem.PositionCount::isCraftGuide));

        public final Component component;
        public final Predicate<InventoryItem> predicate;

        private FilterOption(Component component, Predicate<InventoryItem> predicate) {
            this.component = component;
            this.predicate = predicate;
        }
    }

    private static enum SortOption {
        DEFAULT((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.sorting.default"), (a, b) -> 0),
        NAME((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.sorting.name_p"), Comparator.comparing(a -> a.itemStack.m_41786_().getString())),
        NAME_N((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.sorting.name_n"), (a, b) -> -a.itemStack.m_41786_().getString().compareTo(b.itemStack.m_41786_().getString())),
        COUNT((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.sorting.count_p"), Comparator.comparingInt(t -> t.totalCount)),
        COUNT_N((Component)Component.m_237115_((String)"gui.maid_storage_manager.written_inventory_list.sorting.count_n"), Comparator.comparingInt(t -> -t.totalCount));

        public final Component component;
        public final Comparator<InventoryItem> comparator;

        private SortOption(Component component, Comparator<InventoryItem> comparator) {
            this.component = component;
            this.comparator = comparator;
        }
    }
}

