/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.ItemSelectorMenu;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.InventoryListUtil;

public class RequestRecipeHandler
implements IUniversalRecipeTransferHandler<ItemSelectorMenu> {
    @NotNull
    public Class getContainerClass() {
        return ItemSelectorMenu.class;
    }

    @NotNull
    public Optional<MenuType<ItemSelectorMenu>> getMenuType() {
        return Optional.of((MenuType)GuiRegistry.ITEM_SELECTOR_MENU.get());
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull ItemSelectorMenu container, @NotNull Object recipe, IRecipeSlotsView recipeSlots, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        List<ItemStack> inputs = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT).stream().map(e -> InventoryListUtil.getMatchingForPlayer(e.getItemStacks().toList())).filter(i -> !i.m_41619_()).toList();
        ArrayList<Pair<Integer, ItemStack>> list = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i2 = 0; i2 < Math.min(inputs.size(), 10); ++i2) {
            list.add((Pair<Integer, ItemStack>)Pair.of((Object)i2, (Object)inputs.get(i2)));
            if (!doTransfer) continue;
            container.filteredItems.m_6836_(i2, inputs.get(i2));
        }
        if (doTransfer) {
            Network.sendItemSelectorSetItemPacket(list);
        }
        if (inputs.size() > 10) {
            return new ExceedError();
        }
        return null;
    }

    public static class ExceedError
    implements IRecipeTransferError {
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void getTooltip(ITooltipBuilder tooltip) {
            tooltip.add((FormattedText)Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.jei.too_many_to_transfer"));
        }
    }
}

