/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.work;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.craft.work.SolvedCraftLayer;
import studio.fantasyit.maid_storage_manager.items.ProgressPad;
import studio.fantasyit.maid_storage_manager.items.WorkCardItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.PlacingInventoryMemory;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class ProgressData {
    public final List<TaskProgress> working;
    public final Component maidName;
    public final List<Component> workGroups;
    public final List<ItemStack> items;
    public final int total;
    public final int progress;
    public final Status status;
    public final int tickCount;
    public final int maxSz;

    public ProgressData(List<TaskProgress> working, Component maidName, List<Component> workGroups, List<ItemStack> items, int total, int progress, int tickCount, int maxSz, Status status) {
        this.working = working;
        this.maidName = maidName;
        this.workGroups = workGroups;
        this.items = items;
        this.total = total;
        this.progress = progress;
        this.tickCount = tickCount;
        this.maxSz = maxSz;
        this.status = status;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.m_236828_(this.working, (t, d) -> d.toNetwork((FriendlyByteBuf)t));
        buf.m_130083_(this.maidName);
        buf.m_236828_(this.workGroups, FriendlyByteBuf::m_130083_);
        buf.m_236828_(this.items, (t, i) -> t.m_130079_(ItemStackUtil.saveStack(i)));
        buf.writeInt(this.total);
        buf.writeInt(this.progress);
        buf.writeInt(this.tickCount);
        buf.writeInt(this.maxSz);
        buf.m_130068_((Enum)this.status);
    }

    public static ProgressData fromNetwork(FriendlyByteBuf buf) {
        return new ProgressData((List)buf.m_236838_(ArrayList::new, TaskProgress::fromNetwork), buf.m_130238_(), (List)buf.m_236838_(ArrayList::new, FriendlyByteBuf::m_130238_), (List)buf.m_236838_(ArrayList::new, t -> ItemStackUtil.parseStack(t.m_130260_())), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), (Status)buf.m_130066_(Status.class));
    }

    public static ProgressData fromPlan(EntityMaid maid, ServerLevel level, CraftLayerChain plan, ProgressPad.Viewing viewing, ProgressPad.Merge merge, int maxSz) {
        List<TaskProgress> toList = new ArrayList<TaskProgress>();
        List<ItemStack> targetItem = List.of();
        boolean peekItem = false;
        block10: for (int i = 0; i < plan.getLayerCount(); ++i) {
            UUID takerUUID;
            Entity entity;
            SolvedCraftLayer node = plan.getNode(i);
            CraftLayer layer = plan.getLayer(i);
            if (node.group() != plan.getCurrentGroup()) continue;
            if (peekItem && layer.getCraftData().isEmpty()) {
                targetItem = layer.getItems();
            }
            peekItem = true;
            switch ((SolvedCraftLayer.Progress)((Object)node.progress().getValue())) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case IDLE: 
                case WAITING: {
                    if (viewing != ProgressPad.Viewing.WAITING) continue block10;
                    break;
                }
                case DISPATCHED: 
                case WORKING: 
                case GATHERING: {
                    if (viewing != ProgressPad.Viewing.WORKING) continue block10;
                    break;
                }
                case FINISHED: {
                    if (viewing != ProgressPad.Viewing.DONE) continue block10;
                    break;
                }
                case FAILED: {
                    if (viewing == ProgressPad.Viewing.WORKING) continue block10;
                }
            }
            Status status = switch ((SolvedCraftLayer.Progress)((Object)node.progress().getValue())) {
                case SolvedCraftLayer.Progress.IDLE, SolvedCraftLayer.Progress.WAITING -> Status.WAITING;
                case SolvedCraftLayer.Progress.FAILED -> Status.FAILED;
                default -> Status.NORMAL;
            };
            int totalSteps = layer.getCount();
            int processedSteps = layer.getDoneCount();
            if (node.progress().getValue() == SolvedCraftLayer.Progress.WORKING || node.progress().getValue() == SolvedCraftLayer.Progress.GATHERING) {
                ++processedSteps;
            }
            List<Component> taker = List.of();
            if (node.progress().getValue() == SolvedCraftLayer.Progress.DISPATCHED && (entity = level.m_8791_(takerUUID = plan.getLayerTaker(node.index()))) instanceof EntityMaid) {
                CraftLayerChain dispatchedPlan;
                EntityMaid takerMaid = (EntityMaid)entity;
                taker = List.of(takerMaid.m_5446_());
                if (MemoryUtil.getCrafting(takerMaid).hasPlan() && (dispatchedPlan = MemoryUtil.getCrafting(takerMaid).plan()).hasCurrent()) {
                    CraftLayer dispatchedLayer = dispatchedPlan.getCurrentLayer();
                    totalSteps = dispatchedLayer.getCount();
                    processedSteps = dispatchedLayer.getDoneCount();
                    if (plan.getIsStoppingAdding()) {
                        status = Status.FAILED;
                    }
                }
                if (MemoryUtil.getRequestProgress(takerMaid).isReturning()) {
                    processedSteps = 0;
                    totalSteps = 0;
                }
            }
            toList.add(new TaskProgress(layer.getCraftData().map(CraftGuideData::getOutput).map(t -> t.stream().map(ii -> ii.m_255036_(ii.m_41613_() * layer.getCount())).toList()).orElse(List.of()), totalSteps, processedSteps, status, taker));
        }
        toList = ProgressData.mergeAndSlice(merge, maxSz, toList);
        int done = 0;
        int total = 0;
        for (int i = 0; i < plan.getLayerCount(); ++i) {
            CraftLayer layer = plan.getLayer(i);
            SolvedCraftLayer node = plan.getNode(i);
            if (node.progress().getValue() == SolvedCraftLayer.Progress.FINISHED) {
                done += layer.getCount() * layer.getTotalStep() + 1;
            } else if (node.progress().getValue() == SolvedCraftLayer.Progress.WORKING || node.progress().getValue() == SolvedCraftLayer.Progress.DISPATCHED) {
                done += layer.getDoneCount() * layer.getTotalStep() + layer.getStep() + 1;
            }
            total += layer.getCount() * layer.getTotalStep() + 1;
        }
        return new ProgressData(toList, maid.m_7755_(), WorkCardItem.getAllWorkCards(maid), targetItem, total, done, maid.f_19797_, maxSz, plan.getIsStoppingAdding() ? Status.FAILED : Status.NORMAL);
    }

    public static ProgressData fromMaidNoPlan(EntityMaid maid, int maxSz) {
        Item icon = switch (MemoryUtil.getCurrentlyWorking(maid)) {
            case ScheduleBehavior.Schedule.CO_WORK -> Items.f_42680_;
            case ScheduleBehavior.Schedule.MEAL -> Items.f_42580_;
            case ScheduleBehavior.Schedule.LOGISTICS -> (Item)ItemRegistry.LOGISTICS_GUIDE.get();
            case ScheduleBehavior.Schedule.RESORT -> Items.f_42009_;
            default -> null;
        };
        return new ProgressData(List.of(), maid.m_7755_(), WorkCardItem.getAllWorkCards(maid), icon != null ? List.of(icon.m_7968_()) : List.of(), 0, 0, maid.f_19797_, maxSz, Status.WAITING);
    }

    public static ProgressData fromRequest(EntityMaid maid, ServerLevel level, ItemStack requestList, ProgressPad.Viewing viewing, ProgressPad.Merge merge, int maxSz) {
        if (!requestList.m_41782_()) {
            return ProgressData.fromMaidNoPlan(maid, maxSz);
        }
        ListTag list = Objects.requireNonNull(requestList.m_41783_()).m_128437_("items", 10);
        MutableInt total = new MutableInt(0);
        MutableInt done = new MutableInt(0);
        List<TaskProgress> progresses = list.stream().filter(t -> !((CompoundTag)t).m_128471_("done")).map(t -> {
            ItemStack item = ItemStackUtil.parseStack(((CompoundTag)t).m_128469_("item"));
            if (item.m_41619_()) {
                return null;
            }
            int cnt = ((CompoundTag)t).m_128451_("requested");
            int collected = ((CompoundTag)t).m_128451_("collected");
            total.increment();
            if (cnt != -1 && collected >= cnt) {
                done.increment();
            }
            return new TaskProgress(List.of(item), cnt, collected, Status.NORMAL, List.of());
        }).filter(Objects::nonNull).toList();
        progresses = ProgressData.mergeAndSlice(merge, maxSz, progresses);
        return new ProgressData(progresses, maid.m_7755_(), WorkCardItem.getAllWorkCards(maid), List.of(((Item)ItemRegistry.REQUEST_LIST_ITEM.get()).m_7968_()), total.getValue(), done.getValue(), maid.f_19797_, maxSz, Status.NORMAL);
    }

    @NotNull
    private static List<TaskProgress> mergeAndSlice(ProgressPad.Merge merge, int maxSz, List<TaskProgress> progresses) {
        if (merge == ProgressPad.Merge.ALWAYS) {
            progresses = ProgressData.mergeSame(progresses);
        }
        if (progresses.size() > maxSz) {
            if (merge == ProgressPad.Merge.OVERFLOW_ONLY) {
                progresses = ProgressData.mergeSame(progresses.subList(0, maxSz));
            }
            if (progresses.size() > maxSz) {
                progresses = progresses.subList(0, maxSz);
            }
        }
        return progresses;
    }

    private static ProgressData fromPlacing(EntityMaid maid, ServerLevel level, PlacingInventoryMemory placingInv, ProgressPad.Viewing viewing, ProgressPad.Merge merge, int maxSz) {
        List<TaskProgress> list = placingInv.arrangeItems.stream().map(item -> new TaskProgress(List.of(item), 1, 0, Status.NORMAL, List.of())).toList();
        list = ProgressData.mergeAndSlice(merge, maxSz, list);
        return new ProgressData(list, maid.m_7755_(), WorkCardItem.getAllWorkCards(maid), List.of(Items.f_42009_.m_7968_()), 0, 0, maid.f_19797_, maxSz, Status.NORMAL);
    }

    public static ProgressData fromMaidAuto(EntityMaid maid, ServerLevel level, ProgressPad.Viewing viewing, ProgressPad.Merge merge, int maxSz) {
        if (Conditions.takingRequestList(maid)) {
            if (MemoryUtil.getCrafting(maid).hasPlan() && !MemoryUtil.getRequestProgress(maid).isReturning()) {
                if (MemoryUtil.getCrafting(maid).isGoPlacingBeforeCraft()) {
                    return ProgressData.fromPlacing(maid, level, MemoryUtil.getPlacingInv(maid), viewing, merge, maxSz);
                }
                return ProgressData.fromPlan(maid, level, MemoryUtil.getCrafting(maid).plan(), viewing, merge, maxSz);
            }
            if (maid.m_21205_().m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
                if (MemoryUtil.getCrafting((EntityMaid)maid).calculatingTotal != -1) {
                    return new ProgressData(List.of(), maid.m_5446_(), WorkCardItem.getAllWorkCards(maid), List.of(((Item)ItemRegistry.PORTABLE_CRAFT_CALCULATOR_BAUBLE.get()).m_7968_()), MemoryUtil.getCrafting((EntityMaid)maid).calculatingTotal, MemoryUtil.getCrafting((EntityMaid)maid).calculatingProgress, maid.f_19797_, maxSz, Status.NORMAL);
                }
                return ProgressData.fromRequest(maid, level, maid.m_21205_(), viewing, merge, maxSz);
            }
        } else if (MemoryUtil.getCurrentlyWorking(maid) == ScheduleBehavior.Schedule.PLACE) {
            return ProgressData.fromPlacing(maid, level, MemoryUtil.getPlacingInv(maid), viewing, merge, maxSz);
        }
        return ProgressData.fromMaidNoPlan(maid, maxSz);
    }

    public static List<TaskProgress> mergeSame(List<TaskProgress> tasks) {
        ArrayList<TaskProgress> res = new ArrayList<TaskProgress>();
        for (TaskProgress task : tasks) {
            boolean found = false;
            for (int i = res.size() - 1; i >= 0; --i) {
                if (task.outputs.size() != ((TaskProgress)res.get((int)i)).outputs.size()) continue;
                boolean eq = true;
                for (int j = 0; eq && j < task.outputs.size(); ++j) {
                    eq = eq && ItemStackUtil.isSameInCrafting(task.outputs.get(j), ((TaskProgress)res.get((int)i)).outputs.get(j));
                }
                if (!eq) continue;
                ArrayList<ItemStack> newOutputs = new ArrayList<ItemStack>();
                ArrayList<Component> allTakers = new ArrayList<Component>();
                for (int j = 0; j < task.outputs.size(); ++j) {
                    newOutputs.add(((TaskProgress)res.get((int)i)).outputs.get(j).m_255036_(task.outputs.get(j).m_41613_() + ((TaskProgress)res.get((int)i)).outputs.get(j).m_41613_()));
                }
                allTakers.addAll(((TaskProgress)res.get(i)).taker());
                allTakers.addAll(task.taker());
                res.set(i, new TaskProgress(newOutputs, task.total() + ((TaskProgress)res.get(i)).total(), task.progress() + ((TaskProgress)res.get(i)).progress(), task.status(), allTakers));
                found = true;
            }
            if (found) continue;
            res.add(task);
        }
        return res;
    }

    public static enum Status {
        NORMAL,
        WAITING,
        FAILED;

    }

    public record TaskProgress(List<ItemStack> outputs, int total, int progress, Status status, List<Component> taker) {
        public static TaskProgress fromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return new TaskProgress((List)friendlyByteBuf.m_236838_(ArrayList::new, t -> ItemStackUtil.parseStack(t.m_130260_())), friendlyByteBuf.readInt(), friendlyByteBuf.readInt(), (Status)friendlyByteBuf.m_130066_(Status.class), (List)friendlyByteBuf.m_236838_(ArrayList::new, FriendlyByteBuf::m_130238_));
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.m_236828_(this.outputs, (t, c) -> t.m_130079_(ItemStackUtil.saveStack(c)));
            friendlyByteBuf.writeInt(this.total);
            friendlyByteBuf.writeInt(this.progress);
            friendlyByteBuf.m_130068_((Enum)this.status);
            friendlyByteBuf.m_236828_(this.taker, FriendlyByteBuf::m_130083_);
        }
    }

    public record ProgressMeta(UUID uuid, ProgressPad.Viewing viewing, ProgressPad.Style style, ProgressPad.Merge merge) {
        public static ProgressMeta fromNetwork(FriendlyByteBuf buf) {
            return new ProgressMeta(buf.m_130259_(), ProgressPad.Viewing.valueOf(buf.m_130277_()), ProgressPad.Style.valueOf(buf.m_130277_()), ProgressPad.Merge.valueOf(buf.m_130277_()));
        }

        @Nullable
        public static ProgressMeta fromItemStack(ItemStack itemStack) {
            UUID bindingUUID = ProgressPad.getBindingUUID(itemStack);
            if (bindingUUID == null) {
                return null;
            }
            return new ProgressMeta(bindingUUID, ProgressPad.getViewing(itemStack), ProgressPad.getStyle(itemStack), ProgressPad.getMerge(itemStack));
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130077_(this.uuid);
            buf.m_130070_(this.viewing.name());
            buf.m_130070_(this.style.name());
            buf.m_130070_(this.merge.name());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ProgressMeta) {
                ProgressMeta progressMeta = (ProgressMeta)obj;
                return progressMeta.uuid.equals(this.uuid) && progressMeta.viewing == this.viewing && progressMeta.style == this.style && progressMeta.merge == this.merge;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.uuid.hashCode() * 31 + this.merge.hashCode() * 17 + this.viewing.hashCode() * 13 + this.style.hashCode();
        }
    }
}

