/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class CraftGuideRenderData {
    public final List<Pair<Target, ResourceLocation>> stepBindings;
    public final List<ItemStack> outputs;
    public final ItemStack icon;
    public final List<ItemStack> inputs;
    public int selecting = -1;
    public static final CraftGuideRenderData EMPTY = new CraftGuideRenderData(List.of(), List.of(), List.of(), ItemStack.f_41583_);

    public CraftGuideRenderData(List<Pair<Target, ResourceLocation>> stepBindings, List<ItemStack> inputs, List<ItemStack> outputs, ItemStack icon) {
        this(stepBindings, inputs, outputs, icon, -1);
    }

    public CraftGuideRenderData(List<Pair<Target, ResourceLocation>> stepBindings, List<ItemStack> inputs, List<ItemStack> outputs, ItemStack icon, int selecting) {
        this.stepBindings = stepBindings;
        this.outputs = outputs;
        this.inputs = inputs;
        this.icon = icon;
        this.selecting = selecting;
    }

    public static void recalculateItemStack(ItemStack itemStack) {
        CraftGuideData craftGuideData = CraftGuideData.fromItemStack(itemStack);
        CompoundTag data = new CompoundTag();
        ItemStack icon1 = CraftManager.getInstance().getType(craftGuideData.getType()).getIcon();
        data.m_128365_("icon", (Tag)ItemStackUtil.saveStack(icon1));
        ListTag inputs = new ListTag();
        for (ItemStack itemStack2 : craftGuideData.getInput()) {
            if (itemStack2.m_41619_()) continue;
            inputs.add((Object)ItemStackUtil.saveStack(itemStack2));
        }
        data.m_128365_("inputs", (Tag)inputs);
        ListTag outputs = new ListTag();
        for (ItemStack output : craftGuideData.getOutput()) {
            if (output.m_41619_()) continue;
            outputs.add((Object)ItemStackUtil.saveStack(output));
        }
        data.m_128365_("outputs", (Tag)outputs);
        ListTag listTag = new ListTag();
        for (CraftGuideStepData stepBinding : craftGuideData.getSteps()) {
            CompoundTag stepBindingTag = new CompoundTag();
            stepBindingTag.m_128365_("pos", (Tag)stepBinding.getStorage().toNbt());
            stepBindingTag.m_128359_("type", stepBinding.action.toString());
            listTag.add((Object)stepBindingTag);
        }
        data.m_128365_("stepBindings", (Tag)listTag);
        itemStack.m_41784_().m_128365_("renderData", (Tag)data);
    }

    public static CraftGuideRenderData fromItemStack(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128441_("input1")) {
            CraftGuideData.fromItemStack(itemStack);
            return CraftGuideRenderData.fromItemStack(itemStack);
        }
        if (tag.m_128441_("renderData")) {
            CompoundTag renderData = tag.m_128469_("renderData");
            ItemStack icon = ItemStackUtil.parseStack(renderData.m_128469_("icon"));
            ListTag outputs = renderData.m_128437_("outputs", 10);
            ArrayList<ItemStack> outputs1 = new ArrayList<ItemStack>();
            for (int i = 0; i < outputs.size(); ++i) {
                outputs1.add(ItemStackUtil.parseStack(outputs.m_128728_(i)));
            }
            ListTag inputs = renderData.m_128437_("inputs", 10);
            ArrayList<ItemStack> inputs1 = new ArrayList<ItemStack>();
            for (int i = 0; i < inputs.size(); ++i) {
                inputs1.add(ItemStackUtil.parseStack(inputs.m_128728_(i)));
            }
            ListTag stepBindings = renderData.m_128437_("stepBindings", 10);
            ArrayList<Pair<Target, ResourceLocation>> stepBindings1 = new ArrayList<Pair<Target, ResourceLocation>>();
            for (int i = 0; i < stepBindings.size(); ++i) {
                CompoundTag stepBinding = stepBindings.m_128728_(i);
                stepBindings1.add((Pair<Target, ResourceLocation>)new Pair((Object)Target.fromNbt(stepBinding.m_128469_("pos")), (Object)ResourceLocation.m_135820_((String)stepBinding.m_128461_("type"))));
            }
            int selecting = -1;
            if (tag.m_128441_("selecting")) {
                selecting = tag.m_128451_("selecting");
            }
            return new CraftGuideRenderData(stepBindings1, inputs1, outputs1, icon, selecting);
        }
        return EMPTY;
    }
}

