/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.WrappedMaidFakePlayer;

public class CommonAttackAction
extends AbstractCraftActionContext {
    public static final ActionOption<USE_TYPE> OPTION_USE_METHOD = new ActionOption<USE_TYPE>(new ResourceLocation("maid_storage_manager", "attack_mode"), new Component[]{Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.attack_destroy"), Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.attack_single")}, new ResourceLocation[]{new ResourceLocation("maid_storage_manager:textures/gui/craft/option/use_long.png"), new ResourceLocation("maid_storage_manager:textures/gui/craft/option/use_single.png")}, "", new ActionOption.BiConverter<Integer, USE_TYPE>(i -> USE_TYPE.values()[i], Enum::ordinal), ActionOption.ValuePredicatorOrGetter.getter(t -> switch (t) {
        default -> throw new IncompatibleClassChangeError();
        case USE_TYPE.LONG -> Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.attack_destroy");
        case USE_TYPE.SINGLE -> Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.attack_single");
    }));
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "destroy");
    FakePlayer fakePlayer;
    boolean startDestroyBlock = false;
    float progress = 0.0f;
    int tickLast = 0;
    int storedSlotMainHand = -1;
    int storedSlotOffHand = -1;

    public CommonAttackAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        this.fakePlayer = WrappedMaidFakePlayer.get(this.maid);
        this.maid.m_21573_().m_26573_();
        ItemStack targetItem = this.craftGuideStepData.getInput().get(0);
        ItemStack targetItem2 = this.craftGuideStepData.getInput().get(1);
        this.storedSlotMainHand = InvUtil.getTargetIndexInCrafting(this.maid, targetItem, 1);
        if (this.storedSlotMainHand == -1) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.storedSlotOffHand = InvUtil.getTargetIndexInCrafting(this.maid, targetItem2, 2, this.storedSlotMainHand);
        if (this.storedSlotOffHand == -1) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        InvUtil.swapHandAndSlot(this.maid, InteractionHand.OFF_HAND, this.storedSlotOffHand);
        InvUtil.swapHandAndSlot(this.maid, InteractionHand.MAIN_HAND, this.storedSlotMainHand);
        MemoryUtil.getCrafting(this.maid).setSwappingHandWhenCrafting(true);
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        if (this.startDestroyBlock) {
            return this.tickDestroyBlock();
        }
        if (!MoveUtil.setMovementIfColliedTarget((ServerLevel)this.maid.m_9236_(), this.maid, this.craftGuideStepData.storage.pos)) {
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        if (!this.hasBlockOnTarget()) {
            return AbstractCraftActionContext.Result.NOT_DONE_INTERRUPTABLE;
        }
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
        @Nullable List<ItemStack> ret = this.interactWithItemAndGetReturn();
        if (ret == null) {
            if (this.startDestroyBlock) {
                return AbstractCraftActionContext.Result.CONTINUE;
            }
            return AbstractCraftActionContext.Result.FAIL;
        }
        int resultPlaced = 0;
        for (ItemStack itemStack : ret) {
            ItemStack itemStack1 = InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), itemStack);
            int realPlaced = itemStack.m_41613_() - itemStack1.m_41613_();
            if (!itemStack1.m_41619_()) {
                InvUtil.throwItem(this.maid, itemStack1);
            }
            if (!ItemStackUtil.isSameInCrafting(itemStack, this.craftGuideStepData.getOutput().get(0))) continue;
            resultPlaced += realPlaced;
        }
        if (this.startDestroyBlock) {
            return AbstractCraftActionContext.Result.CONTINUE;
        }
        if (resultPlaced >= this.craftGuideStepData.getOutput().get(0).m_41613_()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        return AbstractCraftActionContext.Result.FAIL;
    }

    private boolean hasBlockOnTarget() {
        return !this.maid.m_9236_().m_8055_(this.craftGuideStepData.storage.pos).m_60795_();
    }

    private AbstractCraftActionContext.Result tickDestroyBlock() {
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
        BlockPos target = this.craftGuideStepData.getStorage().pos;
        BlockState targetBs = this.maid.m_9236_().m_8055_(target);
        if (this.fakePlayer.m_36298_(targetBs)) {
            int tickBetween = this.maid.f_19797_ - this.tickLast;
            this.progress += targetBs.m_60625_((Player)this.fakePlayer, (BlockGetter)this.maid.m_9236_(), target) * (float)tickBetween;
        } else {
            return AbstractCraftActionContext.Result.FAIL;
        }
        this.tickLast = this.maid.f_19797_;
        if (this.progress >= 1.0f) {
            ServerLevel level = (ServerLevel)this.maid.m_9236_();
            FluidState fluidState = level.m_6425_(target);
            if (!(targetBs.m_60734_() instanceof BaseFireBlock)) {
                level.m_46796_(2001, target, Block.m_49956_((BlockState)targetBs));
            }
            MutableInt totalGet = new MutableInt(0);
            BlockEntity blockEntity = targetBs.m_155947_() ? level.m_7702_(target) : null;
            CombinedInvWrapper availableInv = this.maid.getAvailableInv(false);
            Block.m_49874_((BlockState)targetBs, (ServerLevel)level, (BlockPos)target, (BlockEntity)blockEntity, (Entity)this.maid, (ItemStack)this.maid.m_21205_()).forEach(stack -> {
                ItemStack originalStack = stack.m_41777_();
                ItemStack remindItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)stack, (boolean)false);
                if (ItemStackUtil.isSameInCrafting(originalStack, this.craftGuideStepData.getOutput().get(0))) {
                    totalGet.add(originalStack.m_41613_() - remindItemStack.m_41613_());
                }
                if (!remindItemStack.m_41619_()) {
                    Block.m_49840_((Level)level, (BlockPos)target, (ItemStack)remindItemStack);
                }
            });
            targetBs.m_222967_(level, target, this.maid.m_21205_(), true);
            this.maid.m_21205_().m_41622_(1, (LivingEntity)this.fakePlayer, p_186374_ -> p_186374_.m_21190_(InteractionHand.MAIN_HAND));
            boolean setResult = level.m_7731_(target, fluidState.m_76188_(), 3);
            if (setResult) {
                level.m_220407_(GameEvent.f_157794_, target, GameEvent.Context.m_223719_((Entity)this.maid, (BlockState)targetBs));
            }
            if (totalGet.getValue() >= this.craftGuideStepData.getOutput().get(0).m_41613_()) {
                return AbstractCraftActionContext.Result.SUCCESS;
            }
            return AbstractCraftActionContext.Result.FAIL;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Nullable
    private List<ItemStack> interactWithItemAndGetReturn() {
        BlockPos target = this.craftGuideStepData.getStorage().getPos();
        ServerLevel level = (ServerLevel)this.maid.m_9236_();
        BlockHitResult result = this.getBlockHitResult(level, this.craftGuideStepData.getStorage());
        if (result == null || !result.m_82425_().equals((Object)target)) {
            return null;
        }
        PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((Player)this.fakePlayer, (BlockPos)target, (Direction)this.craftGuideStepData.getStorage().side, (ServerboundPlayerActionPacket.Action)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK);
        if (this.craftGuideStepData.getOptionSelection(OPTION_USE_METHOD).orElse(USE_TYPE.SINGLE) == USE_TYPE.LONG && event.getUseBlock() != Event.Result.DENY) {
            this.onStartDestroyBlock(level, target);
        }
        Inventory inventory = this.fakePlayer.m_150109_();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            ItemStackUtil.addToList(items, inventory.m_8020_(i), true);
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
        return items;
    }

    private BlockHitResult getBlockHitResult(ServerLevel level, Target target) {
        BlockHitResult result = null;
        for (float disToSize = 0.5f; disToSize > 0.0f; disToSize -= 0.1f) {
            for (Direction direction : Direction.values()) {
                if (this.craftGuideStepData.getStorage().side != null && this.craftGuideStepData.getStorage().side != direction) continue;
                ClipContext rayTraceContext = new ClipContext(this.maid.m_20318_(0.0f).m_82520_(0.0, (double)this.maid.m_20192_(), 0.0), target.pos.m_252807_().m_231075_(direction, (double)disToSize), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.fakePlayer);
                result = level.m_45547_(rayTraceContext);
                if (result.m_82425_().equals((Object)target.pos) && (target.side == null || result.m_82434_() == target.side)) break;
                result = null;
            }
            if (result != null) break;
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    private void onStartDestroyBlock(ServerLevel level, BlockPos target) {
        level.m_8055_(target).m_60686_((Level)level, target, (Player)this.fakePlayer);
        this.startDestroyBlock = true;
        this.progress = 0.0f;
        this.tickLast = this.maid.f_19797_;
    }

    @Override
    public void stop() {
        if (this.storedSlotMainHand != -1) {
            InvUtil.swapHandAndSlot(this.maid, InteractionHand.MAIN_HAND, this.storedSlotMainHand);
        }
        if (this.storedSlotOffHand != -1) {
            InvUtil.swapHandAndSlot(this.maid, InteractionHand.OFF_HAND, this.storedSlotOffHand);
        }
        MemoryUtil.getCrafting(this.maid).setSwappingHandWhenCrafting(false);
    }

    @Override
    public boolean skipNextBreath() {
        return this.startDestroyBlock;
    }

    public static enum USE_TYPE {
        LONG,
        SINGLE;

    }
}

