/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2serial.serialization.unified_processor;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2serial.serialization.type_cache.ClassCache;
import dev.xkmc.l2serial.serialization.type_cache.TypeInfo;
import dev.xkmc.l2serial.serialization.unified_processor.UnifiedCodec;
import dev.xkmc.l2serial.serialization.unified_processor.UnifiedContext;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class TreeContext<E, O extends E, A extends E>
extends UnifiedContext<E, O, A> {
    private final Optional<Pair<E, Optional<ClassCache>>> nil;

    protected TreeContext(Optional<Pair<E, Optional<ClassCache>>> nil) {
        this.nil = nil;
    }

    @Override
    public E getKeyOfEntry(O obj) {
        return this.retrieve(obj, "_key");
    }

    @Override
    public E getValueOfEntry(O obj) {
        return this.retrieve(obj, "_val");
    }

    @Override
    public void setKeyOfEntry(O obj, E e) {
        this.addField(obj, "_key", e);
    }

    @Override
    public void setValueOfEntry(O obj, E e) {
        this.addField(obj, "_val", e);
    }

    @Override
    public Optional<Pair<E, Optional<ClassCache>>> writeRealClass(TypeInfo cls, @Nullable Object obj) throws Exception {
        ClassCache cache;
        if (obj == null) {
            return this.nil;
        }
        Optional special = UnifiedCodec.serializeSpecial(this, cls, obj);
        if (special.isPresent()) {
            return Optional.of(Pair.of(special.get().get(), Optional.empty()));
        }
        if (obj.getClass() != cls.getAsClass() && (cache = ClassCache.get(obj.getClass())).getSerialAnnotation() != null) {
            Object ans = this.createMap();
            this.addField(ans, "_class", this.fromString(obj.getClass().getName()));
            return Optional.of(Pair.of(ans, Optional.of(cache)));
        }
        return Optional.empty();
    }

    @Override
    public void addOptionalClass(O obj, Class<?> objcls, Class<?> clsinfo) {
        if (objcls != clsinfo) {
            this.addField(obj, "_class", this.fromString(obj.getClass().getName()));
        }
    }
}

