/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.maid.behavior.GoCenterBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.cowork.CoWorkChestView;
import studio.fantasyit.maid_storage_manager.maid.behavior.cowork.FollowActionBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.cowork.FollowDisableBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.cowork.FollowEnableBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.logistics.LogisticsSwitchTask;
import studio.fantasyit.maid_storage_manager.maid.behavior.logistics.craft.LogisticCraftWorkBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.logistics.craft.LogisticCraftWorkMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.logistics.input.LogisticsInputBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.logistics.input.LogisticsInputMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.logistics.output.LogisticsOutputBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.logistics.output.LogisticsOutputMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.logistics.recycle.LogisticsRecycleBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.logistics.recycle.LogisticsRecycleMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.meal.MealBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.meal.MealMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.place.PlaceBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.place.PlaceMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.place.ThrowToPlaceBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.FindListItemBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.InteractAfterDone;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.CraftExitBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.CraftInitBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.dispatched.DispatchedGatherBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.dispatched.DispatchedGatherMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.gather.RequestCraftGatherBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.gather.RequestCraftGatherMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.ret.ReturnOnVehicleBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.work.RequestCraftWorkBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.work.RequestCraftWorkMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.find.RequestFindBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.find.RequestFindMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.ret.RequestRetBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.ret.RequestRetMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.stock.StockCheckBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.request.stock.StockCheckMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.resort.ResortBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.resort.ResortMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.sorting.SortingBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.sorting.SortingMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.view.ViewBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.view.ViewMoveBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.view.WriteInventoryListBehavior;
import studio.fantasyit.maid_storage_manager.maid.config.StorageManagerMaidConfigGui;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class StorageManageTask
implements IMaidTask {
    public static ResourceLocation TASK_ID = new ResourceLocation("maid_storage_manager", "storage_manage");

    public boolean enableEating(@NotNull EntityMaid maid) {
        return switch (MemoryUtil.getCurrentlyWorking(maid)) {
            case ScheduleBehavior.Schedule.VIEW, ScheduleBehavior.Schedule.NO_SCHEDULE -> true;
            default -> false;
        };
    }

    public boolean enableLookAndRandomWalk(@NotNull EntityMaid maid) {
        return MemoryUtil.getCurrentlyWorking(maid) == ScheduleBehavior.Schedule.MEAL;
    }

    @NotNull
    public ResourceLocation getUid() {
        return TASK_ID;
    }

    @NotNull
    public ItemStack getIcon() {
        return Items.f_42009_.m_7968_();
    }

    @Nullable
    public SoundEvent getAmbientSound(@NotNull EntityMaid entityMaid) {
        return (SoundEvent)InitSounds.MAID_IDLE.get();
    }

    @NotNull
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid entityMaid) {
        ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>> list = new ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>>();
        list.add(Pair.of((Object)10, (Object)((Object)new GoCenterBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new FindListItemBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new RequestFindBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new RequestFindMoveBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new RequestRetMoveBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new RequestRetBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new StockCheckMoveBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new StockCheckBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new DispatchedGatherMoveBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new DispatchedGatherBehavior())));
        list.add(Pair.of((Object)9, (Object)((Object)new RequestCraftGatherBehavior())));
        list.add(Pair.of((Object)9, (Object)((Object)new RequestCraftGatherMoveBehavior())));
        list.add(Pair.of((Object)8, (Object)((Object)new RequestCraftWorkBehavior())));
        list.add(Pair.of((Object)8, (Object)((Object)new RequestCraftWorkMoveBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new CraftExitBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new CraftInitBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new ViewMoveBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new ViewBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new WriteInventoryListBehavior())));
        list.add(Pair.of((Object)6, (Object)((Object)new ResortBehavior())));
        list.add(Pair.of((Object)6, (Object)((Object)new ResortMoveBehavior())));
        list.add(Pair.of((Object)6, (Object)((Object)new SortingBehavior())));
        list.add(Pair.of((Object)6, (Object)((Object)new SortingMoveBehavior())));
        list.add(Pair.of((Object)7, (Object)((Object)new PlaceBehavior())));
        list.add(Pair.of((Object)7, (Object)((Object)new PlaceMoveBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new ScheduleBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new InteractAfterDone())));
        list.add(Pair.of((Object)5, (Object)((Object)new CoWorkChestView())));
        list.add(Pair.of((Object)5, (Object)((Object)new FollowActionBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new FollowEnableBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new FollowDisableBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new LogisticsSwitchTask())));
        list.add(Pair.of((Object)5, (Object)((Object)new LogisticsOutputMoveBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new LogisticsOutputBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new LogisticsInputMoveBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new LogisticsInputBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new LogisticCraftWorkMoveBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new LogisticCraftWorkBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new LogisticsRecycleBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new LogisticsRecycleMoveBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new MealBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new MealMoveBehavior())));
        return list;
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>> list = new ArrayList<Pair<Integer, BehaviorControl<? super EntityMaid>>>();
        list.add(Pair.of((Object)10, (Object)((Object)new FindListItemBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new RequestFindBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new RequestFindMoveBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new RequestRetMoveBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new RequestRetBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new StockCheckMoveBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new StockCheckBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new CraftExitBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new CraftInitBehavior())));
        list.add(Pair.of((Object)9, (Object)((Object)new ReturnOnVehicleBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new ThrowToPlaceBehavior())));
        list.add(Pair.of((Object)5, (Object)((Object)new WriteInventoryListBehavior())));
        list.add(Pair.of((Object)10, (Object)((Object)new ScheduleBehavior())));
        return list;
    }

    @NotNull
    public MenuProvider getTaskConfigGuiProvider(final @NotNull EntityMaid maid) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory playerInventory, Player player) {
                return new StorageManagerMaidConfigGui.Container(index, playerInventory, maid.m_19879_());
            }
        };
    }
}

