/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.work;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class RequestCraftWorkMoveBehavior
extends Behavior<EntityMaid> {
    CraftLayerChain plan;
    CraftLayer layer;
    Target target;

    public RequestCraftWorkMoveBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        if (MemoryUtil.getCurrentlyWorking(owner) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(owner).isReturning()) {
            return false;
        }
        if (!Conditions.takingRequestList(owner)) {
            return false;
        }
        if (MemoryUtil.getCrafting(owner).isGatheringDispatched()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(owner).hasPlan()) {
            return false;
        }
        return MemoryUtil.getCrafting(owner).plan().isCurrentWorking();
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        this.plan = MemoryUtil.getCrafting(maid).plan();
        this.layer = this.plan.getCurrentLayer();
        for (int i = 0; i < 3; ++i) {
            if (!this.targeting(level, maid)) continue;
            return;
        }
    }

    private boolean targeting(ServerLevel level, EntityMaid maid) {
        CraftGuideStepData step = this.layer.getStepData();
        if (step == null) {
            if (!this.layer.getItems().isEmpty()) {
                this.plan.setStatusMessage(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.crafting_success", (Object[])new Object[]{this.layer.getItems().get(0).m_41786_()}).m_130940_(ChatFormatting.GREEN));
            }
            DebugData.sendDebug("[REQUEST_CRAFT_WORK] Step Done. Set Success.", new Object[0]);
            for (int i = 0; i < this.layer.getItems().size(); ++i) {
                ItemStack itemStack = this.layer.getItems().get(i);
                if (itemStack.m_41619_()) continue;
                RequestListItem.updateCollectedItem(maid.m_21205_(), itemStack, itemStack.m_41613_(), true);
            }
            MemoryUtil.getCrafting(maid).lastSuccess();
            this.plan.finishCurrentLayer(maid);
            this.plan.showCraftingProgress(maid);
            MemoryUtil.getCrafting(maid).resetAndMarkVis(level, maid);
            MemoryUtil.getRequestProgress(maid).setReturn();
            MemoryUtil.getRequestProgress(maid).clearTarget();
            MemoryUtil.clearTarget(maid);
            return true;
        }
        if (this.plan.checkIsCurrentOccupied(level, maid)) {
            if (!this.plan.tryUseAnotherCraftGuide(level, maid) && this.plan.tryReleaseAndStartNext()) {
                MemoryUtil.getCrafting(maid).clearTarget();
                MemoryUtil.clearTarget(maid);
            }
            return true;
        }
        this.plan.setOccupied(level, maid);
        if (!this.plan.checkStepInputInbackpack(maid)) {
            return true;
        }
        Target storage = step.getStorage();
        DebugData.sendDebug(String.format("[REQUEST_CRAFT_WORK]Step %d [%d/%d], %s", this.layer.getStep(), this.layer.getDoneCount(), this.layer.getCount(), storage), new Object[0]);
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(maid.m_21573_().m_26575_(), level, maid);
        BlockPos blockPos = step.actionType.pathFindingTargetProvider().find(maid, this.layer.getCraftData().get(), step, this.layer, pathFinding);
        if (blockPos != null) {
            MemoryUtil.setTarget(maid, blockPos, (float)Config.craftWorkSpeed);
            MemoryUtil.getCrafting(maid).setTarget(storage);
            MemoryUtil.setLookAt(maid, storage.getPos());
            MemoryUtil.getCrafting(maid).resetPathFindingFailCount();
        } else {
            MemoryUtil.getCrafting(maid).addPathFindingFailCount();
            if (MemoryUtil.getCrafting(maid).getPathFindingFailCount() > 180) {
                MemoryUtil.goRestrictCenterAndWait(maid, (float)Config.craftWorkSpeed);
            }
            if (MemoryUtil.getCrafting(maid).getPathFindingFailCount() > 200) {
                List<ItemStack> missing = this.layer.getCraftData().map(CraftGuideData::getOutput).orElse(List.of());
                DebugData.sendDebug("[REQUEST_CRAFT_WORK]Path finding fail.", new Object[0]);
                this.plan.failCurrent(maid, missing, "tooltip.maid_storage_manager.request_list.fail_cannot_path_reach_crafting");
                MemoryUtil.getCrafting(maid).resetPathFindingFailCount();
            }
        }
        return true;
    }
}

