/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.cowork;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import studio.fantasyit.maid_storage_manager.advancement.AdvancementTypes;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;

public class FollowEnableBehavior
extends MaidCheckRateTask {
    public FollowEnableBehavior() {
        super(Map.of((MemoryModuleType)MemoryModuleRegistry.CO_WORK_MODE.get(), MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (!super.checkExtraStartConditions(worldIn, maid)) {
            return false;
        }
        if (!((StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault())).coWorkMode()) {
            return false;
        }
        if (!this.ownerStateConditions(maid.m_269323_())) {
            return false;
        }
        if (!maid.m_21444_(maid.m_269323_().m_20183_())) {
            return false;
        }
        return !(maid.m_20270_((Entity)maid.m_269323_()) > 8.0f) || maid.m_142582_((Entity)maid.m_269323_());
    }

    protected void start(ServerLevel p_22540_, EntityMaid maid, long p_22542_) {
        maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.CO_WORK_MODE.get(), (Object)true);
        AdvancementTypes.triggerForMaid(maid, "cowork");
        DebugData.sendDebug("[CO_WORK]Enable", new Object[0]);
        ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.cowork_enable");
    }

    private boolean ownerStateConditions(@Nullable LivingEntity owner) {
        return owner != null && !owner.m_5833_() && !owner.m_21224_();
    }
}

