/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid;

import com.github.tartaricacid.touhoulittlemaid.ai.service.function.FunctionCallRegister;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.IFunctionCall;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidExtension;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.entity.ai.IExtraMaidBrain;
import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.client.overlay.MaidTipsOverlay;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DebugTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ExtraMaidBrainManager;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.data.TaskDataRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.ai.CoWorkSwitchFunction;
import studio.fantasyit.maid_storage_manager.ai.FindAndMarkStorageFunction;
import studio.fantasyit.maid_storage_manager.ai.GetStorageFunction;
import studio.fantasyit.maid_storage_manager.ai.StorageFetchFunction;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.MaidInteractItem;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.maid.task.StorageManageTask;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_storage_manager.render.CraftingChatBubbleData;

@LittleMaidExtension
public class MaidExtension
implements ILittleMaid {
    public void addMaidTask(TaskManager manager) {
        super.addMaidTask(manager);
        manager.add((IMaidTask)new StorageManageTask());
    }

    public void bindMaidBauble(BaubleManager manager) {
        manager.bind((Item)ItemRegistry.STORAGE_DEFINE_BAUBLE.get(), (IMaidBauble)ItemRegistry.STORAGE_DEFINE_BAUBLE.get());
        manager.bind((Item)ItemRegistry.LOGISTICS_GUIDE.get(), (IMaidBauble)ItemRegistry.LOGISTICS_GUIDE.get());
        manager.bind((Item)ItemRegistry.PORTABLE_CRAFT_CALCULATOR_BAUBLE.get(), (IMaidBauble)ItemRegistry.PORTABLE_CRAFT_CALCULATOR_BAUBLE.get());
        manager.bind((Item)ItemRegistry.WORK_CARD.get(), (IMaidBauble)ItemRegistry.WORK_CARD.get());
    }

    public void addExtraMaidBrain(ExtraMaidBrainManager manager) {
        manager.addExtraMaidBrain(new IExtraMaidBrain(){

            public List<MemoryModuleType<?>> getExtraMemoryTypes() {
                return List.of((MemoryModuleType)MemoryModuleRegistry.VIEWED_INVENTORY.get(), (MemoryModuleType)MemoryModuleRegistry.RETURN_TO_SCHEDULE_AT.get(), (MemoryModuleType)MemoryModuleRegistry.PLACING_INVENTORY.get(), (MemoryModuleType)MemoryModuleRegistry.REQUEST_PROGRESS.get(), (MemoryModuleType)MemoryModuleRegistry.RESORTING.get(), (MemoryModuleType)MemoryModuleRegistry.SORTING.get(), (MemoryModuleType)MemoryModuleRegistry.CRAFTING.get(), (MemoryModuleType)MemoryModuleRegistry.LOGISTICS.get(), (MemoryModuleType)MemoryModuleRegistry.CURRENTLY_WORKING.get(), (MemoryModuleType)MemoryModuleRegistry.INTERACTION_RESULT.get(), (MemoryModuleType)MemoryModuleRegistry.CO_WORK_MODE.get(), (MemoryModuleType)MemoryModuleRegistry.CO_WORK_TARGET_STORAGE.get(), (MemoryModuleType)MemoryModuleRegistry.MEAL.get(), (MemoryModuleType)MemoryModuleRegistry.IS_WORKING.get(), (MemoryModuleType)MemoryModuleRegistry.PARALLEL_WORKING.get(), (MemoryModuleType)MemoryModuleRegistry.ENABLE_PICKUP_TEMP.get(), (MemoryModuleType)MemoryModuleRegistry.RETURN_CENTER.get());
            }
        });
    }

    public void registerTaskData(TaskDataRegister register) {
        StorageManagerConfigData.KEY = register.register((TaskDataKey)new StorageManagerConfigData());
    }

    public void registerAIFunctionCall(FunctionCallRegister register) {
        register.register((IFunctionCall)new StorageFetchFunction());
        register.register((IFunctionCall)new GetStorageFunction());
        register.register((IFunctionCall)new CoWorkSwitchFunction());
        register.register((IFunctionCall)new FindAndMarkStorageFunction());
    }

    public void addMaidTips(MaidTipsOverlay maidTipsOverlay) {
        maidTipsOverlay.addSpecialTips("tip.maid_storage_manager.interact_maid", (stack, maid, player) -> {
            if (!maid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID)) {
                return false;
            }
            return stack.m_41720_() instanceof MaidInteractItem;
        });
        maidTipsOverlay.addSpecialTips("tip.maid_storage_manager.change_flag", (stack, maid, player) -> {
            if (!maid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID)) {
                return false;
            }
            return stack.m_150930_((Item)ItemRegistry.CHANGE_FLAG.get());
        });
        maidTipsOverlay.addTips("tip.maid_storage_manager.experience_bottle", new Item[]{Items.f_42612_});
    }

    public Collection<? extends Function<EntityMaid, List<DebugTarget>>> getMaidDebugTargets() {
        if (!Config.aiFunctions) {
            return List.of();
        }
        return List.of(DebugData::commonTargets, DebugData::placeSuppresses);
    }

    public void registerChatBubble(ChatBubbleRegister register) {
        register.register(CraftingChatBubbleData.ID, (IChatBubbleData.ChatSerializer)new CraftingChatBubbleData.CraftingChatSerializer());
    }
}

