/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.integration.request;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.data.InventoryListDataClient;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.task.StorageManageTask;
import studio.fantasyit.maid_storage_manager.network.JEIRequestPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.util.InventoryListUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class IngredientRequestClient {
    private static final ResourceLocation R = new ResourceLocation("maid_storage_manager", "textures/gui/jei_request.png");
    public static boolean keyPressed = false;
    public static int preferMaidId = -1;
    public static int multiple = 1;
    public static Component preferMaidName = Component.m_237113_((String)"");
    public static float maidAnimated = 0.0f;
    public static int lastAnimatedMaidId = -1;
    public static int hasButtonTick = 0;
    static long lastTick = 0L;

    public static void hasButton() {
        hasButtonTick = 5;
    }

    public static void drawIcon(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        guiGraphics.m_280163_(R, xOffset, yOffset, 0.0f, 0.0f, 9, 9, 9, 9);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)(xOffset + 11), (float)(yOffset + 8), 0.0f);
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, String.valueOf(multiple), 0, 0, 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
    }

    private static ItemStack getPriorityFromUUID(UUID uuid, ItemStack itemStack, int number) {
        return InventoryListDataClient.getInstance().get(uuid).stream().filter(i -> ItemStackUtil.isSame(i.itemStack, itemStack, false)).filter(i -> i.totalCount > number).max(Comparator.comparingInt(i -> i.totalCount)).map(i -> i.itemStack).orElse(ItemStack.f_41583_);
    }

    public static void processRequestNearByClient(List<List<ItemStack>> data) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        NonNullList inventoryItems = player.m_150109_().f_35974_;
        UUID inventoryListUUID = InventoryListUtil.getInventoryListUUIDFromPlayerInv((List<ItemStack>)player.m_150109_().f_35974_);
        ArrayList costed = new ArrayList();
        ArrayList<ItemStack> toRequest = new ArrayList<ItemStack>();
        for (List<ItemStack> toSelect : data) {
            if (toSelect.size() == 0) continue;
            MutableObject priority = new MutableObject();
            boolean notFound = true;
            for (ItemStack itemStack : toSelect) {
                MutableInt sum = new MutableInt(0);
                Stream<ItemStack> itemStackStream = inventoryItems.stream().filter(i -> ItemStackUtil.isSame(i, itemStack, false)).map(i -> {
                    ItemStack costedCurrent = costed.stream().filter(ii -> ItemStackUtil.isSame(ii, itemStack, false)).findFirst().orElse(ItemStack.f_41583_);
                    sum.add(i.m_41613_() - costedCurrent.m_41613_());
                    return i;
                });
                if (sum.intValue() > 0) {
                    if (priority.getValue() == null) {
                        priority.setValue((Object)itemStack);
                    }
                    if (sum.intValue() >= itemStack.m_41613_()) {
                        notFound = false;
                        break;
                    }
                }
                itemStackStream.forEach(i -> costed.add(i.m_255036_(i.m_41613_() * multiple)));
            }
            if (notFound && inventoryListUUID != null) {
                priority.setValue((Object)InventoryListUtil.getMatchingFromInventory(inventoryListUUID, toSelect));
            }
            if (priority.getValue() == null) {
                priority.setValue((Object)toSelect.get(0));
            }
            if (priority.getValue() == null || !notFound) continue;
            ItemStackUtil.addToList(toRequest, (ItemStack)priority.getValue(), false);
        }
        toRequest.forEach(i -> i.m_41764_(i.m_41613_() * multiple));
        if (toRequest.size() > 0) {
            Network.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new JEIRequestPacket(toRequest, preferMaidId));
        }
    }

    public static void tickClient() {
        if (keyPressed) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null || player == null) {
                return;
            }
            List entities = level.m_142425_(EntityTypeTest.m_156916_(EntityMaid.class), player.m_20191_().m_82377_(10.0, 7.0, 10.0), e -> e.m_21830_((LivingEntity)player) && e.getTask().getUid().equals((Object)StorageManageTask.TASK_ID) && MemoryUtil.getCurrentlyWorking(e) == ScheduleBehavior.Schedule.CO_WORK);
            if (preferMaidId != -1 && entities.stream().noneMatch(e -> e.m_19879_() == preferMaidId)) {
                preferMaidId = -1;
            }
            if (entities.size() == 0) {
                preferMaidId = -1;
            } else if (preferMaidId == -1) {
                preferMaidId = ((EntityMaid)entities.get(0)).m_19879_();
                preferMaidName = ((EntityMaid)entities.get(0)).m_5446_();
            }
        } else {
            preferMaidId = -1;
            multiple = 1;
        }
        if (hasButtonTick > 0) {
            --hasButtonTick;
        }
        IngredientRequestClient.tickAnimation();
    }

    public static void tickAnimation() {
        long currentTick = System.currentTimeMillis();
        if (lastTick == 0L) {
            lastTick = currentTick;
            return;
        }
        float deltaTick = (float)(currentTick - lastTick) / 1000.0f;
        lastTick = currentTick;
        maidAnimated = keyPressed && preferMaidId != -1 && lastAnimatedMaidId == preferMaidId ? (float)((double)maidAnimated + (double)deltaTick / 0.5) : (float)((double)maidAnimated - (double)deltaTick / 0.5);
        maidAnimated = Math.max(0.0f, Math.min(1.0f, maidAnimated));
        if (preferMaidId != lastAnimatedMaidId && maidAnimated == 0.0f) {
            lastAnimatedMaidId = preferMaidId;
        }
    }

    public static void renderGui(GuiGraphics guiGraphics, int mouseX, int mouseY, Screen screen) {
        Entity entity;
        if (!Config.renderMaidWhenIngredientRequest) {
            return;
        }
        if (hasButtonTick == 0) {
            return;
        }
        if (maidAnimated == 0.0f) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (lastAnimatedMaidId != -1 && (entity = level.m_6815_(lastAnimatedMaidId)) instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            int x = screen.f_96543_ / 2;
            int y = (int)((float)(screen.f_96544_ + 100) - 75.0f * maidAnimated);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
            InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)x, (int)y, (int)50, (float)(x - mouseX), (float)((float)y - maid.m_20192_() * 50.0f - (float)mouseY), (LivingEntity)maid);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public static void scroll(double scrollDelta) {
        int i;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        int n = i = scrollDelta < 0.0 ? -1 : 1;
        if (player.m_6144_()) {
            i *= 10;
        }
        multiple += i;
        multiple = Math.max(1, multiple);
    }
}

