/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.menu.base.AbstractFilterScreen;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;

public class GhostIngredientHandler
implements IGhostIngredientHandler<AbstractFilterScreen> {
    @NotNull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AbstractFilterScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        if (ingredient.getType() != VanillaTypes.ITEM_STACK) {
            return List.of();
        }
        ArrayList<IGhostIngredientHandler.Target<I>> result = new ArrayList<IGhostIngredientHandler.Target<I>>();
        List slots = gui.getSlots();
        for (FilterSlot slot : slots) {
            result.add(new GhostTarget(gui, slot));
        }
        return result;
    }

    public void onComplete() {
    }

    private static class GhostTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        private final Rect2i area;
        private final AbstractFilterScreen<?> gui;
        private final FilterSlot slot;

        public GhostTarget(AbstractFilterScreen<?> gui, FilterSlot slot) {
            this.gui = gui;
            this.slot = slot;
            this.area = new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 16, 16);
        }

        @NotNull
        public Rect2i getArea() {
            return this.area;
        }

        public void accept(@NotNull I ingredient) {
            ItemStack stack = ((ItemStack)ingredient).m_41777_();
            stack.m_41764_(1);
            this.gui.accept(this.slot, stack);
        }
    }
}

