/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.create;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonIdleAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateIngredientUtil;
import studio.fantasyit.maid_storage_manager.craft.generator.util.RecipeUtil;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public abstract class GeneratorCreate<T extends ProcessingRecipe<C>, R extends RecipeType<T>, C extends Container, S>
implements IAutoCraftGuideGenerator {
    protected static boolean isAllFluidHasBucket(List<FluidIngredient> ingredients) {
        if (ingredients.isEmpty()) {
            return true;
        }
        return ingredients.stream().allMatch(fluidIngredient -> fluidIngredient.getMatchingFluidStacks().stream().map(FluidStack::getFluid).map(Fluid::m_6859_).findAny().isPresent());
    }

    protected static boolean isFluidHasBucket(List<FluidStack> fluidStack) {
        if (fluidStack.isEmpty()) {
            return true;
        }
        return fluidStack.stream().allMatch(fs -> fs.getFluid().m_6859_() != Items.f_41852_);
    }

    protected static Optional<List<Ingredient>> transformFluidIngredient(List<FluidIngredient> ingredients) {
        if (ingredients.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ingredients.stream().map(fluidIngredient -> {
            ItemStack[] array = (ItemStack[])fluidIngredient.getMatchingFluidStacks().stream().map(FluidStack::getFluid).map(Fluid::m_6859_).map(ItemStack::new).toArray(ItemStack[]::new);
            return Ingredient.m_43927_((ItemStack[])array);
        }).toList());
    }

    protected static Optional<List<ItemStack>> transformFluidStacks(List<FluidStack> fluidStack, int multiplier) {
        if (fluidStack == null || fluidStack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(fluidStack.stream().map(t -> t.getFluid().m_6859_().m_7968_().m_255036_(t.getAmount() * multiplier / 1000)).toList());
    }

    protected static Optional<ItemStack> optionalItemStack(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return Optional.empty();
        }
        return Optional.of(itemStack);
    }

    protected static Optional<List<ItemStack>> optionalItemStackList(List<ItemStack> itemStackList) {
        if (itemStackList == null || itemStackList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(itemStackList);
    }

    protected static Optional<List<Ingredient>> optionalIngredientList(List<Ingredient> ingredientList) {
        if (ingredientList == null || ingredientList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ingredientList);
    }

    protected static void each3items(List<ItemStack> itemStackList, Consumer<List<ItemStack>> consumer) {
        GenerateIngredientUtil.each3items(itemStackList, consumer);
    }

    abstract R getRecipeType();

    protected S getState(Level level, BlockPos pos, T recipe, ICachableGeneratorGraph graph) {
        return null;
    }

    protected int getMinFullBucketCount(T recipe) {
        MutableInt minFullBucketCount = new MutableInt(1);
        recipe.getFluidIngredients().forEach(fluidIngredient -> {
            int times = MathUtil.lcm(1000, fluidIngredient.getRequiredAmount()) / fluidIngredient.getRequiredAmount();
            minFullBucketCount.setValue(MathUtil.lcm(minFullBucketCount.getValue(), times));
        });
        recipe.getFluidResults().forEach(fluidStack -> {
            int times = MathUtil.lcm(1000, fluidStack.getAmount()) / fluidStack.getAmount();
            minFullBucketCount.setValue(MathUtil.lcm(minFullBucketCount.getValue(), times));
        });
        return minFullBucketCount.getValue();
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        this.addRecipeForPos(level, pos, this.getRecipeType(), graph, t -> true);
    }

    protected void addRecipeForPos(Level level, BlockPos pos, R type, ICachableGeneratorGraph graph, Predicate<T> predicate) {
        StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, pos);
        level.m_7465_().m_44013_(type).stream().filter(predicate).forEach(recipe -> {
            int multiplier = this.getMinFullBucketCount(recipe);
            if (!GeneratorCreate.isAllFluidHasBucket((List<FluidIngredient>)recipe.getFluidIngredients()) || !GeneratorCreate.isFluidHasBucket((List<FluidStack>)recipe.getFluidResults())) {
                return;
            }
            List itemIngredients = GeneratorCreate.optionalIngredientList((List<Ingredient>)recipe.m_7527_()).orElse(List.of());
            List fluidBuckets = GeneratorCreate.transformFluidIngredient((List<FluidIngredient>)recipe.getFluidIngredients()).orElse(List.of());
            ArrayList<Ingredient> all = new ArrayList<Ingredient>();
            all.addAll(itemIngredients);
            all.addAll(fluidBuckets);
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            GeneratorCreate.optionalItemStack(recipe.m_8043_(level.m_9598_())).map(i -> i.m_255036_(i.m_41613_() * multiplier)).ifPresent(results::add);
            GeneratorCreate.transformFluidStacks((List<FluidStack>)recipe.getFluidResults(), multiplier).ifPresent(results::addAll);
            if (results.isEmpty() || !posFilter.isAvailable((ItemStack)results.get(0))) {
                return;
            }
            ArrayList<Integer> counts = new ArrayList<Integer>();
            itemIngredients.forEach(ingredient -> counts.add(Arrays.stream(ingredient.m_43908_()).findFirst().map(ItemStack::m_41613_).orElse(0) * multiplier));
            recipe.getFluidIngredients().forEach(ingredient -> counts.add(ingredient.getRequiredAmount() * multiplier / 1000));
            this.transformAllIngredients(recipe, all, counts);
            S state = this.getState(level, pos, recipe, graph);
            graph.addRecipe(this.wrapId(recipe.m_6423_()), all, counts, results, items -> {
                ArrayList<CraftGuideStepData> step = new ArrayList<CraftGuideStepData>();
                GeneratorCreate.optionalItemStackList(items.subList(0, itemIngredients.size())).ifPresent(itemStackList -> GeneratorCreate.each3items(itemStackList, spItems -> step.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), (List<ItemStack>)spItems, List.of(), CommonPlaceItemAction.TYPE))));
                this.transformSteps((T)recipe, (List<ItemStack>)items, state, (List<CraftGuideStepData>)step, StepGenerateStep.INPUT_ITEM);
                GeneratorCreate.optionalItemStackList(items.subList(itemIngredients.size(), itemIngredients.size() + fluidBuckets.size())).ifPresent(bucketList -> bucketList.forEach(bucket -> step.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.UP), List.of(bucket), List.of(Items.f_42446_.m_7968_().m_255036_(bucket.m_41613_())), CommonUseAction.TYPE))));
                this.transformSteps((T)recipe, (List<ItemStack>)items, state, (List<CraftGuideStepData>)step, StepGenerateStep.INPUT_FLUID);
                GeneratorCreate.each3items(recipe.getRollableResults().stream().filter(t -> t.getChance() >= 1.0f).map(ProcessingOutput::getStack).map(i -> i.m_255036_(i.m_41613_() * multiplier)).toList(), itemStacks -> step.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), List.of(), (List<ItemStack>)itemStacks, CommonTakeItemAction.TYPE)));
                this.transformSteps((T)recipe, (List<ItemStack>)items, state, (List<CraftGuideStepData>)step, StepGenerateStep.OUTPUT_ITEM);
                GeneratorCreate.each3items(recipe.getRollableResults().stream().filter(t -> t.getChance() < 1.0f).map(ProcessingOutput::getStack).map(i -> i.m_255036_(i.m_41613_() * multiplier)).toList(), itemStacks -> step.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), List.of(), (List<ItemStack>)itemStacks, CommonTakeItemAction.TYPE, ActionOptionSet.with(ActionOption.OPTIONAL, true))));
                this.transformSteps((T)recipe, (List<ItemStack>)items, state, (List<CraftGuideStepData>)step, StepGenerateStep.OUTPUT_ITEM_SELECTIVE);
                if (recipe.getRollableResults().isEmpty()) {
                    step.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), List.of(), List.of(), CommonIdleAction.TYPE, ActionOptionSet.with(CommonIdleAction.OPTION_WAIT, true, String.valueOf(100 * multiplier))));
                    this.transformSteps((T)recipe, (List<ItemStack>)items, state, (List<CraftGuideStepData>)step, StepGenerateStep.OUTPUT_FLUID_IDLE);
                }
                GeneratorCreate.transformFluidStacks((List<FluidStack>)recipe.getFluidResults(), multiplier).ifPresent(outputs -> outputs.forEach(output -> step.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.UP), List.of(Items.f_42446_.m_7968_()), List.of(output), CommonUseAction.TYPE))));
                this.transformSteps((T)recipe, (List<ItemStack>)items, state, (List<CraftGuideStepData>)step, StepGenerateStep.OUTPUT_FLUID);
                return new CraftGuideData(step, CommonType.TYPE);
            });
        });
    }

    private ResourceLocation wrapId(ResourceLocation id) {
        return RecipeUtil.wrapLocation(this.getType(), id);
    }

    public void transformAllIngredients(T recipe, List<Ingredient> all, List<Integer> counts) {
    }

    protected void transformSteps(T recipe, List<ItemStack> items, S state, List<CraftGuideStepData> step, StepGenerateStep generateStep) {
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_(this.getRecipeType()).stream().forEach(processingRecipe -> {
            List itemIngredients = GeneratorCreate.optionalIngredientList((List<Ingredient>)processingRecipe.m_7527_()).orElse(List.of());
            List fluidBuckets = GeneratorCreate.transformFluidIngredient((List<FluidIngredient>)processingRecipe.getFluidIngredients()).orElse(List.of());
            ArrayList<Ingredient> all = new ArrayList<Ingredient>();
            all.addAll(itemIngredients);
            all.addAll(fluidBuckets);
            ArrayList<Integer> counts = new ArrayList<Integer>();
            all.forEach(t -> counts.add(0));
            this.transformAllIngredients(processingRecipe, all, counts);
            RecipeIngredientCache.addRecipeCache(processingRecipe.m_6423_(), all);
        });
    }

    protected static enum StepGenerateStep {
        INIT,
        INPUT_ITEM,
        INPUT_FLUID,
        OUTPUT_ITEM,
        OUTPUT_FLUID_IDLE,
        OUTPUT_ITEM_SELECTIVE,
        OUTPUT_FLUID;

    }
}

