/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.botania;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonIdleAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPickupItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.config.ConfigTypes;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.Target;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.item.BotaniaItems;

public class GeneratorBotaniaRunicAltar
implements IAutoCraftGuideGenerator {
    ConfigTypes.ConfigType<Double> WAIT_TIME_SCALE = new ConfigTypes.ConfigType<Double>("wait_time_scale", 1.0, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.botania.runic_altar.wait_time"), ConfigTypes.ConfigTypeEnum.Double);

    @Override
    @NotNull
    public ResourceLocation getType() {
        return RunicAltarRecipe.TYPE_ID;
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_(BotaniaBlocks.runeAltar);
    }

    @Override
    public boolean positionalAvailable(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        return IAutoCraftGuideGenerator.super.positionalAvailable(level, maid, pos, pathFinding) && this.getSpreaderSpeed((Level)level, pos) > 0.0;
    }

    protected double getSpreaderSpeed(Level level, BlockPos pos) {
        return BlockPos.m_121990_((BlockPos)pos.m_7918_(-3, -3, -3), (BlockPos)pos.m_7918_(3, 3, 3)).map(t -> {
            ManaSpreaderBlockEntity msbe;
            BlockEntity patt3210$temp = level.m_7702_(t);
            return patt3210$temp instanceof ManaSpreaderBlockEntity ? (msbe = (ManaSpreaderBlockEntity)patt3210$temp) : null;
        }).filter(Objects::nonNull).filter(be -> be.getBinding() != null && be.getBinding().equals((Object)pos)).map(be -> {
            double distance = Math.sqrt(be.m_58899_().m_123331_((Vec3i)pos)) - 0.5;
            int flyTicks = (int)Math.ceil(distance / 0.2);
            return Float.valueOf(((float)be.getVariant().burstMana - (float)(flyTicks + 1) * be.getVariant().lossPerTick) / (float)Math.min(flyTicks, 20));
        }).max(Comparator.comparingDouble(t -> t.floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        double speed = this.getSpreaderSpeed(level, pos);
        level.m_7465_().m_44013_(BotaniaRecipeTypes.RUNE_TYPE).forEach(recipe -> {
            ArrayList<Ingredient> list = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.m_7527_());
            list.add(recipe.getReagent());
            list.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.twigWand}));
            ItemStack output = recipe.m_8043_(level.m_9598_());
            graph.addRecipe(recipe.m_6423_(), list, list.stream().map(t -> 1).toList(), output, items -> {
                ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                for (int i = 0; i < items.size() - 2; ++i) {
                    ItemStack t = (ItemStack)items.get(i);
                    steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of(t), List.of(), CommonUseAction.TYPE));
                }
                steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of(), List.of(), CommonIdleAction.TYPE, ActionOptionSet.with(CommonIdleAction.OPTION_WAIT, true, String.valueOf((int)((double)recipe.getManaUsage() / speed * this.WAIT_TIME_SCALE.getValue())))));
                ItemStack react = (ItemStack)items.get(items.size() - 2);
                steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of(react), List.of(), CommonUseAction.TYPE));
                ItemStack wand = (ItemStack)items.get(items.size() - 1);
                steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of(wand), List.of(wand), CommonUseAction.TYPE));
                steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of(), List.of(output), CommonPickupItemAction.TYPE));
                return new CraftGuideData(steps, CommonType.TYPE);
            });
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_(BotaniaRecipeTypes.RUNE_TYPE).forEach(t -> {
            ArrayList<Ingredient> list = new ArrayList<Ingredient>((Collection<Ingredient>)t.m_7527_());
            list.add(t.getReagent());
            list.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.twigWand}));
            RecipeIngredientCache.addRecipeCache(t.m_6423_(), list);
        });
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.botania.runic_altar");
    }

    @Override
    public boolean canCacheGraph() {
        return false;
    }
}

