/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.algo;

import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.core.RegistryAccess;
import studio.fantasyit.maid_storage_manager.Logger;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.GeneratorGraph;
import studio.fantasyit.maid_storage_manager.util.ThreadingUtil;

public class ThreadedGeneratorGraph
extends GeneratorGraph {
    ReentrantReadWriteLock tickLock = new ReentrantReadWriteLock();
    Future<?> running = null;

    public ThreadedGeneratorGraph(RegistryAccess registryAccess) {
        super(registryAccess);
    }

    @Override
    public void clearStates() {
        super.clearStates();
        this.running = null;
    }

    @Override
    public boolean process() {
        if (this.running != null) {
            return this.running.isDone();
        }
        this.running = ThreadingUtil.run(this::_process);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _process() {
        while (true) {
            boolean ret;
            if (!this.tickLock.writeLock().tryLock()) {
                continue;
            }
            try {
                ret = super.process();
            }
            catch (Exception e) {
                Logger.logger.error("In process craft guides generator", (Throwable)e);
                return;
            }
            finally {
                this.tickLock.writeLock().unlock();
            }
            if (ret) return;
        }
    }

    @Override
    public int getProcessedSteps() {
        this.tickLock.readLock().lock();
        int processedSteps1 = super.getProcessedSteps();
        this.tickLock.readLock().unlock();
        return processedSteps1;
    }

    @Override
    public int getPushedSteps() {
        this.tickLock.readLock().lock();
        int pushedSteps1 = super.getPushedSteps();
        this.tickLock.readLock().unlock();
        return pushedSteps1;
    }
}

