/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Logger;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;

public class InvConsumeSimulator {
    public static Codec<InvConsumeSimulator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ItemStack.f_41582_, (Codec)Codec.INT).fieldOf("itemConsumeCount").forGetter(t -> t.itemConsumeCount)).apply((Applicative)instance, InvConsumeSimulator::new));
    public boolean enableLog = false;
    Map<ItemStack, Integer> itemConsumeCount;
    Map<ItemStack, Integer> snapshot;

    public InvConsumeSimulator(Map<ItemStack, Integer> itemConsumeCount) {
        this.itemConsumeCount = new HashMap<ItemStack, Integer>(itemConsumeCount);
        this.snapshot = null;
    }

    public InvConsumeSimulator() {
        this.itemConsumeCount = new HashMap<ItemStack, Integer>();
    }

    public void addConsumeCount(ItemStack itemStack, int count) {
        if (this.enableLog && this.snapshot == null) {
            Logger.debug("[II]addConsumeCount %s %d", itemStack.m_41720_(), count);
        }
        HashSet<ItemStack> ks = new HashSet<ItemStack>(this.itemConsumeCount.keySet());
        for (ItemStack itemStack1 : ks) {
            if (!ItemStack.m_150942_((ItemStack)itemStack1, (ItemStack)itemStack)) continue;
            int currentCount = Math.min(itemStack1.m_41741_() - this.itemConsumeCount.get(itemStack1), count);
            this.itemConsumeCount.put(itemStack1, this.itemConsumeCount.get(itemStack1) + currentCount);
            if ((count -= currentCount) > 0) continue;
            return;
        }
        while (count > 0) {
            int currentCount = Math.min(itemStack.m_41741_(), count);
            this.itemConsumeCount.put(itemStack.m_41777_(), currentCount);
            count -= currentCount;
        }
    }

    public void removeConsumeCount(ItemStack itemStack, int count) {
        if (this.enableLog && this.snapshot == null) {
            Logger.debug("[II]removeConsumeCount %s %d", itemStack.m_41720_(), count);
        }
        HashSet<ItemStack> ks = new HashSet<ItemStack>(this.itemConsumeCount.keySet());
        for (ItemStack itemStack1 : ks) {
            if (!ItemStack.m_150942_((ItemStack)itemStack1, (ItemStack)itemStack)) continue;
            int currentCount = Math.min(this.itemConsumeCount.get(itemStack1), count);
            count -= currentCount;
            this.itemConsumeCount.put(itemStack1, this.itemConsumeCount.get(itemStack1) - currentCount);
            if (this.itemConsumeCount.get(itemStack1) == 0) {
                this.itemConsumeCount.remove(itemStack1);
                continue;
            }
            return;
        }
    }

    public int getCurrentSlotConsume() {
        return this.itemConsumeCount.size();
    }

    public void clear() {
        this.itemConsumeCount.clear();
    }

    public void addLayer(CraftLayer layer) {
        layer.getItems().forEach(itemStack -> this.addConsumeCount((ItemStack)itemStack, itemStack.m_41613_()));
        layer.getCraftData().ifPresent(craftData -> craftData.getAllOutputItemsWithOptional().forEach(itemStack -> this.addConsumeCount((ItemStack)itemStack, itemStack.m_41613_() * layer.getCount())));
    }

    public void addLayerOutput(CraftLayer layer) {
        layer.getCraftData().ifPresent(craftData -> craftData.getOutput().forEach(itemStack -> this.addConsumeCount((ItemStack)itemStack, itemStack.m_41613_() * layer.getCount())));
    }

    public void removeLayerOutput(CraftLayer layer) {
        layer.getCraftData().ifPresent(craftData -> craftData.getAllOutputItemsWithOptional().forEach(itemStack -> this.removeConsumeCount((ItemStack)itemStack, itemStack.m_41613_() * layer.getCount())));
    }

    public void removeLayer(CraftLayer layer) {
        layer.getItems().forEach(itemStack -> this.removeConsumeCount((ItemStack)itemStack, itemStack.m_41613_()));
        layer.getCraftData().ifPresent(craftData -> craftData.getAllOutputItemsWithOptional().forEach(itemStack -> this.removeConsumeCount((ItemStack)itemStack, itemStack.m_41613_() * layer.getCount())));
    }

    public void removeLayerInput(CraftLayer layer) {
        layer.getItems().forEach(itemStack -> this.removeConsumeCount((ItemStack)itemStack, itemStack.m_41613_()));
    }

    public List<Pair<ItemStack, Integer>> getRemain() {
        return this.itemConsumeCount.entrySet().stream().map(e -> new Pair((Object)((ItemStack)e.getKey()), (Object)((Integer)e.getValue()))).toList();
    }

    public void snapshot() {
        this.snapshot = new HashMap<ItemStack, Integer>(this.itemConsumeCount);
    }

    public void restoreSnapshot() {
        if (this.snapshot == null) {
            throw new IllegalStateException("snapshot is null");
        }
        this.itemConsumeCount = this.snapshot;
        this.snapshot = null;
    }
}

