/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.special;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import studio.fantasyit.maid_storage_manager.craft.WorkBlockTags;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class SmithingRecipeAction
extends AbstractCraftActionContext {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "smithing");

    public SmithingRecipeAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        if (this.craftGuideStepData.getStorage() == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        Level level = this.maid.m_9236_();
        if (!level.m_8055_(this.craftGuideStepData.storage.pos).m_204336_(WorkBlockTags.SMITHING_TABLE)) {
            return AbstractCraftActionContext.Result.NOT_DONE;
        }
        CombinedInvWrapper inv = this.maid.getAvailableInv(false);
        List<ItemStack> input = this.craftGuideStepData.getInput();
        List<ItemStack> output = this.craftGuideStepData.getOutput();
        int[] slotExtractCount = new int[inv.getSlots()];
        Arrays.fill(slotExtractCount, 0);
        boolean allMatch = true;
        for (int i = 0; i < input.size(); ++i) {
            boolean found = false;
            if (input.get(i).m_41619_()) continue;
            for (int j = 0; j < inv.getSlots(); ++j) {
                if (!ItemStack.m_41656_((ItemStack)inv.getStackInSlot(j), (ItemStack)input.get(i)) || inv.getStackInSlot(j).m_41613_() <= slotExtractCount[j]) continue;
                found = true;
                int n = j;
                slotExtractCount[n] = slotExtractCount[n] + 1;
                break;
            }
            if (found) continue;
            allMatch = false;
            break;
        }
        if (allMatch) {
            Optional<SmithingRecipe> recipe = RecipeUtil.getSmithingRecipe(level, input);
            if (recipe.isPresent()) {
                int maxCanPlace;
                ItemStack result = recipe.get().m_8043_(level.m_9598_());
                if (ItemStackUtil.isSameInCrafting(result, output.get(0))) {
                    this.craftLayer.addCurrentStepPlacedCounts(0, result.m_41613_());
                }
                if ((maxCanPlace = InvUtil.maxCanPlace((IItemHandler)inv, result)) >= result.m_41613_()) {
                    InvUtil.tryPlace((IItemHandler)inv, result);
                    for (int j = 0; j < inv.getSlots(); ++j) {
                        inv.extractItem(j, slotExtractCount[j], false);
                    }
                    level.m_46796_(1044, this.craftGuideStepData.storage.pos, 0);
                    return AbstractCraftActionContext.Result.SUCCESS;
                }
                return AbstractCraftActionContext.Result.FAIL;
            }
        } else {
            return AbstractCraftActionContext.Result.FAIL;
        }
        return AbstractCraftActionContext.Result.FAIL;
    }

    @Override
    public void stop() {
    }
}

