/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager;

import com.electronwill.nightconfig.core.CommentedConfig;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.CraftPlanEvaluator;

@Mod.EventBusSubscriber(modid="maid_storage_manager", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue ENABLE_DEBUG = BUILDER.comment("Print debug messages").define("debug_msg", false);
    private static final ForgeConfigSpec.BooleanValue ENABLE_AE2SUP = BUILDER.comment("Enable ae2 support(Maid may pickup things from terminal)").define("compat.ae2_support", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_RS_SUP = BUILDER.comment("Enable rs support(Maid may pickup things from rs)").define("compat.rs_support", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_MEK_SUP = BUILDER.comment("Enable Mekanism QIO support(Maid may pickup things from rs)").define("compat.mek_support", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_JEI_INGREDIENT_REQUEST = BUILDER.comment("Ingredient request for JEI").define("compat.jei_ingredient_request", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_EMI_INGREDIENT_REQUEST = BUILDER.comment("Ingredient request for EMI").define("compat.emi_ingredient_request", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_CREATE_STORAGE = BUILDER.comment("Enable create's stock ticker support for maid").define("compat.create_storage", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_TACZ = BUILDER.comment("Enable tacz recipe support").define("compat.create_stock_manager", true);
    private static final ForgeConfigSpec.BooleanValue ENABLE_CREATE_STORAGE_MANAGER = BUILDER.comment("Allow maid to act as create stock keeper around a stock ticker.").define("compat.create_stock_keeper", true);
    private static final ForgeConfigSpec.IntValue ENABLE_CREATE_STOCK_RANGE_V = BUILDER.comment("How far maid can control the stock ticker. Vertically").defineInRange("compat.create_stock_keeper_range_v", 16, 1, 256);
    private static final ForgeConfigSpec.IntValue ENABLE_CREATE_STOCK_RANGE_H = BUILDER.comment("How far maid can control the stock ticker. Horizontally").defineInRange("compat.create_stock_keeper_range_h", 7, 1, 64);
    private static final ForgeConfigSpec.ConfigValue<String> CREATE_ADDRESS_PATTERN = BUILDER.comment("The format of create package address.<UUID>,<UUID4>,<UUID8>,<TYPE>,<TYPE1>").define("compat.create_address_pattern", (Object)"maid<TYPE1>:<UUID4>");
    private static final ForgeConfigSpec.DoubleValue CRAFT_WORK_SPEED = BUILDER.comment("Speed when working crafting").defineInRange("speed.crafting_speed", 0.5, 0.0, 3.0);
    private static final ForgeConfigSpec.DoubleValue COLLECT_SPEED = BUILDER.comment("Speed when collecting requested list").defineInRange("speed.collect_speed", 0.5, 0.0, 3.0);
    private static final ForgeConfigSpec.DoubleValue VIEW_SPEED = BUILDER.comment("Speed when viewing chests in spare time").defineInRange("speed.view_speed", 0.3, 0.0, 3.0);
    private static final ForgeConfigSpec.DoubleValue VIEW_CHANGE_SPEED = BUILDER.comment("Speed when viewing chests in spare time").defineInRange("speed.view_change_speed", 0.5, 0.0, 3.0);
    private static final ForgeConfigSpec.DoubleValue PLACE_SPEED = BUILDER.comment("Speed when placing items to chests").defineInRange("speed.place_speed", 0.5, 0.0, 3.0);
    private static final ForgeConfigSpec.DoubleValue FOLLOW_SPEED = BUILDER.comment("Speed when following").defineInRange("speed.follow_speed", 0.5, 0.0, 3.0);
    private static final ForgeConfigSpec.IntValue MAX_STORE_TRIES = BUILDER.comment("Maximum times Maid will try to store items").defineInRange("behavior.max_store_tries", 3, 0, 999999);
    private static final ForgeConfigSpec.IntValue MAX_CRAFT_TRIES = BUILDER.comment("Maximum tick Maid will try to perform craft action").defineInRange("behavior.max_craft_tries", 600, 0, 9999999);
    private static final ForgeConfigSpec.IntValue MAX_LOGISTICS_TRIES = BUILDER.comment("Maximum logistics extract try will maid take").defineInRange("behavior.max_logistics_tries", 50, 0, 9999999);
    private static final ForgeConfigSpec.BooleanValue USE_ALL_STORAGE_BY_DEFAULT = BUILDER.comment("Enable maid from visiting all storages.").define("behavior.use_all_storage", false);
    private static final ForgeConfigSpec.DoubleValue PICKUP_REQUIRE_WHEN_PLACE = BUILDER.comment("How many free slots required to pickup items when placing(Value indicates the percentage of empty slots in the total slots").defineInRange("behavior.pickup_require_when_place", 0.5, 0.0, 1.0);
    private static final ForgeConfigSpec.BooleanValue REAL_WORK_SIM = BUILDER.comment("Maid will need to stop and stand by the block to work").define("behavior.real_work_sim", false);
    private static final ForgeConfigSpec.BooleanValue PICKUP_IGNORE_DELAY = BUILDER.comment("Maid will ignore delay when picking up items.").define("behavior.pickup_ignore_delay", true);
    private static final ForgeConfigSpec.BooleanValue NO_BUBBLE_FOR_SUB_TASK = BUILDER.comment("No showing bubbles for sub tasks").define("behavior.no_bubble_for_sub_task", false);
    private static final ForgeConfigSpec.EnumValue<ThrowMethod> THROW_ITEM_VECTOR = BUILDER.comment("How maid will throw Item.FINALLY_POS will try make the item stop at the position. GO_THROUGH will try to make item go through the target position. FIXED will always use the vector of length 0.6").defineEnum("behavior.throw_item_vector", (Enum)ThrowMethod.FINALLY_POS, (Enum[])ThrowMethod.values());
    private static final ForgeConfigSpec.BooleanValue TRY_GO_WORK_CENTER_WHEN_FAIL_PATHFINDING = BUILDER.comment("Try going to work center when fail pathfinding.").define("behavior.try_go_center_when_fail_pathfinding", false);
    private static final ForgeConfigSpec.ConfigValue<VirtualItemFrameRender> VIRTUAL_ITEM_FRAME_RENDER = BUILDER.comment("Virtual Item Frame's render method allow access/no access/filter.").defineEnum("render.virtual_item_frame_render", (Enum)VirtualItemFrameRender.LARGE);
    private static final ForgeConfigSpec.BooleanValue RENDER_MAID_WHEN_INGREDIENT_REQUEST = BUILDER.comment("Render the maid at the bottom of the screen when pressing ingredient request key.").define("render.maid_render_ingredient_request", true);
    private static final ForgeConfigSpec.BooleanValue USING_BETTER_LIGHT_ON_ITEM = BUILDER.comment("Using a direct light to make itemstack appears brighter.").define("render.using_better_light_on_item", true);
    private static final ForgeConfigSpec.BooleanValue FAST_PATH_SCHEDULE = BUILDER.comment("Disable the 'shortest path limitation' to gain faster path finding.").define("performance.fast_path_schedule", false);
    private static final ForgeConfigSpec.BooleanValue TWO_STEP_AI_RESPONSE = BUILDER.comment("Allow Maid call AI two times when doing some request.").define("ai.two_step_ai_response", true);
    private static final ForgeConfigSpec.BooleanValue AI_FUNCTIONS = BUILDER.comment("Enable function calls from this mod").define("ai.functions", true);
    private static final ForgeConfigSpec.BooleanValue GENERATE_VIRTUAL_ITEM_FRAME = BUILDER.comment("Generate virtual item frame entity when shift right-click with certain items.").define("utility.generate_virtual_item_frame", true);
    private static final ForgeConfigSpec.ConfigValue<List<String>> CRAFTING_SOLVER = BUILDER.comment("Crafting solver to use. [DFS/DFS_QUEUED/DFS_THREADED/TOPOLOGY]. Topology algorithm costs least but dose not support circular recipes.").define("crafting.solver", List.of(CraftSolver.DFS_THREADED.name()), o -> o instanceof List && Arrays.stream(CraftSolver.values()).map(Enum::name).toList().containsAll((List)o));
    private static final ForgeConfigSpec.IntValue CRAFTING_MAX_LAYER_LIMIT = BUILDER.comment("Max layer count limit when calculating plan. Increasing this value may cause a large lagging in some cases.").defineInRange("crafting.max_layer_limit", 10000, 100, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.BooleanValue CRAFTING_EXPERIMENTAL_OPTIMIZATION = BUILDER.comment("Some experimental optimization. If some crafting calculation cannot done successfully, try turn this off.").define("crafting.experimental_optimization", true);
    private static final ForgeConfigSpec.IntValue LOOP_SOLVER_MAX_KEEP_LENGTH = BUILDER.comment("Max length to calculate in loop solver.").defineInRange("crafting.loop_solver.max_length", 10, 0, 100);
    private static final ForgeConfigSpec.BooleanValue LOOP_SOLVER_PREVENT_INDIRECT_ITEM_SUPPLY = BUILDER.comment("Prevent item in loop that are fully input outside the loop.").define("crafting.loop_solver.prevent_indirect", true);
    private static final ForgeConfigSpec.BooleanValue LOOP_SOLVER_PREVENT_NEW_BYPRODUCT = BUILDER.comment("Prevent new byproduct from loop that's not available in graph.").define("crafting.loop_solver.prevent_new_byproduct", false);
    private static final ForgeConfigSpec.BooleanValue USE_NBT = BUILDER.comment("Match nbt for all items by default. Use #maid_storage_manager:no_nbt and #maid_storage_manager:use_nbt to modify.").define("crafting.nbt.default", false);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> NBT_NO_MATCH_PATH = BUILDER.comment("Specific those nbt that are ignored from comparing. Use syntax like 'a.b[c].d'.").defineListAllowEmpty("crafting.nbt.no_matching_path", () -> List.of("Damage"), o -> o instanceof String);
    private static final ForgeConfigSpec.BooleanValue CRAFTING_GENERATE_CRAFT_GUIDE = BUILDER.comment("Generate craft guides for vanilla recipes.").define("crafting.generate", false);
    private static final ForgeConfigSpec.BooleanValue CRAFTING_GENERATING_PARTIAL = BUILDER.comment("Generate recipes that has not all ingredients available.").define("crafting.generating.keep_partial", false);
    private static final ForgeConfigSpec.BooleanValue CRAFTING_GENERATING_NEAREST_ONLY = BUILDER.comment("Only generate recipe with nearest block to maid.").define("crafting.generating.nearest_only", false);
    private static final ForgeConfigSpec.EnumValue<CraftGenerator> CRAFTING_GENERATOR = BUILDER.comment("Crafting generator algorithm to use.").defineEnum("crafting.generating.algorithm", (Enum)CraftGenerator.RELEVANCE_THREADED, (Enum[])CraftGenerator.values());
    private static final ForgeConfigSpec.BooleanValue CRAFTING_NO_CALCULATOR = BUILDER.comment("No need portable calculator for crafting").define("crafting.no_calculator", false);
    private static final ForgeConfigSpec.EnumValue<CraftPlanEvaluator> CRAFTING_PREFER_SHORTEST_PATH = BUILDER.comment("The way to select the correct crafting path.").defineEnum("crafting.shortest_path_evaluator", (Enum)CraftPlanEvaluator.CRAFT_GUIDES, (Enum[])CraftPlanEvaluator.values());
    private static final ForgeConfigSpec.DoubleValue INV_LIST_DAMAGE_FACTOR = BUILDER.defineInRange("misc.inv_list_damage.factor", (double)0.025f, 0.0, 1.0);
    private static final ForgeConfigSpec.DoubleValue INV_LIST_DAMAGE_MAX = BUILDER.defineInRange("misc.inv_list_damage.max", 20.0, 0.0, 1.0E7);
    private static final ForgeConfigSpec.DoubleValue INV_LIST_DAMAGE_MIN = BUILDER.defineInRange("misc.inv_list_damage.min", 2.0, 0.0, 1.0E7);
    private static final ForgeConfigSpec.DoubleValue INV_LIST_DAMAGE_ATTACK_SPD = BUILDER.defineInRange("misc.inv_list_damage.speed", (double)1.2f, 0.0, 100.0);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean enableDebug;
    public static boolean enableDebugInv;
    public static boolean enableAe2Sup;
    public static boolean enableRsSup;
    public static boolean enableMekSup;
    public static boolean enableJeiIngredientRequest;
    public static boolean enableEmiIngredientRequest;
    public static boolean enableCreateStorage;
    public static boolean enableCreateStockManager;
    public static boolean enableTacz;
    public static int createStockKeeperRangeV;
    public static int createStockKeeperRangeH;
    public static String createAddress;
    public static double collectSpeed;
    public static double viewSpeed;
    public static double placeSpeed;
    public static double viewChangeSpeed;
    public static double craftWorkSpeed;
    public static int maxStoreTries;
    public static int maxCraftTries;
    public static int maxLogisticsTries;
    public static boolean useAllStorageByDefault;
    public static double followSpeed;
    public static ThrowMethod throwItemVector;
    public static VirtualItemFrameRender virtualItemFrameRender;
    public static boolean renderMaidWhenIngredientRequest;
    public static boolean usingBetterLightOnItems;
    public static boolean twoStepAiResponse;
    public static double pickupRequireWhenPlace;
    public static boolean fastPathSchedule;
    public static boolean realWorkSim;
    public static boolean aiFunctions;
    public static boolean generateVirtualItemFrame;
    public static boolean pickupIgnoreDelay;
    public static boolean tryGoingWorkCenterWhenFailPathFinding;
    public static List<CraftSolver> craftingSolver;
    public static boolean craftingMatchTag;
    public static int craftingLoopSolverMaxSize;
    public static boolean craftingExperimentalOptimization;
    public static boolean craftingLoopSolverPreventIndirect;
    public static boolean craftingLoopSolverPreventNewByProduct;
    public static List<String> noMatchPaths;
    public static boolean craftingGenerateCraftGuide;
    public static boolean craftingNoCalculator;
    public static CraftPlanEvaluator craftingShortestPathEvaluator;
    public static boolean generatePartial;
    public static boolean generateNearestOnly;
    public static CraftGenerator craftingGenerator;
    public static boolean noBubbleForSub;
    public static int craftingMaxLayerLimit;
    public static double invListDamageFactor;
    public static double invListDamageMax;
    public static double invListDamageMin;
    public static double invListDamageAttackSpd;
    static boolean changed;

    public static void testLoad(CommentedConfig config) {
        BUILDER.build().acceptConfig(config);
        Config.onLoad();
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        Config.onLoad();
    }

    static void onLoad() {
        enableDebug = (Boolean)ENABLE_DEBUG.get();
        enableAe2Sup = (Boolean)ENABLE_AE2SUP.get();
        enableRsSup = (Boolean)ENABLE_RS_SUP.get();
        enableMekSup = (Boolean)ENABLE_MEK_SUP.get();
        enableJeiIngredientRequest = (Boolean)ENABLE_JEI_INGREDIENT_REQUEST.get();
        enableEmiIngredientRequest = (Boolean)ENABLE_EMI_INGREDIENT_REQUEST.get();
        enableCreateStorage = (Boolean)ENABLE_CREATE_STORAGE.get();
        enableCreateStockManager = (Boolean)ENABLE_CREATE_STORAGE_MANAGER.get();
        enableTacz = (Boolean)ENABLE_TACZ.get();
        createStockKeeperRangeV = (Integer)ENABLE_CREATE_STOCK_RANGE_V.get();
        createStockKeeperRangeH = (Integer)ENABLE_CREATE_STOCK_RANGE_H.get();
        createAddress = (String)CREATE_ADDRESS_PATTERN.get();
        collectSpeed = (Double)COLLECT_SPEED.get();
        viewSpeed = (Double)VIEW_SPEED.get();
        placeSpeed = (Double)PLACE_SPEED.get();
        maxStoreTries = (Integer)MAX_STORE_TRIES.get();
        maxCraftTries = (Integer)MAX_CRAFT_TRIES.get();
        maxLogisticsTries = (Integer)MAX_LOGISTICS_TRIES.get();
        craftWorkSpeed = (Double)CRAFT_WORK_SPEED.get();
        virtualItemFrameRender = (VirtualItemFrameRender)((Object)VIRTUAL_ITEM_FRAME_RENDER.get());
        useAllStorageByDefault = (Boolean)USE_ALL_STORAGE_BY_DEFAULT.get();
        viewChangeSpeed = (Double)VIEW_CHANGE_SPEED.get();
        followSpeed = (Double)FOLLOW_SPEED.get();
        twoStepAiResponse = (Boolean)TWO_STEP_AI_RESPONSE.get();
        pickupRequireWhenPlace = (Double)PICKUP_REQUIRE_WHEN_PLACE.get();
        fastPathSchedule = (Boolean)FAST_PATH_SCHEDULE.get();
        realWorkSim = (Boolean)REAL_WORK_SIM.get();
        aiFunctions = (Boolean)AI_FUNCTIONS.get();
        generateVirtualItemFrame = (Boolean)GENERATE_VIRTUAL_ITEM_FRAME.get();
        renderMaidWhenIngredientRequest = (Boolean)RENDER_MAID_WHEN_INGREDIENT_REQUEST.get();
        craftingSolver = ((List)CRAFTING_SOLVER.get()).stream().map(CraftSolver::valueOf).toList();
        craftingExperimentalOptimization = (Boolean)CRAFTING_EXPERIMENTAL_OPTIMIZATION.get();
        pickupIgnoreDelay = (Boolean)PICKUP_IGNORE_DELAY.get();
        tryGoingWorkCenterWhenFailPathFinding = (Boolean)TRY_GO_WORK_CENTER_WHEN_FAIL_PATHFINDING.get();
        craftingMatchTag = (Boolean)USE_NBT.get();
        noMatchPaths = ((List)NBT_NO_MATCH_PATH.get()).stream().map(t -> t).toList();
        throwItemVector = (ThrowMethod)((Object)THROW_ITEM_VECTOR.get());
        craftingGenerateCraftGuide = (Boolean)CRAFTING_GENERATE_CRAFT_GUIDE.get();
        craftingNoCalculator = (Boolean)CRAFTING_NO_CALCULATOR.get();
        generatePartial = (Boolean)CRAFTING_GENERATING_PARTIAL.get();
        craftingLoopSolverMaxSize = (Integer)LOOP_SOLVER_MAX_KEEP_LENGTH.get();
        craftingLoopSolverPreventIndirect = (Boolean)LOOP_SOLVER_PREVENT_INDIRECT_ITEM_SUPPLY.get();
        craftingLoopSolverPreventNewByProduct = (Boolean)LOOP_SOLVER_PREVENT_NEW_BYPRODUCT.get();
        craftingGenerator = (CraftGenerator)((Object)CRAFTING_GENERATOR.get());
        craftingShortestPathEvaluator = (CraftPlanEvaluator)((Object)CRAFTING_PREFER_SHORTEST_PATH.get());
        noBubbleForSub = (Boolean)NO_BUBBLE_FOR_SUB_TASK.get();
        generateNearestOnly = (Boolean)CRAFTING_GENERATING_NEAREST_ONLY.get();
        usingBetterLightOnItems = (Boolean)USING_BETTER_LIGHT_ON_ITEM.get();
        craftingMaxLayerLimit = (Integer)CRAFTING_MAX_LAYER_LIMIT.get();
        invListDamageFactor = (Double)INV_LIST_DAMAGE_FACTOR.get();
        invListDamageMax = (Double)INV_LIST_DAMAGE_MAX.get();
        invListDamageMin = (Double)INV_LIST_DAMAGE_MIN.get();
        invListDamageAttackSpd = (Double)INV_LIST_DAMAGE_ATTACK_SPD.get();
    }

    public static void save() {
        ENABLE_DEBUG.set((Object)enableDebug);
        ENABLE_AE2SUP.set((Object)enableAe2Sup);
        ENABLE_RS_SUP.set((Object)enableRsSup);
        ENABLE_MEK_SUP.set((Object)enableMekSup);
        ENABLE_JEI_INGREDIENT_REQUEST.set((Object)enableJeiIngredientRequest);
        ENABLE_EMI_INGREDIENT_REQUEST.set((Object)enableEmiIngredientRequest);
        ENABLE_CREATE_STORAGE.set((Object)enableCreateStorage);
        ENABLE_CREATE_STORAGE_MANAGER.set((Object)enableCreateStockManager);
        ENABLE_TACZ.set((Object)enableTacz);
        ENABLE_CREATE_STOCK_RANGE_V.set((Object)createStockKeeperRangeV);
        ENABLE_CREATE_STOCK_RANGE_H.set((Object)createStockKeeperRangeH);
        CREATE_ADDRESS_PATTERN.set((Object)createAddress);
        COLLECT_SPEED.set((Object)collectSpeed);
        VIEW_SPEED.set((Object)viewSpeed);
        PLACE_SPEED.set((Object)placeSpeed);
        MAX_STORE_TRIES.set((Object)maxStoreTries);
        MAX_CRAFT_TRIES.set((Object)maxCraftTries);
        MAX_LOGISTICS_TRIES.set((Object)maxLogisticsTries);
        CRAFT_WORK_SPEED.set((Object)craftWorkSpeed);
        VIRTUAL_ITEM_FRAME_RENDER.set((Object)virtualItemFrameRender);
        USE_ALL_STORAGE_BY_DEFAULT.set((Object)useAllStorageByDefault);
        VIEW_CHANGE_SPEED.set((Object)viewChangeSpeed);
        FOLLOW_SPEED.set((Object)followSpeed);
        TWO_STEP_AI_RESPONSE.set((Object)twoStepAiResponse);
        PICKUP_REQUIRE_WHEN_PLACE.set((Object)pickupRequireWhenPlace);
        FAST_PATH_SCHEDULE.set((Object)fastPathSchedule);
        REAL_WORK_SIM.set((Object)realWorkSim);
        AI_FUNCTIONS.set((Object)aiFunctions);
        GENERATE_VIRTUAL_ITEM_FRAME.set((Object)generateVirtualItemFrame);
        RENDER_MAID_WHEN_INGREDIENT_REQUEST.set((Object)renderMaidWhenIngredientRequest);
        CRAFTING_SOLVER.set(craftingSolver.stream().map(Enum::name).toList());
        PICKUP_IGNORE_DELAY.set((Object)pickupIgnoreDelay);
        USE_NBT.set((Object)craftingMatchTag);
        NBT_NO_MATCH_PATH.set(noMatchPaths);
        THROW_ITEM_VECTOR.set((Object)throwItemVector);
        CRAFTING_EXPERIMENTAL_OPTIMIZATION.set((Object)craftingExperimentalOptimization);
        CRAFTING_GENERATE_CRAFT_GUIDE.set((Object)craftingGenerateCraftGuide);
        CRAFTING_NO_CALCULATOR.set((Object)craftingNoCalculator);
        CRAFTING_GENERATING_PARTIAL.set((Object)generatePartial);
        LOOP_SOLVER_MAX_KEEP_LENGTH.set((Object)craftingLoopSolverMaxSize);
        LOOP_SOLVER_PREVENT_INDIRECT_ITEM_SUPPLY.set((Object)craftingLoopSolverPreventIndirect);
        LOOP_SOLVER_PREVENT_NEW_BYPRODUCT.set((Object)craftingLoopSolverPreventNewByProduct);
        CRAFTING_GENERATOR.set((Object)craftingGenerator);
        CRAFTING_PREFER_SHORTEST_PATH.set((Object)craftingShortestPathEvaluator);
        NO_BUBBLE_FOR_SUB_TASK.set((Object)noBubbleForSub);
        CRAFTING_GENERATING_NEAREST_ONLY.set((Object)generateNearestOnly);
        USING_BETTER_LIGHT_ON_ITEM.set((Object)usingBetterLightOnItems);
        TRY_GO_WORK_CENTER_WHEN_FAIL_PATHFINDING.set((Object)tryGoingWorkCenterWhenFailPathFinding);
        CRAFTING_MAX_LAYER_LIMIT.set((Object)craftingMaxLayerLimit);
        INV_LIST_DAMAGE_FACTOR.set((Object)invListDamageFactor);
        INV_LIST_DAMAGE_MAX.set((Object)invListDamageMax);
        INV_LIST_DAMAGE_MIN.set((Object)invListDamageMin);
        INV_LIST_DAMAGE_ATTACK_SPD.set((Object)invListDamageAttackSpd);
    }

    public static void saveAfter(Runnable o) {
        o.run();
        changed = true;
    }

    public static void saveIfChanged() {
        if (changed) {
            Config.save();
            changed = false;
        }
    }

    static {
        enableDebugInv = false;
        changed = false;
    }

    public static enum VirtualItemFrameRender {
        SMALL,
        LARGE,
        FRAME,
        CORNER;

    }

    public static enum ThrowMethod {
        FINALLY_POS,
        GO_THROUGH,
        FIXED;

    }

    public static enum CraftGenerator {
        RELEVANCE,
        RELEVANCE_THREADED;

    }

    public static enum CraftSolver {
        TOPOLOGY,
        DFS,
        DFS_QUEUED,
        DFS_THREADED;

    }
}

