/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.menu;

import io.github.tt432.kitchenkarrot.item.CocktailItem;
import io.github.tt432.kitchenkarrot.item.ShakerItem;
import io.github.tt432.kitchenkarrot.menu.base.KKMenu;
import io.github.tt432.kitchenkarrot.menu.slot.KKResultSlot;
import io.github.tt432.kitchenkarrot.recipes.RecipeManager;
import io.github.tt432.kitchenkarrot.recipes.recipe.CocktailRecipe;
import io.github.tt432.kitchenkarrot.registries.ModMenuTypes;
import io.github.tt432.kitchenkarrot.registries.ModSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ShakerMenu
extends KKMenu {
    ItemStack itemStack;

    public ShakerMenu(int pContainerId, Inventory inventory) {
        super((MenuType)ModMenuTypes.SHAKER.get(), pContainerId, inventory);
        this.itemStack = inventory.m_36056_();
        if (!(this.itemStack.m_41720_() instanceof ShakerItem)) {
            this.m_6877_(inventory.f_35978_);
            return;
        }
        this.addSlots();
        this.finishRecipe(inventory.f_35978_);
    }

    private void sync() {
        this.itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(this::slotChanged);
    }

    private void finishRecipe(Player player) {
        if (ShakerItem.getFinish(this.itemStack)) {
            this.itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                if (player.m_9236_().f_46443_) {
                    return;
                }
                List<ItemStack> list = this.getInputs((IItemHandler)handler);
                Optional<CocktailRecipe> recipe = RecipeManager.getCocktailRecipes(this.inventory.f_35978_.m_9236_()).stream().filter(r -> r.matches(list)).findFirst();
                ItemStack recipeResult = CocktailItem.unknownCocktail();
                if (recipe.isPresent()) {
                    recipeResult = recipe.get().m_8043_((RegistryAccess)RegistryAccess.f_243945_);
                }
                if (list.stream().anyMatch(ItemStack::m_41619_)) {
                    return;
                }
                ItemStack result = handler.insertItem(11, recipeResult, false);
                if (!result.m_41619_()) {
                    this.inventory.f_35978_.m_36176_(result, true);
                }
                for (int i = 0; i < 5; ++i) {
                    handler.extractItem(i, 1, false);
                }
                this.slotChanged((IItemHandler)handler);
            });
            ShakerItem.setFinish(this.itemStack, false);
        }
    }

    List<ItemStack> getInputs(IItemHandler handler) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            list.add(handler.getStackInSlot(i));
        }
        return list;
    }

    void slotChanged(IItemHandler handler) {
        if (!handler.getStackInSlot(11).m_41619_()) {
            ShakerItem.setRecipeTime(this.itemStack, 0);
            return;
        }
        List<ItemStack> list = this.getInputs(handler);
        Optional<CocktailRecipe> recipe = RecipeManager.getCocktailRecipes(this.inventory.f_35978_.m_9236_()).stream().filter(r -> r.matches(list)).findFirst();
        if (recipe.isPresent()) {
            ShakerItem.setRecipeTime(this.itemStack, recipe.get().getContent().getCraftingTime());
        } else if (list.stream().anyMatch(ItemStack::m_41619_)) {
            ShakerItem.setRecipeTime(this.itemStack, 0);
        } else {
            ShakerItem.setRecipeTime(this.itemStack, 60);
        }
    }

    @Override
    protected Slot addSlot(final IItemHandler handler, int index, int x, int y) {
        return this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y){

            public void m_6654_() {
                super.m_6654_();
                ShakerMenu.this.slotChanged(handler);
            }
        });
    }

    protected void sound() {
        Player player = this.inventory.f_35978_;
        if (player.m_9236_().f_46443_) {
            player.m_5496_((SoundEvent)ModSoundEvents.SHAKER_COCKTAIL.get(), 0.5f, player.m_217043_().m_188501_() * 0.1f + 0.9f);
        }
    }

    @Override
    protected Slot addResultSlot(final IItemHandler handler, int index, int x, int y) {
        return this.m_38897_((Slot)new KKResultSlot(handler, index, x, y){

            public void m_6654_() {
                super.m_6654_();
                ShakerMenu.this.slotChanged(handler);
            }
        });
    }

    void addSlots() {
        this.itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            this.addSlot((IItemHandler)h, 0, 62, 22);
            this.addSlot((IItemHandler)h, 1, 80, 22);
            this.addSlot((IItemHandler)h, 2, 98, 22);
            this.addSlot((IItemHandler)h, 3, 71, 40);
            this.addSlot((IItemHandler)h, 4, 89, 40);
            this.addSlot((IItemHandler)h, 5, 8, 15);
            this.addSlot((IItemHandler)h, 6, 26, 15);
            this.addSlot((IItemHandler)h, 7, 8, 33);
            this.addSlot((IItemHandler)h, 8, 26, 33);
            this.addSlot((IItemHandler)h, 9, 8, 51);
            this.addSlot((IItemHandler)h, 10, 26, 51);
            this.addResultSlot((IItemHandler)h, 11, 144, 22);
        });
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.sync();
        if (pPlayer.m_9236_().f_46443_) {
            pPlayer.m_5496_((SoundEvent)ModSoundEvents.SHAKER_CLOSE.get(), 0.5f, pPlayer.m_217043_().m_188501_() * 0.1f + 0.9f);
        }
    }

    @Override
    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.invHandler, 9, 8, 80, 9, 18, 3, 18);
        this.addSlotRange(this.invHandler, 0, 8, 138, 9, 18);
    }

    public void m_150399_(int slot, int button, @NotNull ClickType type, @NotNull Player player) {
        try {
            Slot slotInstance = (Slot)this.f_38839_.get(slot);
            if (slotInstance.m_7993_().m_41720_() instanceof ShakerItem) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.m_150399_(slot, button, type, player);
    }
}

