/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.dependencies.jei.category;

import io.github.tt432.kitchenkarrot.dependencies.jei.JeiPlugin;
import io.github.tt432.kitchenkarrot.dependencies.jei.category.BaseRecipeCategory;
import io.github.tt432.kitchenkarrot.item.ModBlockItems;
import io.github.tt432.kitchenkarrot.recipes.recipe.AirCompressorRecipe;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AirCompressorRecipeCategory
extends BaseRecipeCategory<AirCompressorRecipe> {
    protected final IDrawableAnimated arrow;
    protected final IDrawable power;
    protected final ITickTimer timer;
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("kitchenkarrot", "textures/gui/jei.png");

    public AirCompressorRecipeCategory(IGuiHelper helper) {
        super(JeiPlugin.AIR_COMPRESSOR, helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlockItems.AIR_COMPRESSOR.get())), (IDrawable)helper.createDrawable(BACKGROUND, 0, 141, 104, 78));
        this.arrow = helper.drawableBuilder(BACKGROUND, 176, 0, 20, 19).buildAnimated(40, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.power = helper.drawableBuilder(BACKGROUND, 176, 32, 8, 5).build();
        this.timer = helper.createTickTimer(180, 194, false);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, AirCompressorRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredient = recipe.getIngredient();
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 32).addIngredients((Ingredient)ingredient.get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 49, 32).addIngredients((Ingredient)ingredient.get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 53).addIngredients((Ingredient)ingredient.get(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 49, 53).addIngredients((Ingredient)ingredient.get(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 9).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}));
        Ingredient container = Objects.requireNonNullElse(recipe.getContainer(), Ingredient.f_43901_);
        builder.addSlot(RecipeIngredientRole.INPUT, 49, 9).addIngredients(container);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 75, 32).addItemStack(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
    }

    public void draw(AirCompressorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 70, 52);
        for (int i = 0; i < this.timer.getValue() / 15; ++i) {
            this.power.draw(guiGraphics, 14, 64 - i * 5);
        }
    }
}

