/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.blockentity;

import io.github.tt432.kitchenkarrot.blockentity.sync.SyncDataManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseBlockEntity
extends BlockEntity {
    SyncDataManager syncDataManager = new SyncDataManager();
    private static final String SYNC_KEY = "sync";
    boolean forceOnce;

    public BaseBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
        this.syncDataInit(this.syncDataManager);
    }

    protected void syncDataInit(SyncDataManager manager) {
    }

    public void tick() {
        this.sync(this.f_58857_);
    }

    protected boolean isSyncTag(CompoundTag tag) {
        return tag.m_128441_(SYNC_KEY);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.syncDataManager.load(pTag, this.isSyncTag(pTag));
        if (!this.isSyncTag(pTag)) {
            this.forceOnce();
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.syncDataManager.save(pTag, false, true);
    }

    public void forceOnce() {
        this.forceOnce = true;
    }

    public CompoundTag m_5995_() {
        CompoundTag result = new CompoundTag();
        result.m_128379_(SYNC_KEY, true);
        this.syncDataManager.save(result, true, true);
        return result;
    }

    public abstract List<ItemStack> drops();

    public void sync(Level level) {
        if (!level.f_46443_) {
            ClientboundBlockEntityDataPacket p = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
            ((ServerLevel)this.f_58857_).m_7726_().f_8325_.m_183262_(new ChunkPos(this.m_58899_()), false).forEach(k -> k.f_8906_.m_9829_((Packet)p));
        }
    }

    public static <T extends BaseBlockEntity> void tick(Level level, BlockPos pos, BlockState state, T t) {
        t.tick();
    }
}

