/*
 * Decompiled with CFR 0.152.
 */
package io.github.tt432.kitchenkarrot.block;

import io.github.tt432.kitchenkarrot.block.FacingGuiEntityBlock;
import io.github.tt432.kitchenkarrot.blockentity.BrewingBarrelBlockEntity;
import io.github.tt432.kitchenkarrot.registries.ModBlockEntities;
import io.github.tt432.kitchenkarrot.registries.ModItems;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class BrewingBarrelBlock
extends FacingGuiEntityBlock<BrewingBarrelBlockEntity> {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final VoxelShape SHAPE_Z = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_X = Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);

    public BrewingBarrelBlock(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OPEN});
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        AtomicBoolean changed = new AtomicBoolean(false);
        pLevel.m_7702_(pPos).getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> {
            if (handler instanceof IFluidTank) {
                IFluidTank tank = (IFluidTank)handler;
                ItemStack item = pPlayer.m_21120_(pHand);
                ItemStack remain = ItemStack.f_41583_;
                if (item.m_41720_() == Items.f_42447_) {
                    FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, 1000);
                    if (tank.fill(water, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                        changed.set(true);
                        remain = new ItemStack((ItemLike)Items.f_42446_);
                        if (!pLevel.f_46443_) {
                            tank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    pPlayer.m_5496_(SoundEvents.f_11778_, 0.5f, pLevel.f_46441_.m_188501_() * 0.1f + 0.9f);
                } else if (item.m_41720_() == Items.f_42589_ && PotionUtils.m_43566_((CompoundTag)item.m_41783_()).isEmpty()) {
                    FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, 250);
                    if (tank.fill(water, IFluidHandler.FluidAction.SIMULATE) == 250) {
                        changed.set(true);
                        remain = new ItemStack((ItemLike)Items.f_42590_);
                        if (!pLevel.f_46443_) {
                            tank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    pPlayer.m_5496_(SoundEvents.f_11769_, 0.5f, pLevel.f_46441_.m_188501_() * 0.1f + 0.9f);
                } else if (item.m_41720_() == ModItems.WATER.get()) {
                    FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, 125);
                    if (tank.fill(water, IFluidHandler.FluidAction.SIMULATE) == 125) {
                        changed.set(true);
                        if (!pLevel.f_46443_) {
                            tank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    pPlayer.m_5496_(SoundEvents.f_11778_, 0.5f, pLevel.f_46441_.m_188501_() * 0.1f + 0.9f);
                } else if (!pLevel.m_5776_()) {
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
                    ((BrewingBarrelBlockEntity)this.getBlockEntity().m_58949_((BlockGetter)pLevel, pPos)).playSound(SoundEvents.f_11725_);
                }
                if (changed.get() && !pPlayer.m_150110_().f_35937_) {
                    item.m_41774_(1);
                    pPlayer.m_150109_().m_36054_(remain);
                }
            }
        });
        if (changed.get()) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @Override
    public BlockEntityType<BrewingBarrelBlockEntity> getBlockEntity() {
        return (BlockEntityType)ModBlockEntities.BREWING_BARREL.get();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            case Direction.NORTH, Direction.SOUTH -> SHAPE_Z;
            case Direction.EAST, Direction.WEST -> SHAPE_X;
            default -> SHAPE_Z;
        };
    }
}

