/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.inventory.fermentation_barrel;

import com.renyigesai.bakeries.block.fermentation_barrel.FermentationBarrelBlockEntity;
import com.renyigesai.bakeries.init.BakeriesMenuType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class FermentationBarrelMenu
extends AbstractContainerMenu {
    protected final FermentationBarrelBlockEntity blockEntity;
    private final Player player;
    private final IItemHandler playerInventory;

    public FermentationBarrelMenu(int windowId, Inventory playerInventory, FermentationBarrelBlockEntity blockEntity) {
        super((MenuType)BakeriesMenuType.FERMENTATION_BARREL_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.player = playerInventory.f_35978_;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        int inputStartX = 31;
        int inputStartY = 21;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                this.m_38897_((Slot)new SlotItemHandler(blockEntity.getInventory(), row * 3 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_((Slot)new SlotItemHandler(blockEntity.getInventory(), 7, 122, 24){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player playerIn) {
                return false;
            }
        });
        this.m_38897_((Slot)new SlotItemHandler(blockEntity.getInventory(), 8, 122, 53));
        this.layoutPlayerInventorySlots(8, 84);
    }

    public static FermentationBarrelMenu create(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        BlockPos pos = data.m_130135_();
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(pos);
        if (blockEntity instanceof FermentationBarrelBlockEntity) {
            return new FermentationBarrelMenu(windowId, playerInventory, (FermentationBarrelBlockEntity)blockEntity);
        }
        throw new IllegalStateException("Block entity is not an FermentationBarrelBlockEntity!");
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            originalStack = stackInSlot.m_41777_();
            if (slotIndex < 6 || slotIndex == 7 ? !this.m_38903_(stackInSlot, 8, 43, false) : !this.m_38903_(stackInSlot, 0, 6, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == originalStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return originalStack;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.m_6542_(player);
    }

    public FermentationBarrelBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

