/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block;

import com.renyigesai.bakeries.block.TankBlock;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class FermentationTankBlock
extends TankBlock {
    public static final IntegerProperty FLOUR = IntegerProperty.m_61631_((String)"flour", (int)0, (int)3);
    public static final BooleanProperty WATER = BooleanProperty.m_61465_((String)"water");

    public FermentationTankBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FLOUR, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATER, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        ItemStack handStack = pPlayer.m_21120_(pHand);
        int flour = (Integer)pState.m_61143_((Property)FLOUR);
        if (flour < 3 && handStack.m_150930_((Item)BakeriesItems.WHOLE_WHEAT_FLOUR.get())) {
            return FermentationTankBlock.fillFlour(pLevel, pPos, pState, pPlayer, pHand);
        }
        if (PotionUtils.m_43579_((ItemStack)handStack) == Potions.f_43599_ && !((Boolean)pState.m_61143_((Property)WATER)).booleanValue()) {
            return FermentationTankBlock.fillWater(pLevel, pPos, pState, pPlayer, pHand);
        }
        if (flour == 0 && handStack.m_150930_(Items.f_42455_)) {
            return FermentationTankBlock.fillMilk(pLevel, pPos, pState, pPlayer, pHand);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public static InteractionResult fillFlour(Level level, BlockPos pos, BlockState state, Player playerIn, InteractionHand pHand) {
        ItemStack handStack = playerIn.m_21120_(pHand);
        int flour = (Integer)state.m_61143_((Property)FLOUR);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)FLOUR, (Comparable)Integer.valueOf(flour + 1)), 3);
        handStack.m_41774_(1);
        level.m_5594_(null, pos, SoundEvents.f_12591_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult fillWater(Level level, BlockPos pos, BlockState state, Player playerIn, InteractionHand pHand) {
        ItemStack handStack = playerIn.m_21120_(pHand);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATER, (Comparable)Boolean.valueOf(true)), 0);
        handStack.m_41774_(1);
        playerIn.m_150109_().m_150079_(new ItemStack((ItemLike)Items.f_42590_));
        level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult fillMilk(Level level, BlockPos pos, BlockState state, Player playerIn, InteractionHand pHand) {
        ItemStack handStack = playerIn.m_21120_(pHand);
        handStack.m_41774_(1);
        playerIn.m_150109_().m_150079_(new ItemStack((ItemLike)Items.f_42446_));
        level.m_7731_(pos, ((Block)BakeriesBlocks.Milk_TANK.get()).m_49966_(), 3);
        level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public void m_213898_(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        int flour = (Integer)pState.m_61143_((Property)FLOUR);
        boolean water = (Boolean)pState.m_61143_((Property)WATER);
        if (flour == 3 && water) {
            pLevel.m_7731_(pPos, ((Block)BakeriesBlocks.YEAST_TANK.get()).m_49966_(), 3);
        }
    }

    public void m_214162_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        double d2;
        int flour = (Integer)pState.m_61143_((Property)FLOUR);
        boolean water = (Boolean)pState.m_61143_((Property)WATER);
        Direction direction = Direction.m_235672_((RandomSource)pRandom);
        double d0 = direction.m_122429_() == 0 ? pRandom.m_188500_() : 0.5 + (double)direction.m_122429_() * 0.6;
        double d1 = direction.m_122430_() == 0 ? pRandom.m_188500_() : 0.5 + (double)direction.m_122430_() * 0.6;
        double d = d2 = direction.m_122431_() == 0 ? pRandom.m_188500_() : 0.5 + (double)direction.m_122431_() * 0.6;
        if (flour == 3 && water) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pPos.m_123341_() + d0, (double)pPos.m_123342_() + d1, (double)pPos.m_123343_() + d2, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FLOUR, WATER});
    }

    public void m_6786_(@NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, BlockState pState) {
        int flour = (Integer)pState.m_61143_((Property)FLOUR);
        for (int i = 0; i < flour; ++i) {
            double x = (double)pPos.m_123341_() + 0.5;
            double y = (double)pPos.m_123342_() + 0.15;
            double z = (double)pPos.m_123343_() + 0.5;
            ItemEntity entity = new ItemEntity((Level)pLevel, x, y, z, new ItemStack((ItemLike)BakeriesItems.WHOLE_WHEAT_FLOUR.get()));
            pLevel.m_7967_((Entity)entity);
        }
    }
}

