/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.event;

import com.renyigesai.bakeries.accessor.VillagerAccessor;
import com.renyigesai.bakeries.api.event.PlayerLookBlockEvent;
import com.renyigesai.bakeries.block.glass_drink_cup.GlassDrinkCupBlockEntity;
import com.renyigesai.bakeries.client.LookBlockEntityMap;
import com.renyigesai.bakeries.config.BakeriesConfig;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.item.RepeatEatItem;
import com.renyigesai.bakeries.util.ItemUtil;
import com.renyigesai.bakeries.util.WorldUtil;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BakeriesEvents {
    @SubscribeEvent
    public static void onUseCreeper(PlayerInteractEvent.EntityInteract event) {
        Player entity = event.getEntity();
        Entity target = event.getTarget();
        if (entity != null && entity.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)BakeriesItems.BAGUETTE.get()) && target instanceof Creeper) {
            Level level = event.getEntity().m_9236_();
            double x = target.m_20185_();
            double y = target.m_20186_();
            double z = target.m_20189_();
            ItemStack hand = entity.m_21120_(InteractionHand.MAIN_HAND);
            if (((Creeper)target).m_217043_().m_188503_(3) == 0) {
                target.m_19983_(new ItemStack((ItemLike)BakeriesItems.MUSIC_DISC_BAKING_IN_PROGRESS.get()));
            }
            RepeatEatItem.rHurt(hand);
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42406_)), x, y + (double)(target.m_20206_() / 2.0f), z, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08);
            level.m_247517_(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.f_11912_, SoundSource.PLAYERS);
        }
    }

    @SubscribeEvent
    public static void onUseVillager(PlayerInteractEvent.EntityInteract event) {
        Player entity = event.getEntity();
        if (event.getHand() != entity.m_7655_()) {
            return;
        }
        ItemStack hand = entity.m_21120_(InteractionHand.MAIN_HAND);
        Entity target = event.getTarget();
        if (hand.m_150930_((Item)BakeriesItems.ICED_LATTE.get()) && target instanceof Villager) {
            Villager villager = (Villager)target;
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            villager.m_35510_();
            ((VillagerAccessor)villager).bakery$setNumberOfRestocksToday(0);
            RepeatEatItem.rHurt(entity, hand, new ItemStack((ItemLike)BakeriesItems.DRINK_CUP.get()));
            villager.m_9236_().m_247517_(null, BlockPos.m_274561_((double)villager.m_20185_(), (double)villager.m_20186_(), (double)villager.m_20189_()), SoundEvents.f_11911_, SoundSource.BLOCKS);
        }
    }

    @SubscribeEvent
    public static void onRightClickEgg(PlayerInteractEvent.RightClickItem event) {
        Player entity = event.getEntity();
        Level level = event.getLevel();
        if (entity == null || level == null) {
            return;
        }
        ItemStack mainHandItem = entity.m_21205_();
        ItemStack offhandItem = entity.m_21206_();
        if (offhandItem.m_150930_((Item)BakeriesItems.BREAD_KNIFE.get()) && mainHandItem.m_150930_(Items.f_42521_)) {
            if (!level.m_5776_()) {
                event.setCanceled(true);
                mainHandItem.m_41774_(1);
                ItemUtil.givePlayerItem(entity, new ItemStack((ItemLike)BakeriesItems.WHOLE_EGG.get()));
                if (!entity.m_150110_().f_35937_) {
                    offhandItem.m_41622_(1, (LivingEntity)entity, p_41300_ -> p_41300_.m_21190_(entity.m_7655_()));
                }
            }
            level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12533_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    @SubscribeEvent
    public static void onLookBlock(PlayerLookBlockEvent event) {
        Level level = event.getPlayer().m_9236_();
        Player player = event.getPlayer();
        BlockState state = event.getBlockState();
        BlockPos blockPos = event.getBlockPos();
        if (state.m_60734_() == BakeriesBlocks.DRINK_CUP.get()) {
            GlassDrinkCupBlockEntity blockEntity = (GlassDrinkCupBlockEntity)level.m_7702_(blockPos);
            LookBlockEntityMap.setBlocks(player, blockEntity);
            return;
        }
        Map<UUID, BlockEntity> blocks = LookBlockEntityMap.getBlocks();
        if (blocks.get(player.m_20148_()) != null) {
            blocks.remove(player.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!BakeriesConfig.provideTutorialBooks) {
            return;
        }
        Player entity = event.getEntity();
        if (!ModList.get().isLoaded("patchouli") && !entity.m_9236_().f_46443_) {
            entity.m_5661_((Component)Component.m_237115_((String)"tip.bakeries.player_logged_in"), false);
            return;
        }
        boolean b1 = WorldUtil.isDoneAdvancement(entity, entity.m_9236_(), new ResourceLocation("bakeries:root"));
        if (!b1) {
            LootTable lootTables = WorldUtil.getLootTables("bakeries:grant_patchi_book", entity.m_9236_());
            List<ItemStack> fromLootTableItemStack = WorldUtil.getFromLootTableItemStack(lootTables, entity.m_9236_(), entity.m_20097_());
            for (ItemStack itemStack : fromLootTableItemStack) {
                ItemUtil.givePlayerItem(entity, itemStack);
            }
        }
    }
}

