/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.wooden_tray;

import com.renyigesai.bakeries.block.wooden_tray.WoodenTrayBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WoodenTrayBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape BOX = WoodenTrayBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    public static final BooleanProperty RENDER_BLOCK = BooleanProperty.m_61465_((String)"render_block");

    public WoodenTrayBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)RENDER_BLOCK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BOX;
    }

    public InteractionResult m_6227_(BlockState pState, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WoodenTrayBlockEntity) {
            WoodenTrayBlockEntity woodenTrayBlockEntity = (WoodenTrayBlockEntity)blockEntity;
            ItemStack handStack = pPlayer.m_21120_(pHand);
            if (handStack.m_41619_()) {
                if (woodenTrayBlockEntity.canEmpty()) {
                    Boolean value = (Boolean)pState.m_61143_((Property)RENDER_BLOCK);
                    level.m_7731_(pos, (BlockState)pState.m_61124_((Property)RENDER_BLOCK, (Comparable)Boolean.valueOf(value == false)), 3);
                    this.playSound(level, pos, SoundEvents.f_12013_);
                    return InteractionResult.SUCCESS;
                }
                woodenTrayBlockEntity.takeOutItem(pPlayer);
                this.playSound(level, pos, SoundEvents.f_12016_);
                return InteractionResult.SUCCESS;
            }
            if (!handStack.m_41619_() && woodenTrayBlockEntity.addItem(handStack.m_41777_().m_41620_(1))) {
                if (!pPlayer.m_7500_()) {
                    handStack.m_41774_(1);
                }
                this.playSound(level, pos, SoundEvents.f_12013_);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.m_6227_(pState, level, pos, pPlayer, pHand, pHit);
    }

    private void playSound(Level level, BlockPos pos, SoundEvent soundEvent) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_247517_(null, pos, soundEvent, SoundSource.BLOCKS);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof WoodenTrayBlockEntity) {
                WoodenTrayBlockEntity woodenTrayBlockEntity = (WoodenTrayBlockEntity)blockEntity;
                woodenTrayBlockEntity.drops(woodenTrayBlockEntity);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{RENDER_BLOCK, FACING});
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new WoodenTrayBlockEntity(pPos, pState);
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"block.bakeries.wooden_tray.tips").m_130940_(ChatFormatting.GRAY));
    }
}

