/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.util.ItemStackUtil;
import com.github.wallev.maidsoulkitchen.util.MaidUtil;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WaterFdPotCookRuleCopy<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    private static final WaterFdPotCookRuleCopy INSTANCE = new WaterFdPotCookRuleCopy();

    public static <B extends BlockEntity, R extends Recipe<? extends Container>> WaterFdPotCookRuleCopy<B, R> getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        boolean hasMaidRecs;
        ItemStack needContainer;
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        boolean hasResult = cookBeBase.hasResult();
        if (canTakeResult && hasResult && hasOutputAvailableSlot) {
            return true;
        }
        boolean hasMeal = cookBeBase.hasMeal();
        if (hasMeal && !(needContainer = cookBeBase.getNeedContainer()).m_41619_() && cm.hasItem(needContainer)) {
            return true;
        }
        boolean hasEnoughFluid = cookBeBase.hasFluid();
        List<ItemStack> activeItemStacks = cookBeBase.getActiveItems();
        boolean hasFuel = cm.hasItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
        boolean matchCookState = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        if (matchCookState && (hasEnoughFluid || hasFuel) && !recMatch && (hasMaidRecs = cm.hasMaidRecs(cookBeBase))) {
            return true;
        }
        if (recMatch && !hasEnoughFluid && hasFuel && hasInputAvailableSlot) {
            return true;
        }
        boolean hasInputs = cookBeBase.hasInputs();
        if (!recMatch && hasInputs && hasInputAvailableSlot) {
            return true;
        }
        boolean hasContainer = cookBeBase.hasContainer();
        return !hasInputs && hasContainer;
    }

    @Override
    public void cookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        boolean pickAction = false;
        IItemHandlerModifiable inputInv = cm.getInputInv();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        ItemStack meal = cookBeBase.getMeal();
        ItemStack nowContainer = cookBeBase.getNowContainer();
        if (!meal.m_41619_()) {
            if (!nowContainer.m_41619_()) {
                cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
            }
            ItemStack needContainer = cookBeBase.getNeedContainer();
            ItemStack outputAdditionItem = cm.getItem(needContainer);
            cookBeBase.insertContainer(outputAdditionItem);
            cookBeBase.markChanged();
            pickAction = true;
        }
        boolean canTakeResult = cookBeBase.canTakeResult();
        ItemStack result = cookBeBase.getResult();
        if (canTakeResult && !result.m_41619_()) {
            cookBeBase.takeItem(result, (IItemHandler)outputInv);
            cookBeBase.awardExp();
            cookBeBase.markChanged();
            pickAction = true;
        }
        boolean matchCookState = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasInputs = cookBeBase.hasInputs();
        if (!matchCookState && !recMatch && hasInputs) {
            cookBeBase.takeInputs((IItemHandler)inputInv);
            cookBeBase.markChanged();
            pickAction = true;
        }
        if (!(matchCookState || recMatch || nowContainer.m_41619_())) {
            cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
            cookBeBase.markChanged();
            pickAction = true;
        }
        boolean hasEnoughFluid = cookBeBase.hasFluid();
        List<ItemStack> activeItemStacks = cookBeBase.getActiveItems();
        ItemStack fuel = cm.getItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
        if (matchCookState && (hasEnoughFluid || !fuel.m_41619_()) && !recMatch && cm.hasMaidRecs(cookBeBase)) {
            ItemInventory itemInventory = cm.getItemInventory();
            cookBeBase.insertInputs(cm.pollMaidRec(cookBeBase), itemInventory);
            cookBeBase.markChanged();
            cm.getItemInventory().markDirty();
            recMatch = true;
            pickAction = true;
        }
        if (recMatch && !hasEnoughFluid && !fuel.m_41619_()) {
            cookBeBase.useItem(fuel, () -> cookBeBase.hasFluid(), outputInv);
            cookBeBase.markChanged();
        }
        if (pickAction) {
            MaidUtil.pickupAction(cookBeBase);
        }
    }
}

