/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import studio.fantasyit.maid_storage_manager.maid.task.StorageManageTask;
import studio.fantasyit.maid_storage_manager.storage.Target;

public class StorageVisitLock {
    public static final Map<UUID, LockContext> MAID_TO_LOCK = new ConcurrentHashMap<UUID, LockContext>();
    public static final Map<Target, Integer> readLockCounter = new ConcurrentHashMap<Target, Integer>();
    public static final Map<Target, Boolean> writeLockCounter = new ConcurrentHashMap<Target, Boolean>();
    public static final Map<Target, Boolean> writeLockWaiting = new ConcurrentHashMap<Target, Boolean>();
    public static final LockContext DUMMY = new LockContext(false, Target.virtual(BlockPos.f_121853_, null), null){

        @Override
        public boolean checkAndTryGrantLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void release() {
        }
    };

    public static LockContext getReadLock(Target target, EntityMaid maid) {
        return new LockContext(false, target, maid);
    }

    public static LockContext getWriteLock(Target target, EntityMaid maid) {
        return new LockContext(true, target, maid);
    }

    private static synchronized boolean lockRead(Target pos) {
        if (writeLockCounter.getOrDefault(pos, false).booleanValue()) {
            return false;
        }
        if (writeLockWaiting.getOrDefault(pos, false).booleanValue()) {
            return false;
        }
        readLockCounter.put(pos, readLockCounter.getOrDefault(pos, 0) + 1);
        return true;
    }

    private static synchronized void unlockRead(Target pos) {
        if (readLockCounter.getOrDefault(pos, 0) <= 0) {
            throw new IllegalStateException("Trying to unlock a read lock that is not locked");
        }
        readLockCounter.put(pos, readLockCounter.getOrDefault(pos, 0) - 1);
    }

    private static synchronized boolean lockWrite(Target pos) {
        if (writeLockCounter.getOrDefault(pos, false).booleanValue()) {
            return false;
        }
        if (readLockCounter.getOrDefault(pos, 0) > 0) {
            writeLockWaiting.put(pos, true);
            return false;
        }
        if (writeLockWaiting.getOrDefault(pos, false).booleanValue()) {
            writeLockWaiting.put(pos, false);
        }
        writeLockCounter.put(pos, true);
        return true;
    }

    private static synchronized void unlockWrite(Target pos) {
        if (!writeLockCounter.get(pos).booleanValue()) {
            throw new IllegalStateException("Trying to unlock a write lock that is not locked");
        }
        writeLockCounter.put(pos, false);
    }

    public static void invalidateInvalidedLock() {
        HashSet<Map.Entry<UUID, LockContext>> entries = new HashSet<Map.Entry<UUID, LockContext>>(MAID_TO_LOCK.entrySet());
        for (Map.Entry<UUID, LockContext> entry : entries) {
            if (entry.getValue().isHolderValid()) continue;
            entry.getValue().release();
            MAID_TO_LOCK.remove(entry.getKey());
        }
    }

    public static class LockContext {
        boolean granted;
        final boolean isWriteLock;
        final Target target;
        final EntityMaid maid;

        public LockContext(boolean isWriteLock, Target target, EntityMaid maid) {
            this.maid = maid;
            this.isWriteLock = isWriteLock;
            this.target = target;
            this.tryGrantLock();
        }

        private void tryGrantLock() {
            if (this.granted) {
                return;
            }
            this.granted = this.isWriteLock ? StorageVisitLock.lockWrite(this.target) : StorageVisitLock.lockRead(this.target);
            if (this.granted && this.maid != null) {
                if (MAID_TO_LOCK.containsKey(this.maid.m_20148_())) {
                    MAID_TO_LOCK.get(this.maid.m_20148_()).release();
                }
                MAID_TO_LOCK.put(this.maid.m_20148_(), this);
            }
        }

        public boolean checkAndTryGrantLock() {
            if (this.granted) {
                return true;
            }
            this.tryGrantLock();
            return this.granted;
        }

        public void release() {
            if (this.granted) {
                if (this.isWriteLock) {
                    StorageVisitLock.unlockWrite(this.target);
                } else {
                    StorageVisitLock.unlockRead(this.target);
                }
                if (this.maid != null) {
                    MAID_TO_LOCK.remove(this.maid.m_20148_());
                }
            }
        }

        public boolean isHolderValid() {
            EntityMaid _maid;
            ServerLevel sl;
            Level level = this.maid.m_9236_();
            return level instanceof ServerLevel && (level = (sl = (ServerLevel)level).m_8791_(this.maid.m_20148_())) instanceof EntityMaid && (_maid = (EntityMaid)level).m_6084_() && _maid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID);
        }
    }
}

